/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.graphql.query.argument;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.v1.graphql.query.argument.Argument;
import technology.semi.weaviate.client.v1.graphql.query.argument.SortOrder;

public class SortArgument
implements Argument {
    private final String[] path;
    private final SortOrder order;

    @Override
    public String build() {
        LinkedHashSet<String> arg = new LinkedHashSet<String>();
        if (ArrayUtils.isNotEmpty((Object[])this.path)) {
            arg.add(String.format("path:[%s]", Arrays.stream(this.path).map(s -> String.format("\"%s\"", s)).collect(Collectors.joining(","))));
        }
        if (this.order != null) {
            arg.add(String.format("order:%s", new Object[]{this.order}));
        }
        return String.format("{%s}", StringUtils.joinWith((String)" ", (Object[])arg.toArray()));
    }

    SortArgument(String[] path, SortOrder order) {
        this.path = path;
        this.order = order;
    }

    public static SortArgumentBuilder builder() {
        return new SortArgumentBuilder();
    }

    public String[] getPath() {
        return this.path;
    }

    public SortOrder getOrder() {
        return this.order;
    }

    public String toString() {
        return "SortArgument(path=" + Arrays.deepToString(this.getPath()) + ", order=" + (Object)((Object)this.getOrder()) + ")";
    }

    public static class SortArgumentBuilder {
        private String[] path;
        private SortOrder order;

        SortArgumentBuilder() {
        }

        public SortArgumentBuilder path(String[] path) {
            this.path = path;
            return this;
        }

        public SortArgumentBuilder order(SortOrder order) {
            this.order = order;
            return this;
        }

        public SortArgument build() {
            return new SortArgument(this.path, this.order);
        }

        public String toString() {
            return "SortArgument.SortArgumentBuilder(path=" + Arrays.deepToString(this.path) + ", order=" + (Object)((Object)this.order) + ")";
        }
    }
}

