/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.base.http.impl;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import technology.semi.weaviate.client.base.http.HttpClient;
import technology.semi.weaviate.client.base.http.HttpResponse;
import technology.semi.weaviate.client.v1.auth.provider.AccessTokenProvider;

public class CommonsHttpClientImpl
implements HttpClient,
Closeable {
    private final Map<String, String> headers;
    private AccessTokenProvider tokenProvider;
    private final CloseableHttpClientBuilder clientBuilder;

    public CommonsHttpClientImpl(Map<String, String> headers, CloseableHttpClientBuilder clientBuilder) {
        this(headers, null, clientBuilder);
    }

    public CommonsHttpClientImpl(Map<String, String> headers, AccessTokenProvider tokenProvider, CloseableHttpClientBuilder clientBuilder) {
        this.headers = headers;
        this.clientBuilder = clientBuilder;
        this.tokenProvider = tokenProvider;
    }

    @Override
    public HttpResponse sendGetRequest(String url) throws Exception {
        return this.sendRequestWithoutPayload((HttpRequestBase)new HttpGet(url));
    }

    @Override
    public HttpResponse sendPostRequest(String url, String json) throws Exception {
        return this.sendRequestWithPayload((HttpEntityEnclosingRequestBase)new HttpPost(url), json);
    }

    @Override
    public HttpResponse sendPutRequest(String url, String json) throws Exception {
        return this.sendRequestWithPayload((HttpEntityEnclosingRequestBase)new HttpPut(url), json);
    }

    @Override
    public HttpResponse sendPatchRequest(String url, String json) throws Exception {
        return this.sendRequestWithPayload((HttpEntityEnclosingRequestBase)new HttpPatch(url), json);
    }

    @Override
    public HttpResponse sendDeleteRequest(String url, String json) throws Exception {
        if (json == null) {
            return this.sendRequestWithoutPayload((HttpRequestBase)new HttpDelete(url));
        }
        return this.sendRequestWithPayload(new HttpDeleteWithBody(url), json);
    }

    @Override
    public HttpResponse sendHeadRequest(String url) throws Exception {
        return this.sendRequestWithoutPayload((HttpRequestBase)new HttpHead(url));
    }

    private HttpResponse sendRequestWithoutPayload(HttpRequestBase request) throws Exception {
        request.setHeader("Accept", "*/*");
        return this.sendRequest((HttpUriRequest)request);
    }

    private HttpResponse sendRequestWithPayload(HttpEntityEnclosingRequestBase request, String jsonString) throws Exception {
        request.setHeader("Accept", "application/json");
        request.setHeader("Content-Type", "application/json");
        request.setEntity((HttpEntity)new StringEntity(jsonString, StandardCharsets.UTF_8));
        return this.sendRequest((HttpUriRequest)request);
    }

    private HttpResponse sendRequest(HttpUriRequest request) throws Exception {
        if (this.headers != null && this.headers.size() > 0) {
            this.headers.forEach((arg_0, arg_1) -> ((HttpUriRequest)request).addHeader(arg_0, arg_1));
        }
        if (this.tokenProvider != null) {
            request.addHeader("Authorization", String.format("Bearer %s", this.tokenProvider.getAccessToken()));
        }
        CloseableHttpClient client = this.clientBuilder.build();
        CloseableHttpResponse response = client.execute(request);
        int statusCode = response.getStatusLine().getStatusCode();
        String body = response.getEntity() != null ? EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8) : "";
        client.close();
        return new HttpResponse(statusCode, body);
    }

    @Override
    public void close() throws IOException {
        if (this.tokenProvider != null) {
            this.tokenProvider.shutdown();
        }
    }

    public static interface CloseableHttpClientBuilder {
        public CloseableHttpClient build();
    }

    private static class HttpDeleteWithBody
    extends HttpEntityEnclosingRequestBase {
        public HttpDeleteWithBody() {
        }

        public HttpDeleteWithBody(URI uri) {
            this.setURI(uri);
        }

        public HttpDeleteWithBody(String uri) {
            this.setURI(URI.create(uri));
        }

        public String getMethod() {
            return "DELETE";
        }
    }
}

