/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.auth.provider;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import technology.semi.weaviate.client.Config;
import technology.semi.weaviate.client.v1.auth.nimbus.BaseAuth;
import technology.semi.weaviate.client.v1.auth.nimbus.NimbusAuth;
import technology.semi.weaviate.client.v1.auth.provider.AccessTokenProvider;

public class AuthClientCredentialsTokenProvider
implements AccessTokenProvider {
    private final NimbusAuth nimbusAuth = new NimbusAuth();
    private String accessToken;
    private ScheduledExecutorService executor;

    public AuthClientCredentialsTokenProvider(Config config, BaseAuth.AuthResponse authResponse, List<String> clientScopes, String accessToken, long lifetimeSeconds, String clientSecret) {
        this.accessToken = accessToken;
        this.scheduleRefreshTokenTask(config, authResponse, clientScopes, clientSecret, lifetimeSeconds);
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    private void scheduleRefreshTokenTask(Config config, BaseAuth.AuthResponse authResponse, List<String> clientScopes, String clientSecret, long period) {
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.executor.scheduleAtFixedRate(() -> {
            this.accessToken = this.nimbusAuth.refreshClientCredentialsToken(config, authResponse, clientScopes, clientSecret);
        }, period, period, TimeUnit.SECONDS);
    }
}

