/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.batch.api;

import com.google.gson.annotations.SerializedName;
import technology.semi.weaviate.client.Config;
import technology.semi.weaviate.client.base.BaseClient;
import technology.semi.weaviate.client.base.ClientResult;
import technology.semi.weaviate.client.base.Response;
import technology.semi.weaviate.client.base.Result;
import technology.semi.weaviate.client.base.http.HttpClient;
import technology.semi.weaviate.client.v1.batch.model.BatchDeleteResponse;
import technology.semi.weaviate.client.v1.filters.WhereFilter;

public class ObjectsBatchDeleter
extends BaseClient<BatchDeleteResponse>
implements ClientResult<BatchDeleteResponse> {
    private String className;
    private WhereFilter where;
    private String output;
    private Boolean dryRun;

    public ObjectsBatchDeleter(HttpClient httpClient, Config config) {
        super(httpClient, config);
    }

    public ObjectsBatchDeleter withClassName(String className) {
        this.className = className;
        return this;
    }

    public ObjectsBatchDeleter withWhere(WhereFilter where) {
        this.where = where;
        return this;
    }

    public ObjectsBatchDeleter withOutput(String output) {
        this.output = output;
        return this;
    }

    public ObjectsBatchDeleter withDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    @Override
    public Result<BatchDeleteResponse> run() {
        BatchDeleteMatch match = BatchDeleteMatch.builder().className(this.className).whereFilter(this.where).build();
        BatchDelete batchDelete = BatchDelete.builder().dryRun(this.dryRun).output(this.output).match(match).build();
        Response<BatchDeleteResponse> resp = this.sendDeleteRequest("/batch/objects", batchDelete, BatchDeleteResponse.class);
        return new Result<BatchDeleteResponse>(resp);
    }

    private static class BatchDeleteMatch {
        @SerializedName(value="class")
        String className;
        @SerializedName(value="where")
        WhereFilter whereFilter;

        BatchDeleteMatch(String className, WhereFilter whereFilter) {
            this.className = className;
            this.whereFilter = whereFilter;
        }

        public static BatchDeleteMatchBuilder builder() {
            return new BatchDeleteMatchBuilder();
        }

        public String getClassName() {
            return this.className;
        }

        public WhereFilter getWhereFilter() {
            return this.whereFilter;
        }

        public static class BatchDeleteMatchBuilder {
            private String className;
            private WhereFilter whereFilter;

            BatchDeleteMatchBuilder() {
            }

            public BatchDeleteMatchBuilder className(String className) {
                this.className = className;
                return this;
            }

            public BatchDeleteMatchBuilder whereFilter(WhereFilter whereFilter) {
                this.whereFilter = whereFilter;
                return this;
            }

            public BatchDeleteMatch build() {
                return new BatchDeleteMatch(this.className, this.whereFilter);
            }

            public String toString() {
                return "ObjectsBatchDeleter.BatchDeleteMatch.BatchDeleteMatchBuilder(className=" + this.className + ", whereFilter=" + this.whereFilter + ")";
            }
        }
    }

    private static class BatchDelete {
        BatchDeleteMatch match;
        String output;
        Boolean dryRun;

        BatchDelete(BatchDeleteMatch match, String output, Boolean dryRun) {
            this.match = match;
            this.output = output;
            this.dryRun = dryRun;
        }

        public static BatchDeleteBuilder builder() {
            return new BatchDeleteBuilder();
        }

        public BatchDeleteMatch getMatch() {
            return this.match;
        }

        public String getOutput() {
            return this.output;
        }

        public Boolean getDryRun() {
            return this.dryRun;
        }

        public static class BatchDeleteBuilder {
            private BatchDeleteMatch match;
            private String output;
            private Boolean dryRun;

            BatchDeleteBuilder() {
            }

            public BatchDeleteBuilder match(BatchDeleteMatch match) {
                this.match = match;
                return this;
            }

            public BatchDeleteBuilder output(String output) {
                this.output = output;
                return this;
            }

            public BatchDeleteBuilder dryRun(Boolean dryRun) {
                this.dryRun = dryRun;
                return this;
            }

            public BatchDelete build() {
                return new BatchDelete(this.match, this.output, this.dryRun);
            }

            public String toString() {
                return "ObjectsBatchDeleter.BatchDelete.BatchDeleteBuilder(match=" + this.match + ", output=" + this.output + ", dryRun=" + this.dryRun + ")";
            }
        }
    }
}

