/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.graphql.query.argument;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.v1.graphql.query.argument.Argument;

public class Bm25Argument
implements Argument {
    private final String query;
    private final String[] properties;

    @Override
    public String build() {
        LinkedHashSet<String> arg = new LinkedHashSet<String>();
        arg.add(String.format("query: \"%s\"", this.query));
        if (this.properties != null) {
            arg.add(String.format("properties: %s", this.toJsonString(this.properties)));
        }
        return String.format("bm25: {%s}", StringUtils.joinWith((String)" ", (Object[])arg.toArray()));
    }

    private String toJsonString(Object object) {
        Gson serializer = new GsonBuilder().disableHtmlEscaping().create();
        return serializer.toJson(object);
    }

    Bm25Argument(String query, String[] properties) {
        this.query = query;
        this.properties = properties;
    }

    public static Bm25ArgumentBuilder builder() {
        return new Bm25ArgumentBuilder();
    }

    public String getQuery() {
        return this.query;
    }

    public String[] getProperties() {
        return this.properties;
    }

    public static class Bm25ArgumentBuilder {
        private String query;
        private String[] properties;

        Bm25ArgumentBuilder() {
        }

        public Bm25ArgumentBuilder query(String query) {
            this.query = query;
            return this;
        }

        public Bm25ArgumentBuilder properties(String[] properties) {
            this.properties = properties;
            return this;
        }

        public Bm25Argument build() {
            return new Bm25Argument(this.query, this.properties);
        }

        public String toString() {
            return "Bm25Argument.Bm25ArgumentBuilder(query=" + this.query + ", properties=" + Arrays.deepToString(this.properties) + ")";
        }
    }
}

