/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.schema.api;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.Config;
import technology.semi.weaviate.client.base.ClientResult;
import technology.semi.weaviate.client.base.Result;
import technology.semi.weaviate.client.base.WeaviateError;
import technology.semi.weaviate.client.base.WeaviateErrorMessage;
import technology.semi.weaviate.client.base.WeaviateErrorResponse;
import technology.semi.weaviate.client.base.http.HttpClient;
import technology.semi.weaviate.client.v1.schema.api.ShardUpdater;
import technology.semi.weaviate.client.v1.schema.api.ShardsGetter;
import technology.semi.weaviate.client.v1.schema.model.Shard;
import technology.semi.weaviate.client.v1.schema.model.ShardStatus;

public class ShardsUpdater
implements ClientResult<ShardStatus[]> {
    private final ShardsGetter shardsGetter;
    private final ShardUpdater shardUpdater;
    private String className;
    private String status;

    public ShardsUpdater(HttpClient httpClient, Config config) {
        this.shardsGetter = new ShardsGetter(httpClient, config);
        this.shardUpdater = new ShardUpdater(httpClient, config);
    }

    public ShardsUpdater withClassName(String className) {
        this.className = className;
        return this;
    }

    public ShardsUpdater withStatus(String targetStatus) {
        this.status = targetStatus;
        return this;
    }

    private Result<ShardStatus[]> toResult(WeaviateError error) {
        return new Result<Object>(error.getStatusCode(), null, WeaviateErrorResponse.builder().error(error.getMessages()).build());
    }

    @Override
    public Result<ShardStatus[]> run() {
        ArrayList<String> emptyFieldNames = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)this.className)) {
            emptyFieldNames.add("className");
        }
        if (this.status == null) {
            emptyFieldNames.add("status");
        }
        if (emptyFieldNames.size() > 0) {
            String message = String.format("%s cannot be empty", StringUtils.joinWith((String)", ", (Object[])emptyFieldNames.toArray()));
            WeaviateErrorMessage errorMessage = WeaviateErrorMessage.builder().message(message).build();
            WeaviateErrorResponse errors = WeaviateErrorResponse.builder().error(Collections.singletonList(errorMessage)).build();
            return new Result<Object>(400, null, errors);
        }
        Result<Shard[]> shards = this.shardsGetter.withClassName(this.className).run();
        if (shards.hasErrors()) {
            return this.toResult(shards.getError());
        }
        ArrayList<ShardStatus> shardStatuses = new ArrayList<ShardStatus>();
        for (Shard shard : shards.getResult()) {
            Result<ShardStatus> update = this.shardUpdater.withClassName(this.className).withShardName(shard.getName()).withStatus(this.status).run();
            if (update.hasErrors()) {
                return this.toResult(update.getError());
            }
            shardStatuses.add(update.getResult());
        }
        return new Result<ShardStatus[]>(200, shardStatuses.toArray(new ShardStatus[shardStatuses.size()]), null);
    }
}

