/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.batch;

import technology.semi.weaviate.client.Config;
import technology.semi.weaviate.client.base.http.HttpClient;
import technology.semi.weaviate.client.base.util.BeaconPath;
import technology.semi.weaviate.client.base.util.DbVersionSupport;
import technology.semi.weaviate.client.v1.batch.api.ObjectsBatchDeleter;
import technology.semi.weaviate.client.v1.batch.api.ObjectsBatcher;
import technology.semi.weaviate.client.v1.batch.api.ReferencePayloadBuilder;
import technology.semi.weaviate.client.v1.batch.api.ReferencesBatcher;
import technology.semi.weaviate.client.v1.batch.util.ObjectsPath;
import technology.semi.weaviate.client.v1.batch.util.ReferencesPath;
import technology.semi.weaviate.client.v1.data.Data;

public class Batch {
    private final Config config;
    private final HttpClient httpClient;
    private final BeaconPath beaconPath;
    private final ObjectsPath objectsPath;
    private final ReferencesPath referencesPath;
    private final Data data;

    public Batch(HttpClient httpClient, Config config, DbVersionSupport dbVersionSupport, Data data) {
        this.config = config;
        this.httpClient = httpClient;
        this.beaconPath = new BeaconPath(dbVersionSupport);
        this.objectsPath = new ObjectsPath();
        this.referencesPath = new ReferencesPath();
        this.data = data;
    }

    public ObjectsBatcher objectsBatcher() {
        return this.objectsBatcher(ObjectsBatcher.BatchRetriesConfig.defaultConfig().build());
    }

    public ObjectsBatcher objectsBatcher(ObjectsBatcher.BatchRetriesConfig batchRetriesConfig) {
        return ObjectsBatcher.create(this.httpClient, this.config, this.data, this.objectsPath, batchRetriesConfig);
    }

    public ObjectsBatcher objectsAutoBatcher() {
        return this.objectsAutoBatcher(ObjectsBatcher.BatchRetriesConfig.defaultConfig().build(), ObjectsBatcher.AutoBatchConfig.defaultConfig().build());
    }

    public ObjectsBatcher objectsAutoBatcher(ObjectsBatcher.BatchRetriesConfig batchRetriesConfig) {
        return this.objectsAutoBatcher(batchRetriesConfig, ObjectsBatcher.AutoBatchConfig.defaultConfig().build());
    }

    public ObjectsBatcher objectsAutoBatcher(ObjectsBatcher.AutoBatchConfig autoBatchConfig) {
        return this.objectsAutoBatcher(ObjectsBatcher.BatchRetriesConfig.defaultConfig().build(), autoBatchConfig);
    }

    public ObjectsBatcher objectsAutoBatcher(ObjectsBatcher.BatchRetriesConfig batchRetriesConfig, ObjectsBatcher.AutoBatchConfig autoBatchConfig) {
        return ObjectsBatcher.createAuto(this.httpClient, this.config, this.data, this.objectsPath, batchRetriesConfig, autoBatchConfig);
    }

    public ObjectsBatchDeleter objectsBatchDeleter() {
        return new ObjectsBatchDeleter(this.httpClient, this.config, this.objectsPath);
    }

    public ReferencePayloadBuilder referencePayloadBuilder() {
        return new ReferencePayloadBuilder(this.beaconPath);
    }

    public ReferencesBatcher referencesBatcher() {
        return this.referencesBatcher(ReferencesBatcher.BatchRetriesConfig.defaultConfig().build());
    }

    public ReferencesBatcher referencesBatcher(ReferencesBatcher.BatchRetriesConfig batchRetriesConfig) {
        return ReferencesBatcher.create(this.httpClient, this.config, this.referencesPath, batchRetriesConfig);
    }

    public ReferencesBatcher referencesAutoBatcher() {
        return this.referencesAutoBatcher(ReferencesBatcher.BatchRetriesConfig.defaultConfig().build(), ReferencesBatcher.AutoBatchConfig.defaultConfig().build());
    }

    public ReferencesBatcher referencesAutoBatcher(ReferencesBatcher.BatchRetriesConfig batchRetriesConfig) {
        return this.referencesAutoBatcher(batchRetriesConfig, ReferencesBatcher.AutoBatchConfig.defaultConfig().build());
    }

    public ReferencesBatcher referencesAutoBatcher(ReferencesBatcher.AutoBatchConfig autoBatchConfig) {
        return this.referencesAutoBatcher(ReferencesBatcher.BatchRetriesConfig.defaultConfig().build(), autoBatchConfig);
    }

    public ReferencesBatcher referencesAutoBatcher(ReferencesBatcher.BatchRetriesConfig batchRetriesConfig, ReferencesBatcher.AutoBatchConfig autoBatchConfig) {
        return ReferencesBatcher.createAuto(this.httpClient, this.config, this.referencesPath, batchRetriesConfig, autoBatchConfig);
    }
}

