/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.data.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.base.util.DbVersionSupport;
import technology.semi.weaviate.client.base.util.TriConsumer;

public class ReferencesPath {
    private final DbVersionSupport support;

    public ReferencesPath(DbVersionSupport support) {
        this.support = support;
    }

    public String buildCreate(Params params) {
        return this.commonBuild(params);
    }

    public String buildDelete(Params params) {
        return this.commonBuild(params);
    }

    public String buildReplace(Params params) {
        return this.commonBuild(params);
    }

    private String commonBuild(Params params) {
        return this.build(params, this::addPathClassNameWithDeprecatedNotSupportedCheck, this::addPathId, this::addPathReferences, this::addPathProperty, this::addQueryConsistencyLevel);
    }

    @SafeVarargs
    private final String build(Params params, TriConsumer<Params, List<String>, List<String>> ... appenders) {
        Objects.requireNonNull(params);
        ArrayList<String> pathParams = new ArrayList<String>();
        ArrayList queryParams = new ArrayList();
        pathParams.add("/objects");
        Arrays.stream(appenders).forEach(consumer -> consumer.accept(params, pathParams, queryParams));
        String path = String.join((CharSequence)"/", pathParams);
        if (!queryParams.isEmpty()) {
            return path + "?" + String.join((CharSequence)"&", queryParams);
        }
        return path;
    }

    private void addPathClassNameWithDeprecatedNotSupportedCheck(Params params, List<String> pathParams, List<String> queryParams) {
        if (this.support.supportsClassNameNamespacedEndpoints()) {
            if (StringUtils.isNotBlank((CharSequence)params.className)) {
                pathParams.add(StringUtils.trim((String)params.className));
            } else {
                this.support.warnDeprecatedNonClassNameNamespacedEndpointsForObjects();
            }
        } else if (StringUtils.isNotBlank((CharSequence)params.className)) {
            this.support.warnNotSupportedClassNamespacedEndpointsForObjects();
        }
    }

    private void addPathId(Params params, List<String> pathParams, List<String> queryParams) {
        if (StringUtils.isNotBlank((CharSequence)params.id)) {
            pathParams.add(StringUtils.trim((String)params.id));
        }
    }

    private void addPathReferences(Params params, List<String> pathParams, List<String> queryParams) {
        pathParams.add("references");
    }

    private void addPathProperty(Params params, List<String> pathParams, List<String> queryParams) {
        if (StringUtils.isNotBlank((CharSequence)params.property)) {
            pathParams.add(StringUtils.trim((String)params.property));
        }
    }

    private void addQueryConsistencyLevel(Params params, List<String> pathParams, List<String> queryParams) {
        if (StringUtils.isNotBlank((CharSequence)params.consistencyLevel)) {
            queryParams.add(String.format("%s=%s", "consistency_level", StringUtils.trim((String)params.consistencyLevel)));
        }
    }

    public static class Params {
        private final String id;
        private final String className;
        private final String consistencyLevel;
        private final String property;

        Params(String id, String className, String consistencyLevel, String property) {
            this.id = id;
            this.className = className;
            this.consistencyLevel = consistencyLevel;
            this.property = property;
        }

        public static ParamsBuilder builder() {
            return new ParamsBuilder();
        }

        public String toString() {
            return "ReferencesPath.Params(id=" + this.id + ", className=" + this.className + ", consistencyLevel=" + this.consistencyLevel + ", property=" + this.property + ")";
        }

        public static class ParamsBuilder {
            private String id;
            private String className;
            private String consistencyLevel;
            private String property;

            ParamsBuilder() {
            }

            public ParamsBuilder id(String id) {
                this.id = id;
                return this;
            }

            public ParamsBuilder className(String className) {
                this.className = className;
                return this;
            }

            public ParamsBuilder consistencyLevel(String consistencyLevel) {
                this.consistencyLevel = consistencyLevel;
                return this;
            }

            public ParamsBuilder property(String property) {
                this.property = property;
                return this;
            }

            public Params build() {
                return new Params(this.id, this.className, this.consistencyLevel, this.property);
            }

            public String toString() {
                return "ReferencesPath.Params.ParamsBuilder(id=" + this.id + ", className=" + this.className + ", consistencyLevel=" + this.consistencyLevel + ", property=" + this.property + ")";
            }
        }
    }
}

