/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.batch.api;

import java.io.Closeable;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import technology.semi.weaviate.client.Config;
import technology.semi.weaviate.client.base.BaseClient;
import technology.semi.weaviate.client.base.ClientResult;
import technology.semi.weaviate.client.base.Response;
import technology.semi.weaviate.client.base.Result;
import technology.semi.weaviate.client.base.WeaviateErrorMessage;
import technology.semi.weaviate.client.base.WeaviateErrorResponse;
import technology.semi.weaviate.client.base.http.HttpClient;
import technology.semi.weaviate.client.base.util.Assert;
import technology.semi.weaviate.client.v1.batch.model.BatchReference;
import technology.semi.weaviate.client.v1.batch.model.BatchReferenceResponse;
import technology.semi.weaviate.client.v1.batch.util.ReferencesPath;

public class ReferencesBatcher
extends BaseClient<BatchReferenceResponse[]>
implements ClientResult<BatchReferenceResponse[]>,
Closeable {
    private final ReferencesPath referencesPath;
    private final BatchRetriesConfig batchRetriesConfig;
    private final AutoBatchConfig autoBatchConfig;
    private final boolean autoRunEnabled;
    private final ScheduledExecutorService executorService;
    private final DelayedExecutor<?> delayedExecutor;
    private final List<BatchReference> references;
    private String consistencyLevel;
    private final List<CompletableFuture<Result<BatchReferenceResponse[]>>> undoneFutures;

    private ReferencesBatcher(HttpClient httpClient, Config config, ReferencesPath referencesPath, BatchRetriesConfig batchRetriesConfig, AutoBatchConfig autoBatchConfig) {
        super(httpClient, config);
        this.referencesPath = referencesPath;
        this.references = new ArrayList<BatchReference>();
        this.batchRetriesConfig = batchRetriesConfig;
        if (autoBatchConfig != null) {
            this.autoRunEnabled = true;
            this.autoBatchConfig = autoBatchConfig;
            this.executorService = Executors.newScheduledThreadPool(autoBatchConfig.poolSize);
            this.delayedExecutor = new ExecutorServiceDelayedExecutor(this.executorService);
            this.undoneFutures = Collections.synchronizedList(new ArrayList());
        } else {
            this.autoRunEnabled = false;
            this.autoBatchConfig = null;
            this.executorService = null;
            this.delayedExecutor = new SleepDelayedExecutor();
            this.undoneFutures = null;
        }
    }

    public static ReferencesBatcher create(HttpClient httpClient, Config config, ReferencesPath referencesPath, BatchRetriesConfig batchRetriesConfig) {
        Assert.requiredNotNull(batchRetriesConfig, "batchRetriesConfig");
        return new ReferencesBatcher(httpClient, config, referencesPath, batchRetriesConfig, null);
    }

    public static ReferencesBatcher createAuto(HttpClient httpClient, Config config, ReferencesPath referencesPath, BatchRetriesConfig batchRetriesConfig, AutoBatchConfig autoBatchConfig) {
        Assert.requiredNotNull(batchRetriesConfig, "batchRetriesConfig");
        Assert.requiredNotNull(autoBatchConfig, "autoBatchConfig");
        return new ReferencesBatcher(httpClient, config, referencesPath, batchRetriesConfig, autoBatchConfig);
    }

    public ReferencesBatcher withReference(BatchReference reference) {
        return this.withReferences(reference);
    }

    public ReferencesBatcher withReferences(BatchReference ... references) {
        this.references.addAll(Arrays.asList(references));
        this.autoRun();
        return this;
    }

    public ReferencesBatcher withConsistencyLevel(String consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    @Override
    public Result<BatchReferenceResponse[]> run() {
        if (this.autoRunEnabled) {
            this.flush();
            return null;
        }
        if (this.references.isEmpty()) {
            return new Result<BatchReferenceResponse[]>(0, new BatchReferenceResponse[0], null);
        }
        List<BatchReference> batch = this.extractBatch(this.references.size());
        return (Result)this.runRecursively(batch, 0, 0, this.delayedExecutor);
    }

    public void flush() {
        CompletableFuture[] futures;
        if (!this.autoRunEnabled) {
            this.run();
            return;
        }
        if (!this.references.isEmpty()) {
            List<BatchReference> batch = this.extractBatch(this.references.size());
            this.runInThread(batch);
        }
        if ((futures = this.undoneFutures.toArray(new CompletableFuture[0])).length == 0) {
            return;
        }
        CompletableFuture.allOf(futures).join();
    }

    @Override
    public void close() {
        if (!this.autoRunEnabled) {
            return;
        }
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(this.autoBatchConfig.awaitTerminationMs, TimeUnit.MILLISECONDS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executorService.shutdownNow();
        }
    }

    private List<BatchReference> extractBatch(int batchSize) {
        ArrayList<BatchReference> batch = new ArrayList<BatchReference>(batchSize);
        List<BatchReference> sublist = this.references.subList(0, batchSize);
        batch.addAll(sublist);
        sublist.clear();
        return batch;
    }

    private void autoRun() {
        if (!this.autoRunEnabled) {
            return;
        }
        while (this.references.size() >= this.autoBatchConfig.batchSize) {
            List<BatchReference> batch = this.extractBatch(this.autoBatchConfig.batchSize);
            this.runInThread(batch);
        }
    }

    private void runInThread(List<BatchReference> batch) {
        CompletionStage future = CompletableFuture.supplyAsync(() -> this.createRunFuture(batch), this.executorService).thenCompose(f -> f);
        if (this.autoBatchConfig.callback != null) {
            future = ((CompletableFuture)future).whenComplete((result, e) -> this.autoBatchConfig.callback.accept(result));
        }
        CompletionStage undoneFuture = future;
        this.undoneFutures.add((CompletableFuture<Result<BatchReferenceResponse[]>>)undoneFuture);
        ((CompletableFuture)undoneFuture).whenComplete((arg_0, arg_1) -> this.lambda$runInThread$3((CompletableFuture)undoneFuture, arg_0, arg_1));
    }

    private CompletableFuture<Result<BatchReferenceResponse[]>> createRunFuture(List<BatchReference> batch) {
        return (CompletableFuture)this.runRecursively(batch, 0, 0, this.delayedExecutor);
    }

    private <T> T runRecursively(List<BatchReference> batch, int connectionErrorCount, int timeoutErrorCount, DelayedExecutor<T> delayedExecutor) {
        Result<BatchReferenceResponse[]> result = this.internalRun(batch);
        if (result.hasErrors()) {
            List<WeaviateErrorMessage> messages = result.getError().getMessages();
            if (!messages.isEmpty()) {
                Throwable throwable = messages.get(0).getThrowable();
                boolean executeAgain = false;
                int delay = 0;
                if (throwable instanceof ConnectException) {
                    if (connectionErrorCount++ < this.batchRetriesConfig.maxConnectionRetries) {
                        executeAgain = true;
                        delay = connectionErrorCount * this.batchRetriesConfig.retriesIntervalMs;
                    }
                } else if (throwable instanceof SocketTimeoutException && timeoutErrorCount++ < this.batchRetriesConfig.maxTimeoutRetries) {
                    executeAgain = true;
                    delay = timeoutErrorCount * this.batchRetriesConfig.retriesIntervalMs;
                }
                if (executeAgain) {
                    int lambdaConnectionErrorCount = connectionErrorCount;
                    int lambdaTimeoutErrorCount = timeoutErrorCount;
                    List<BatchReference> lambdaBatch = batch;
                    return (T)delayedExecutor.delayed(delay, () -> this.runRecursively(lambdaBatch, lambdaConnectionErrorCount, lambdaTimeoutErrorCount, delayedExecutor));
                }
            }
        } else {
            batch = null;
        }
        Result<BatchReferenceResponse[]> finalResult = this.createFinalResultFromLastResult(result, batch);
        return delayedExecutor.now(finalResult);
    }

    private Result<BatchReferenceResponse[]> internalRun(List<BatchReference> batch) {
        BatchReference[] payload = batch.toArray(new BatchReference[0]);
        String path = this.referencesPath.buildCreate(ReferencesPath.Params.builder().consistencyLevel(this.consistencyLevel).build());
        Response<BatchReferenceResponse[]> resp = this.sendPostRequest(path, payload, BatchReferenceResponse[].class);
        return new Result<BatchReferenceResponse[]>(resp);
    }

    private Result<BatchReferenceResponse[]> createFinalResultFromLastResult(Result<BatchReferenceResponse[]> lastResult, List<BatchReference> failedBatch) {
        List<WeaviateErrorMessage> messages;
        if (ObjectUtils.isEmpty(failedBatch)) {
            return lastResult;
        }
        String failedRefs = failedBatch.stream().map(ref -> ref.getFrom() + " => " + ref.getTo()).collect(Collectors.joining(", "));
        WeaviateErrorMessage failedRefsMessage = WeaviateErrorMessage.builder().message("Failed refs: " + failedRefs).build();
        int statusCode = 0;
        if (lastResult.hasErrors()) {
            statusCode = lastResult.getError().getStatusCode();
            List<WeaviateErrorMessage> prevMessages = lastResult.getError().getMessages();
            messages = new ArrayList<WeaviateErrorMessage>(prevMessages.size() + 1);
            messages.addAll(prevMessages);
            messages.add(failedRefsMessage);
        } else {
            messages = Collections.singletonList(failedRefsMessage);
        }
        return new Result<Object>(statusCode, null, WeaviateErrorResponse.builder().error(messages).code(statusCode).build());
    }

    private /* synthetic */ void lambda$runInThread$3(CompletableFuture undoneFuture, Result result, Throwable ex) {
        this.undoneFutures.remove(undoneFuture);
    }

    public static class AutoBatchConfig {
        public static final int BATCH_SIZE = 100;
        public static final int POOL_SIZE = 1;
        public static final int AWAIT_TERMINATION_MS = 10000;
        private final int batchSize;
        private final int poolSize;
        private final int awaitTerminationMs;
        private final Consumer<Result<BatchReferenceResponse[]>> callback;

        private AutoBatchConfig(int batchSize, int poolSize, int awaitTerminationMs, Consumer<Result<BatchReferenceResponse[]>> callback) {
            Assert.requireGreaterEqual(batchSize, 1, "batchSize");
            Assert.requireGreaterEqual(poolSize, 1, "corePoolSize");
            Assert.requireGreater(awaitTerminationMs, 0, "awaitTerminationMs");
            this.batchSize = batchSize;
            this.poolSize = poolSize;
            this.awaitTerminationMs = awaitTerminationMs;
            this.callback = callback;
        }

        public static AutoBatchConfigBuilder defaultConfig() {
            return AutoBatchConfig.builder().batchSize(100).poolSize(1).awaitTerminationMs(10000).callback(null);
        }

        public static AutoBatchConfigBuilder builder() {
            return new AutoBatchConfigBuilder();
        }

        public int getBatchSize() {
            return this.batchSize;
        }

        public int getPoolSize() {
            return this.poolSize;
        }

        public int getAwaitTerminationMs() {
            return this.awaitTerminationMs;
        }

        public Consumer<Result<BatchReferenceResponse[]>> getCallback() {
            return this.callback;
        }

        public static class AutoBatchConfigBuilder {
            private int batchSize;
            private int poolSize;
            private int awaitTerminationMs;
            private Consumer<Result<BatchReferenceResponse[]>> callback;

            AutoBatchConfigBuilder() {
            }

            public AutoBatchConfigBuilder batchSize(int batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            public AutoBatchConfigBuilder poolSize(int poolSize) {
                this.poolSize = poolSize;
                return this;
            }

            public AutoBatchConfigBuilder awaitTerminationMs(int awaitTerminationMs) {
                this.awaitTerminationMs = awaitTerminationMs;
                return this;
            }

            public AutoBatchConfigBuilder callback(Consumer<Result<BatchReferenceResponse[]>> callback) {
                this.callback = callback;
                return this;
            }

            public AutoBatchConfig build() {
                return new AutoBatchConfig(this.batchSize, this.poolSize, this.awaitTerminationMs, this.callback);
            }

            public String toString() {
                return "ReferencesBatcher.AutoBatchConfig.AutoBatchConfigBuilder(batchSize=" + this.batchSize + ", poolSize=" + this.poolSize + ", awaitTerminationMs=" + this.awaitTerminationMs + ", callback=" + this.callback + ")";
            }
        }
    }

    public static class BatchRetriesConfig {
        public static final int MAX_TIMEOUT_RETRIES = 3;
        public static final int MAX_CONNECTION_RETRIES = 3;
        public static final int RETRIES_INTERVAL = 2000;
        private final int maxTimeoutRetries;
        private final int maxConnectionRetries;
        private final int retriesIntervalMs;

        private BatchRetriesConfig(int maxTimeoutRetries, int maxConnectionRetries, int retriesIntervalMs) {
            Assert.requireGreaterEqual(maxTimeoutRetries, 0, "maxTimeoutRetries");
            Assert.requireGreaterEqual(maxConnectionRetries, 0, "maxConnectionRetries");
            Assert.requireGreater(retriesIntervalMs, 0, "retriesIntervalMs");
            this.maxTimeoutRetries = maxTimeoutRetries;
            this.maxConnectionRetries = maxConnectionRetries;
            this.retriesIntervalMs = retriesIntervalMs;
        }

        public static BatchRetriesConfigBuilder defaultConfig() {
            return BatchRetriesConfig.builder().maxTimeoutRetries(3).maxConnectionRetries(3).retriesIntervalMs(2000);
        }

        public static BatchRetriesConfigBuilder builder() {
            return new BatchRetriesConfigBuilder();
        }

        public int getMaxTimeoutRetries() {
            return this.maxTimeoutRetries;
        }

        public int getMaxConnectionRetries() {
            return this.maxConnectionRetries;
        }

        public int getRetriesIntervalMs() {
            return this.retriesIntervalMs;
        }

        public static class BatchRetriesConfigBuilder {
            private int maxTimeoutRetries;
            private int maxConnectionRetries;
            private int retriesIntervalMs;

            BatchRetriesConfigBuilder() {
            }

            public BatchRetriesConfigBuilder maxTimeoutRetries(int maxTimeoutRetries) {
                this.maxTimeoutRetries = maxTimeoutRetries;
                return this;
            }

            public BatchRetriesConfigBuilder maxConnectionRetries(int maxConnectionRetries) {
                this.maxConnectionRetries = maxConnectionRetries;
                return this;
            }

            public BatchRetriesConfigBuilder retriesIntervalMs(int retriesIntervalMs) {
                this.retriesIntervalMs = retriesIntervalMs;
                return this;
            }

            public BatchRetriesConfig build() {
                return new BatchRetriesConfig(this.maxTimeoutRetries, this.maxConnectionRetries, this.retriesIntervalMs);
            }

            public String toString() {
                return "ReferencesBatcher.BatchRetriesConfig.BatchRetriesConfigBuilder(maxTimeoutRetries=" + this.maxTimeoutRetries + ", maxConnectionRetries=" + this.maxConnectionRetries + ", retriesIntervalMs=" + this.retriesIntervalMs + ")";
            }
        }
    }

    private static class SleepDelayedExecutor
    implements DelayedExecutor<Result<BatchReferenceResponse[]>> {
        private SleepDelayedExecutor() {
        }

        @Override
        public Result<BatchReferenceResponse[]> delayed(int delay, Supplier<Result<BatchReferenceResponse[]>> supplier) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return supplier.get();
        }

        @Override
        public Result<BatchReferenceResponse[]> now(Result<BatchReferenceResponse[]> result) {
            return result;
        }
    }

    private static class ExecutorServiceDelayedExecutor
    implements DelayedExecutor<CompletableFuture<Result<BatchReferenceResponse[]>>> {
        private final ScheduledExecutorService executorService;

        @Override
        public CompletableFuture<Result<BatchReferenceResponse[]>> delayed(int delay, Supplier<CompletableFuture<Result<BatchReferenceResponse[]>>> supplier) {
            Executor executor = runnable -> this.executorService.schedule(runnable, (long)delay, TimeUnit.MILLISECONDS);
            return CompletableFuture.supplyAsync(supplier, executor).thenCompose(f -> f);
        }

        @Override
        public CompletableFuture<Result<BatchReferenceResponse[]>> now(Result<BatchReferenceResponse[]> result) {
            return CompletableFuture.completedFuture(result);
        }

        public ExecutorServiceDelayedExecutor(ScheduledExecutorService executorService) {
            this.executorService = executorService;
        }
    }

    private static interface DelayedExecutor<T> {
        public T delayed(int var1, Supplier<T> var2);

        public T now(Result<BatchReferenceResponse[]> var1);
    }
}

