/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.graphql.query.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.v1.filters.WhereFilter;
import technology.semi.weaviate.client.v1.filters.WhereFilterUtil;
import technology.semi.weaviate.client.v1.graphql.query.argument.AskArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.Bm25Argument;
import technology.semi.weaviate.client.v1.graphql.query.argument.GroupArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.HybridArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearImageArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearObjectArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearTextArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearVectorArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.SortArguments;
import technology.semi.weaviate.client.v1.graphql.query.builder.Query;
import technology.semi.weaviate.client.v1.graphql.query.fields.Field;
import technology.semi.weaviate.client.v1.graphql.query.fields.Fields;
import technology.semi.weaviate.client.v1.graphql.query.fields.GenerativeSearchBuilder;

public class GetBuilder
implements Query {
    private final String className;
    private final Fields fields;
    private final Integer offset;
    private final Integer limit;
    private final String after;
    private final WhereFilter withWhereFilter;
    private final NearTextArgument withNearTextFilter;
    private final Bm25Argument withBm25Filter;
    private final HybridArgument withHybridFilter;
    private final NearObjectArgument withNearObjectFilter;
    private final AskArgument withAskArgument;
    private final NearImageArgument withNearImageFilter;
    private final NearVectorArgument withNearVectorFilter;
    private final GroupArgument withGroupArgument;
    private final SortArguments withSortArguments;
    private final GenerativeSearchBuilder withGenerativeSearch;

    private boolean includesFilterClause() {
        return ObjectUtils.anyNotNull((Object[])new Object[]{this.withWhereFilter, this.withNearTextFilter, this.withNearObjectFilter, this.withNearVectorFilter, this.withNearImageFilter, this.withGroupArgument, this.withAskArgument, this.withBm25Filter, this.withHybridFilter, this.limit, this.offset, this.withSortArguments});
    }

    private String createFilterClause() {
        if (this.includesFilterClause()) {
            LinkedHashSet<String> filters = new LinkedHashSet<String>();
            if (this.withWhereFilter != null) {
                filters.add(WhereFilterUtil.toGraphQLString(this.withWhereFilter));
            }
            if (this.withNearTextFilter != null) {
                filters.add(this.withNearTextFilter.build());
            }
            if (this.withBm25Filter != null) {
                filters.add(this.withBm25Filter.build());
            }
            if (this.withHybridFilter != null) {
                filters.add(this.withHybridFilter.build());
            }
            if (this.withNearObjectFilter != null) {
                filters.add(this.withNearObjectFilter.build());
            }
            if (this.withNearVectorFilter != null) {
                filters.add(this.withNearVectorFilter.build());
            }
            if (this.withGroupArgument != null) {
                filters.add(this.withGroupArgument.build());
            }
            if (this.withAskArgument != null) {
                filters.add(this.withAskArgument.build());
            }
            if (this.withNearImageFilter != null) {
                filters.add(this.withNearImageFilter.build());
            }
            if (this.limit != null) {
                filters.add(String.format("limit: %s", this.limit));
            }
            if (this.offset != null) {
                filters.add(String.format("offset: %s", this.offset));
            }
            if (this.after != null) {
                filters.add(String.format("after: \"%s\"", this.after));
            }
            if (this.withSortArguments != null) {
                filters.add(this.withSortArguments.build());
            }
            return String.format("(%s)", StringUtils.joinWith((String)", ", (Object[])filters.toArray()));
        }
        return "";
    }

    private String createFields() {
        if (ObjectUtils.allNull((Object[])new Object[]{this.fields, this.withGenerativeSearch})) {
            return "";
        }
        if (this.withGenerativeSearch == null) {
            return this.fields.build();
        }
        Field generate = this.withGenerativeSearch.build();
        Field generateAdditional = Field.builder().name("_additional").fields(new Field[]{generate}).build();
        if (this.fields == null) {
            return generateAdditional.build();
        }
        Map<Boolean, List<Field>> grouped = Arrays.stream(this.fields.getFields()).collect(Collectors.groupingBy(f -> "_additional".equals(f.getName())));
        List additionals = grouped.getOrDefault(true, new ArrayList());
        if (additionals.isEmpty()) {
            additionals.add(generateAdditional);
        } else {
            Field[] mergedInternalFields = (Field[])Stream.concat(Arrays.stream(((Field)additionals.get(0)).getFields()), Stream.of(generate)).toArray(Field[]::new);
            additionals.set(0, Field.builder().name("_additional").fields(mergedInternalFields).build());
        }
        Field[] allFields = (Field[])Stream.concat(((List)grouped.getOrDefault(false, new ArrayList())).stream(), additionals.stream()).toArray(Field[]::new);
        return Fields.builder().fields(allFields).build().build();
    }

    @Override
    public String buildQuery() {
        return String.format("{Get{%s%s{%s}}}", this.className, this.createFilterClause(), this.createFields());
    }

    GetBuilder(String className, Fields fields, Integer offset, Integer limit, String after, WhereFilter withWhereFilter, NearTextArgument withNearTextFilter, Bm25Argument withBm25Filter, HybridArgument withHybridFilter, NearObjectArgument withNearObjectFilter, AskArgument withAskArgument, NearImageArgument withNearImageFilter, NearVectorArgument withNearVectorFilter, GroupArgument withGroupArgument, SortArguments withSortArguments, GenerativeSearchBuilder withGenerativeSearch) {
        this.className = className;
        this.fields = fields;
        this.offset = offset;
        this.limit = limit;
        this.after = after;
        this.withWhereFilter = withWhereFilter;
        this.withNearTextFilter = withNearTextFilter;
        this.withBm25Filter = withBm25Filter;
        this.withHybridFilter = withHybridFilter;
        this.withNearObjectFilter = withNearObjectFilter;
        this.withAskArgument = withAskArgument;
        this.withNearImageFilter = withNearImageFilter;
        this.withNearVectorFilter = withNearVectorFilter;
        this.withGroupArgument = withGroupArgument;
        this.withSortArguments = withSortArguments;
        this.withGenerativeSearch = withGenerativeSearch;
    }

    public static GetBuilderBuilder builder() {
        return new GetBuilderBuilder();
    }

    public String getClassName() {
        return this.className;
    }

    public Fields getFields() {
        return this.fields;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getAfter() {
        return this.after;
    }

    public WhereFilter getWithWhereFilter() {
        return this.withWhereFilter;
    }

    public NearTextArgument getWithNearTextFilter() {
        return this.withNearTextFilter;
    }

    public Bm25Argument getWithBm25Filter() {
        return this.withBm25Filter;
    }

    public HybridArgument getWithHybridFilter() {
        return this.withHybridFilter;
    }

    public NearObjectArgument getWithNearObjectFilter() {
        return this.withNearObjectFilter;
    }

    public AskArgument getWithAskArgument() {
        return this.withAskArgument;
    }

    public NearImageArgument getWithNearImageFilter() {
        return this.withNearImageFilter;
    }

    public NearVectorArgument getWithNearVectorFilter() {
        return this.withNearVectorFilter;
    }

    public GroupArgument getWithGroupArgument() {
        return this.withGroupArgument;
    }

    public SortArguments getWithSortArguments() {
        return this.withSortArguments;
    }

    public GenerativeSearchBuilder getWithGenerativeSearch() {
        return this.withGenerativeSearch;
    }

    public String toString() {
        return "GetBuilder(className=" + this.getClassName() + ", fields=" + this.getFields() + ", offset=" + this.getOffset() + ", limit=" + this.getLimit() + ", after=" + this.getAfter() + ", withWhereFilter=" + this.getWithWhereFilter() + ", withNearTextFilter=" + this.getWithNearTextFilter() + ", withBm25Filter=" + this.getWithBm25Filter() + ", withHybridFilter=" + this.getWithHybridFilter() + ", withNearObjectFilter=" + this.getWithNearObjectFilter() + ", withAskArgument=" + this.getWithAskArgument() + ", withNearImageFilter=" + this.getWithNearImageFilter() + ", withNearVectorFilter=" + this.getWithNearVectorFilter() + ", withGroupArgument=" + this.getWithGroupArgument() + ", withSortArguments=" + this.getWithSortArguments() + ", withGenerativeSearch=" + this.getWithGenerativeSearch() + ")";
    }

    public static class GetBuilderBuilder {
        private String className;
        private Fields fields;
        private Integer offset;
        private Integer limit;
        private String after;
        private WhereFilter withWhereFilter;
        private NearTextArgument withNearTextFilter;
        private Bm25Argument withBm25Filter;
        private HybridArgument withHybridFilter;
        private NearObjectArgument withNearObjectFilter;
        private AskArgument withAskArgument;
        private NearImageArgument withNearImageFilter;
        private NearVectorArgument withNearVectorFilter;
        private GroupArgument withGroupArgument;
        private SortArguments withSortArguments;
        private GenerativeSearchBuilder withGenerativeSearch;

        GetBuilderBuilder() {
        }

        public GetBuilderBuilder className(String className) {
            this.className = className;
            return this;
        }

        public GetBuilderBuilder fields(Fields fields) {
            this.fields = fields;
            return this;
        }

        public GetBuilderBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public GetBuilderBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public GetBuilderBuilder after(String after) {
            this.after = after;
            return this;
        }

        public GetBuilderBuilder withWhereFilter(WhereFilter withWhereFilter) {
            this.withWhereFilter = withWhereFilter;
            return this;
        }

        public GetBuilderBuilder withNearTextFilter(NearTextArgument withNearTextFilter) {
            this.withNearTextFilter = withNearTextFilter;
            return this;
        }

        public GetBuilderBuilder withBm25Filter(Bm25Argument withBm25Filter) {
            this.withBm25Filter = withBm25Filter;
            return this;
        }

        public GetBuilderBuilder withHybridFilter(HybridArgument withHybridFilter) {
            this.withHybridFilter = withHybridFilter;
            return this;
        }

        public GetBuilderBuilder withNearObjectFilter(NearObjectArgument withNearObjectFilter) {
            this.withNearObjectFilter = withNearObjectFilter;
            return this;
        }

        public GetBuilderBuilder withAskArgument(AskArgument withAskArgument) {
            this.withAskArgument = withAskArgument;
            return this;
        }

        public GetBuilderBuilder withNearImageFilter(NearImageArgument withNearImageFilter) {
            this.withNearImageFilter = withNearImageFilter;
            return this;
        }

        public GetBuilderBuilder withNearVectorFilter(NearVectorArgument withNearVectorFilter) {
            this.withNearVectorFilter = withNearVectorFilter;
            return this;
        }

        public GetBuilderBuilder withGroupArgument(GroupArgument withGroupArgument) {
            this.withGroupArgument = withGroupArgument;
            return this;
        }

        public GetBuilderBuilder withSortArguments(SortArguments withSortArguments) {
            this.withSortArguments = withSortArguments;
            return this;
        }

        public GetBuilderBuilder withGenerativeSearch(GenerativeSearchBuilder withGenerativeSearch) {
            this.withGenerativeSearch = withGenerativeSearch;
            return this;
        }

        public GetBuilder build() {
            return new GetBuilder(this.className, this.fields, this.offset, this.limit, this.after, this.withWhereFilter, this.withNearTextFilter, this.withBm25Filter, this.withHybridFilter, this.withNearObjectFilter, this.withAskArgument, this.withNearImageFilter, this.withNearVectorFilter, this.withGroupArgument, this.withSortArguments, this.withGenerativeSearch);
        }

        public String toString() {
            return "GetBuilder.GetBuilderBuilder(className=" + this.className + ", fields=" + this.fields + ", offset=" + this.offset + ", limit=" + this.limit + ", after=" + this.after + ", withWhereFilter=" + this.withWhereFilter + ", withNearTextFilter=" + this.withNearTextFilter + ", withBm25Filter=" + this.withBm25Filter + ", withHybridFilter=" + this.withHybridFilter + ", withNearObjectFilter=" + this.withNearObjectFilter + ", withAskArgument=" + this.withAskArgument + ", withNearImageFilter=" + this.withNearImageFilter + ", withNearVectorFilter=" + this.withNearVectorFilter + ", withGroupArgument=" + this.withGroupArgument + ", withSortArguments=" + this.withSortArguments + ", withGenerativeSearch=" + this.withGenerativeSearch + ")";
        }
    }
}

