/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.graphql.query.fields;

import java.util.LinkedHashSet;
import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.v1.graphql.query.fields.Field;

public class GenerativeSearchBuilder {
    private final String singleResultPrompt;
    private final String groupedResultTask;

    public Field build() {
        LinkedHashSet<String> nameParts = new LinkedHashSet<String>();
        LinkedHashSet<String> fieldNames = new LinkedHashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)this.singleResultPrompt)) {
            nameParts.add(String.format("singleResult:{prompt:\"\"\"%s\"\"\"}", this.singleResultPrompt));
            fieldNames.add("singleResult");
        }
        if (StringUtils.isNotBlank((CharSequence)this.groupedResultTask)) {
            nameParts.add(String.format("groupedResult:{task:\"\"\"%s\"\"\"}", this.groupedResultTask));
            fieldNames.add("groupedResult");
        }
        if (nameParts.isEmpty()) {
            return Field.builder().build();
        }
        fieldNames.add("error");
        String name = String.format("generate(%s)", StringUtils.join(nameParts, (String)" "));
        Field[] fields = (Field[])fieldNames.stream().map(n -> Field.builder().name((String)n).build()).toArray(Field[]::new);
        return Field.builder().name(name).fields(fields).build();
    }

    GenerativeSearchBuilder(String singleResultPrompt, String groupedResultTask) {
        this.singleResultPrompt = singleResultPrompt;
        this.groupedResultTask = groupedResultTask;
    }

    public static GenerativeSearchBuilderBuilder builder() {
        return new GenerativeSearchBuilderBuilder();
    }

    public String getSingleResultPrompt() {
        return this.singleResultPrompt;
    }

    public String getGroupedResultTask() {
        return this.groupedResultTask;
    }

    public String toString() {
        return "GenerativeSearchBuilder(singleResultPrompt=" + this.getSingleResultPrompt() + ", groupedResultTask=" + this.getGroupedResultTask() + ")";
    }

    public static class GenerativeSearchBuilderBuilder {
        private String singleResultPrompt;
        private String groupedResultTask;

        GenerativeSearchBuilderBuilder() {
        }

        public GenerativeSearchBuilderBuilder singleResultPrompt(String singleResultPrompt) {
            this.singleResultPrompt = singleResultPrompt;
            return this;
        }

        public GenerativeSearchBuilderBuilder groupedResultTask(String groupedResultTask) {
            this.groupedResultTask = groupedResultTask;
            return this;
        }

        public GenerativeSearchBuilder build() {
            return new GenerativeSearchBuilder(this.singleResultPrompt, this.groupedResultTask);
        }

        public String toString() {
            return "GenerativeSearchBuilder.GenerativeSearchBuilderBuilder(singleResultPrompt=" + this.singleResultPrompt + ", groupedResultTask=" + this.groupedResultTask + ")";
        }
    }
}

