/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.misc.model;

import technology.semi.weaviate.client.v1.misc.model.PQConfig;

public class VectorIndexConfig {
    private final String distance;
    private final Integer ef;
    private final Integer efConstruction;
    private final Integer maxConnections;
    private final Integer dynamicEfMin;
    private final Integer dynamicEfMax;
    private final Integer dynamicEfFactor;
    private final Long vectorCacheMaxObjects;
    private final Integer flatSearchCutoff;
    private final Integer cleanupIntervalSeconds;
    private final Boolean skip;
    private final PQConfig pq;

    VectorIndexConfig(String distance, Integer ef, Integer efConstruction, Integer maxConnections, Integer dynamicEfMin, Integer dynamicEfMax, Integer dynamicEfFactor, Long vectorCacheMaxObjects, Integer flatSearchCutoff, Integer cleanupIntervalSeconds, Boolean skip, PQConfig pq) {
        this.distance = distance;
        this.ef = ef;
        this.efConstruction = efConstruction;
        this.maxConnections = maxConnections;
        this.dynamicEfMin = dynamicEfMin;
        this.dynamicEfMax = dynamicEfMax;
        this.dynamicEfFactor = dynamicEfFactor;
        this.vectorCacheMaxObjects = vectorCacheMaxObjects;
        this.flatSearchCutoff = flatSearchCutoff;
        this.cleanupIntervalSeconds = cleanupIntervalSeconds;
        this.skip = skip;
        this.pq = pq;
    }

    public static VectorIndexConfigBuilder builder() {
        return new VectorIndexConfigBuilder();
    }

    public String getDistance() {
        return this.distance;
    }

    public Integer getEf() {
        return this.ef;
    }

    public Integer getEfConstruction() {
        return this.efConstruction;
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public Integer getDynamicEfMin() {
        return this.dynamicEfMin;
    }

    public Integer getDynamicEfMax() {
        return this.dynamicEfMax;
    }

    public Integer getDynamicEfFactor() {
        return this.dynamicEfFactor;
    }

    public Long getVectorCacheMaxObjects() {
        return this.vectorCacheMaxObjects;
    }

    public Integer getFlatSearchCutoff() {
        return this.flatSearchCutoff;
    }

    public Integer getCleanupIntervalSeconds() {
        return this.cleanupIntervalSeconds;
    }

    public Boolean getSkip() {
        return this.skip;
    }

    public PQConfig getPq() {
        return this.pq;
    }

    public String toString() {
        return "VectorIndexConfig(distance=" + this.getDistance() + ", ef=" + this.getEf() + ", efConstruction=" + this.getEfConstruction() + ", maxConnections=" + this.getMaxConnections() + ", dynamicEfMin=" + this.getDynamicEfMin() + ", dynamicEfMax=" + this.getDynamicEfMax() + ", dynamicEfFactor=" + this.getDynamicEfFactor() + ", vectorCacheMaxObjects=" + this.getVectorCacheMaxObjects() + ", flatSearchCutoff=" + this.getFlatSearchCutoff() + ", cleanupIntervalSeconds=" + this.getCleanupIntervalSeconds() + ", skip=" + this.getSkip() + ", pq=" + this.getPq() + ")";
    }

    public static class VectorIndexConfigBuilder {
        private String distance;
        private Integer ef;
        private Integer efConstruction;
        private Integer maxConnections;
        private Integer dynamicEfMin;
        private Integer dynamicEfMax;
        private Integer dynamicEfFactor;
        private Long vectorCacheMaxObjects;
        private Integer flatSearchCutoff;
        private Integer cleanupIntervalSeconds;
        private Boolean skip;
        private PQConfig pq;

        VectorIndexConfigBuilder() {
        }

        public VectorIndexConfigBuilder distance(String distance) {
            this.distance = distance;
            return this;
        }

        public VectorIndexConfigBuilder ef(Integer ef) {
            this.ef = ef;
            return this;
        }

        public VectorIndexConfigBuilder efConstruction(Integer efConstruction) {
            this.efConstruction = efConstruction;
            return this;
        }

        public VectorIndexConfigBuilder maxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public VectorIndexConfigBuilder dynamicEfMin(Integer dynamicEfMin) {
            this.dynamicEfMin = dynamicEfMin;
            return this;
        }

        public VectorIndexConfigBuilder dynamicEfMax(Integer dynamicEfMax) {
            this.dynamicEfMax = dynamicEfMax;
            return this;
        }

        public VectorIndexConfigBuilder dynamicEfFactor(Integer dynamicEfFactor) {
            this.dynamicEfFactor = dynamicEfFactor;
            return this;
        }

        public VectorIndexConfigBuilder vectorCacheMaxObjects(Long vectorCacheMaxObjects) {
            this.vectorCacheMaxObjects = vectorCacheMaxObjects;
            return this;
        }

        public VectorIndexConfigBuilder flatSearchCutoff(Integer flatSearchCutoff) {
            this.flatSearchCutoff = flatSearchCutoff;
            return this;
        }

        public VectorIndexConfigBuilder cleanupIntervalSeconds(Integer cleanupIntervalSeconds) {
            this.cleanupIntervalSeconds = cleanupIntervalSeconds;
            return this;
        }

        public VectorIndexConfigBuilder skip(Boolean skip) {
            this.skip = skip;
            return this;
        }

        public VectorIndexConfigBuilder pq(PQConfig pq) {
            this.pq = pq;
            return this;
        }

        public VectorIndexConfig build() {
            return new VectorIndexConfig(this.distance, this.ef, this.efConstruction, this.maxConnections, this.dynamicEfMin, this.dynamicEfMax, this.dynamicEfFactor, this.vectorCacheMaxObjects, this.flatSearchCutoff, this.cleanupIntervalSeconds, this.skip, this.pq);
        }

        public String toString() {
            return "VectorIndexConfig.VectorIndexConfigBuilder(distance=" + this.distance + ", ef=" + this.ef + ", efConstruction=" + this.efConstruction + ", maxConnections=" + this.maxConnections + ", dynamicEfMin=" + this.dynamicEfMin + ", dynamicEfMax=" + this.dynamicEfMax + ", dynamicEfFactor=" + this.dynamicEfFactor + ", vectorCacheMaxObjects=" + this.vectorCacheMaxObjects + ", flatSearchCutoff=" + this.flatSearchCutoff + ", cleanupIntervalSeconds=" + this.cleanupIntervalSeconds + ", skip=" + this.skip + ", pq=" + this.pq + ")";
        }
    }
}

