// Generated by delombok at Tue Mar 14 16:45:46 CET 2023
package io.weaviate.client.v1.graphql.query.builder;

import io.weaviate.client.v1.graphql.query.argument.AskArgument;
import io.weaviate.client.v1.graphql.query.argument.NearImageArgument;
import io.weaviate.client.v1.graphql.query.argument.NearObjectArgument;
import io.weaviate.client.v1.graphql.query.argument.NearTextArgument;
import io.weaviate.client.v1.graphql.query.argument.NearVectorArgument;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import io.weaviate.client.v1.graphql.model.ExploreFields;

public class ExploreBuilder implements Query {
  private final ExploreFields[] fields;
  private final Integer offset;
  private final Integer limit;
  private final NearTextArgument withNearText;
  private final NearObjectArgument withNearObjectFilter;
  private final AskArgument withAskArgument;
  private final NearImageArgument withNearImageFilter;
  private final NearVectorArgument withNearVectorFilter;

  private String createFilterClause() {
    Set<String> filters = new LinkedHashSet<>();
    if (withNearText != null) {
      filters.add(withNearText.build());
    }
    if (withNearObjectFilter != null) {
      filters.add(withNearObjectFilter.build());
    }
    if (withNearVectorFilter != null) {
      filters.add(withNearVectorFilter.build());
    }
    if (withAskArgument != null) {
      filters.add(withAskArgument.build());
    }
    if (withNearImageFilter != null) {
      filters.add(withNearImageFilter.build());
    }
    if (limit != null) {
      filters.add(String.format("limit: %s", limit));
    }
    if (offset != null) {
      filters.add(String.format("offset: %s", offset));
    }
    return String.format("%s", StringUtils.joinWith(", ", filters.toArray()));
  }

  @Override
  public String buildQuery() {
    String fieldsClause = "";
    if (fields != null && fields.length > 0) {
      fieldsClause = StringUtils.joinWith(", ", (Object[]) fields);
    }
    String filterClause = createFilterClause();
    return String.format("{Explore(%s){%s}}", filterClause, fieldsClause);
  }

  @java.lang.SuppressWarnings("all")
  ExploreBuilder(final ExploreFields[] fields, final Integer offset, final Integer limit, final NearTextArgument withNearText, final NearObjectArgument withNearObjectFilter, final AskArgument withAskArgument, final NearImageArgument withNearImageFilter, final NearVectorArgument withNearVectorFilter) {
    this.fields = fields;
    this.offset = offset;
    this.limit = limit;
    this.withNearText = withNearText;
    this.withNearObjectFilter = withNearObjectFilter;
    this.withAskArgument = withAskArgument;
    this.withNearImageFilter = withNearImageFilter;
    this.withNearVectorFilter = withNearVectorFilter;
  }


  @java.lang.SuppressWarnings("all")
  public static class ExploreBuilderBuilder {
    @java.lang.SuppressWarnings("all")
    private ExploreFields[] fields;
    @java.lang.SuppressWarnings("all")
    private Integer offset;
    @java.lang.SuppressWarnings("all")
    private Integer limit;
    @java.lang.SuppressWarnings("all")
    private NearTextArgument withNearText;
    @java.lang.SuppressWarnings("all")
    private NearObjectArgument withNearObjectFilter;
    @java.lang.SuppressWarnings("all")
    private AskArgument withAskArgument;
    @java.lang.SuppressWarnings("all")
    private NearImageArgument withNearImageFilter;
    @java.lang.SuppressWarnings("all")
    private NearVectorArgument withNearVectorFilter;

    @java.lang.SuppressWarnings("all")
    ExploreBuilderBuilder() {
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ExploreBuilder.ExploreBuilderBuilder fields(final ExploreFields[] fields) {
      this.fields = fields;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ExploreBuilder.ExploreBuilderBuilder offset(final Integer offset) {
      this.offset = offset;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ExploreBuilder.ExploreBuilderBuilder limit(final Integer limit) {
      this.limit = limit;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ExploreBuilder.ExploreBuilderBuilder withNearText(final NearTextArgument withNearText) {
      this.withNearText = withNearText;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ExploreBuilder.ExploreBuilderBuilder withNearObjectFilter(final NearObjectArgument withNearObjectFilter) {
      this.withNearObjectFilter = withNearObjectFilter;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ExploreBuilder.ExploreBuilderBuilder withAskArgument(final AskArgument withAskArgument) {
      this.withAskArgument = withAskArgument;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ExploreBuilder.ExploreBuilderBuilder withNearImageFilter(final NearImageArgument withNearImageFilter) {
      this.withNearImageFilter = withNearImageFilter;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ExploreBuilder.ExploreBuilderBuilder withNearVectorFilter(final NearVectorArgument withNearVectorFilter) {
      this.withNearVectorFilter = withNearVectorFilter;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public ExploreBuilder build() {
      return new ExploreBuilder(this.fields, this.offset, this.limit, this.withNearText, this.withNearObjectFilter, this.withAskArgument, this.withNearImageFilter, this.withNearVectorFilter);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
      return "ExploreBuilder.ExploreBuilderBuilder(fields=" + java.util.Arrays.deepToString(this.fields) + ", offset=" + this.offset + ", limit=" + this.limit + ", withNearText=" + this.withNearText + ", withNearObjectFilter=" + this.withNearObjectFilter + ", withAskArgument=" + this.withAskArgument + ", withNearImageFilter=" + this.withNearImageFilter + ", withNearVectorFilter=" + this.withNearVectorFilter + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  public static ExploreBuilder.ExploreBuilderBuilder builder() {
    return new ExploreBuilder.ExploreBuilderBuilder();
  }

  @java.lang.SuppressWarnings("all")
  public ExploreFields[] getFields() {
    return this.fields;
  }

  @java.lang.SuppressWarnings("all")
  public Integer getOffset() {
    return this.offset;
  }

  @java.lang.SuppressWarnings("all")
  public Integer getLimit() {
    return this.limit;
  }

  @java.lang.SuppressWarnings("all")
  public NearTextArgument getWithNearText() {
    return this.withNearText;
  }

  @java.lang.SuppressWarnings("all")
  public NearObjectArgument getWithNearObjectFilter() {
    return this.withNearObjectFilter;
  }

  @java.lang.SuppressWarnings("all")
  public AskArgument getWithAskArgument() {
    return this.withAskArgument;
  }

  @java.lang.SuppressWarnings("all")
  public NearImageArgument getWithNearImageFilter() {
    return this.withNearImageFilter;
  }

  @java.lang.SuppressWarnings("all")
  public NearVectorArgument getWithNearVectorFilter() {
    return this.withNearVectorFilter;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public java.lang.String toString() {
    return "ExploreBuilder(fields=" + java.util.Arrays.deepToString(this.getFields()) + ", offset=" + this.getOffset() + ", limit=" + this.getLimit() + ", withNearText=" + this.getWithNearText() + ", withNearObjectFilter=" + this.getWithNearObjectFilter() + ", withAskArgument=" + this.getWithAskArgument() + ", withNearImageFilter=" + this.getWithNearImageFilter() + ", withNearVectorFilter=" + this.getWithNearVectorFilter() + ")";
  }
}
