/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.data.api;

import io.weaviate.client.Config;
import io.weaviate.client.base.BaseClient;
import io.weaviate.client.base.ClientResult;
import io.weaviate.client.base.Response;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.WeaviateErrorMessage;
import io.weaviate.client.base.WeaviateErrorResponse;
import io.weaviate.client.base.http.HttpClient;
import io.weaviate.client.v1.data.util.ObjectsPath;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class ObjectDeleter
extends BaseClient<String>
implements ClientResult<Boolean> {
    private final ObjectsPath objectsPath;
    private String id;
    private String className;
    private String consistencyLevel;

    public ObjectDeleter(HttpClient httpClient, Config config, ObjectsPath objectsPath) {
        super(httpClient, config);
        this.objectsPath = Objects.requireNonNull(objectsPath);
    }

    public ObjectDeleter withID(String id) {
        this.id = id;
        return this;
    }

    public ObjectDeleter withClassName(String className) {
        this.className = className;
        return this;
    }

    public ObjectDeleter withConsistencyLevel(String consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    @Override
    public Result<Boolean> run() {
        if (StringUtils.isEmpty((CharSequence)this.id)) {
            WeaviateErrorMessage errorMessage = WeaviateErrorMessage.builder().message("id cannot be empty").build();
            WeaviateErrorResponse errors = WeaviateErrorResponse.builder().error(Stream.of(errorMessage).collect(Collectors.toList())).build();
            return new Result<Boolean>(500, false, errors);
        }
        String path = this.objectsPath.buildDelete(ObjectsPath.Params.builder().id(this.id).className(this.className).consistencyLevel(this.consistencyLevel).build());
        Response<String> resp = this.sendDeleteRequest(path, null, String.class);
        return new Result<Boolean>(resp.getStatusCode(), resp.getStatusCode() == 204, resp.getErrors());
    }
}

