/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.query.builder;

import io.weaviate.client.v1.graphql.model.ExploreFields;
import io.weaviate.client.v1.graphql.query.argument.AskArgument;
import io.weaviate.client.v1.graphql.query.argument.NearImageArgument;
import io.weaviate.client.v1.graphql.query.argument.NearObjectArgument;
import io.weaviate.client.v1.graphql.query.argument.NearTextArgument;
import io.weaviate.client.v1.graphql.query.argument.NearVectorArgument;
import io.weaviate.client.v1.graphql.query.builder.Query;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.StringUtils;

public class ExploreBuilder
implements Query {
    private final ExploreFields[] fields;
    private final Integer offset;
    private final Integer limit;
    private final NearTextArgument withNearText;
    private final NearObjectArgument withNearObjectFilter;
    private final AskArgument withAskArgument;
    private final NearImageArgument withNearImageFilter;
    private final NearVectorArgument withNearVectorFilter;

    private String createFilterClause() {
        LinkedHashSet<String> filters = new LinkedHashSet<String>();
        if (this.withNearText != null) {
            filters.add(this.withNearText.build());
        }
        if (this.withNearObjectFilter != null) {
            filters.add(this.withNearObjectFilter.build());
        }
        if (this.withNearVectorFilter != null) {
            filters.add(this.withNearVectorFilter.build());
        }
        if (this.withAskArgument != null) {
            filters.add(this.withAskArgument.build());
        }
        if (this.withNearImageFilter != null) {
            filters.add(this.withNearImageFilter.build());
        }
        if (this.limit != null) {
            filters.add(String.format("limit: %s", this.limit));
        }
        if (this.offset != null) {
            filters.add(String.format("offset: %s", this.offset));
        }
        return String.format("%s", StringUtils.joinWith((String)", ", (Object[])filters.toArray()));
    }

    @Override
    public String buildQuery() {
        String fieldsClause = "";
        if (this.fields != null && this.fields.length > 0) {
            fieldsClause = StringUtils.joinWith((String)", ", (Object[])((Object[])this.fields));
        }
        String filterClause = this.createFilterClause();
        return String.format("{Explore(%s){%s}}", filterClause, fieldsClause);
    }

    ExploreBuilder(ExploreFields[] fields, Integer offset, Integer limit, NearTextArgument withNearText, NearObjectArgument withNearObjectFilter, AskArgument withAskArgument, NearImageArgument withNearImageFilter, NearVectorArgument withNearVectorFilter) {
        this.fields = fields;
        this.offset = offset;
        this.limit = limit;
        this.withNearText = withNearText;
        this.withNearObjectFilter = withNearObjectFilter;
        this.withAskArgument = withAskArgument;
        this.withNearImageFilter = withNearImageFilter;
        this.withNearVectorFilter = withNearVectorFilter;
    }

    public static ExploreBuilderBuilder builder() {
        return new ExploreBuilderBuilder();
    }

    public ExploreFields[] getFields() {
        return this.fields;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public NearTextArgument getWithNearText() {
        return this.withNearText;
    }

    public NearObjectArgument getWithNearObjectFilter() {
        return this.withNearObjectFilter;
    }

    public AskArgument getWithAskArgument() {
        return this.withAskArgument;
    }

    public NearImageArgument getWithNearImageFilter() {
        return this.withNearImageFilter;
    }

    public NearVectorArgument getWithNearVectorFilter() {
        return this.withNearVectorFilter;
    }

    public String toString() {
        return "ExploreBuilder(fields=" + Arrays.deepToString((Object[])this.getFields()) + ", offset=" + this.getOffset() + ", limit=" + this.getLimit() + ", withNearText=" + this.getWithNearText() + ", withNearObjectFilter=" + this.getWithNearObjectFilter() + ", withAskArgument=" + this.getWithAskArgument() + ", withNearImageFilter=" + this.getWithNearImageFilter() + ", withNearVectorFilter=" + this.getWithNearVectorFilter() + ")";
    }

    public static class ExploreBuilderBuilder {
        private ExploreFields[] fields;
        private Integer offset;
        private Integer limit;
        private NearTextArgument withNearText;
        private NearObjectArgument withNearObjectFilter;
        private AskArgument withAskArgument;
        private NearImageArgument withNearImageFilter;
        private NearVectorArgument withNearVectorFilter;

        ExploreBuilderBuilder() {
        }

        public ExploreBuilderBuilder fields(ExploreFields[] fields) {
            this.fields = fields;
            return this;
        }

        public ExploreBuilderBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public ExploreBuilderBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public ExploreBuilderBuilder withNearText(NearTextArgument withNearText) {
            this.withNearText = withNearText;
            return this;
        }

        public ExploreBuilderBuilder withNearObjectFilter(NearObjectArgument withNearObjectFilter) {
            this.withNearObjectFilter = withNearObjectFilter;
            return this;
        }

        public ExploreBuilderBuilder withAskArgument(AskArgument withAskArgument) {
            this.withAskArgument = withAskArgument;
            return this;
        }

        public ExploreBuilderBuilder withNearImageFilter(NearImageArgument withNearImageFilter) {
            this.withNearImageFilter = withNearImageFilter;
            return this;
        }

        public ExploreBuilderBuilder withNearVectorFilter(NearVectorArgument withNearVectorFilter) {
            this.withNearVectorFilter = withNearVectorFilter;
            return this;
        }

        public ExploreBuilder build() {
            return new ExploreBuilder(this.fields, this.offset, this.limit, this.withNearText, this.withNearObjectFilter, this.withAskArgument, this.withNearImageFilter, this.withNearVectorFilter);
        }

        public String toString() {
            return "ExploreBuilder.ExploreBuilderBuilder(fields=" + Arrays.deepToString((Object[])this.fields) + ", offset=" + this.offset + ", limit=" + this.limit + ", withNearText=" + this.withNearText + ", withNearObjectFilter=" + this.withNearObjectFilter + ", withAskArgument=" + this.withAskArgument + ", withNearImageFilter=" + this.withNearImageFilter + ", withNearVectorFilter=" + this.withNearVectorFilter + ")";
        }
    }
}

