/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.schema.model;

import io.weaviate.client.v1.schema.model.WeaviateClass;
import java.util.List;

public class Schema {
    private final String name;
    private final String maintainer;
    private final List<WeaviateClass> classes;

    Schema(String name, String maintainer, List<WeaviateClass> classes) {
        this.name = name;
        this.maintainer = maintainer;
        this.classes = classes;
    }

    public static SchemaBuilder builder() {
        return new SchemaBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getMaintainer() {
        return this.maintainer;
    }

    public List<WeaviateClass> getClasses() {
        return this.classes;
    }

    public String toString() {
        return "Schema(name=" + this.getName() + ", maintainer=" + this.getMaintainer() + ", classes=" + this.getClasses() + ")";
    }

    public static class SchemaBuilder {
        private String name;
        private String maintainer;
        private List<WeaviateClass> classes;

        SchemaBuilder() {
        }

        public SchemaBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SchemaBuilder maintainer(String maintainer) {
            this.maintainer = maintainer;
            return this;
        }

        public SchemaBuilder classes(List<WeaviateClass> classes) {
            this.classes = classes;
            return this;
        }

        public Schema build() {
            return new Schema(this.name, this.maintainer, this.classes);
        }

        public String toString() {
            return "Schema.SchemaBuilder(name=" + this.name + ", maintainer=" + this.maintainer + ", classes=" + this.classes + ")";
        }
    }
}

