/*
 * Decompiled with CFR 0.152.
 */
package technology.transceptor.qpack;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import technology.transceptor.qpack.Types;

public class QPack {
    private final ByteArrayOutputStream bytesContainer = new ByteArrayOutputStream();
    private final DataOutputStream container = new DataOutputStream(this.bytesContainer);
    private int position = 0;

    private byte[] toBytes(long number, int size) {
        byte[] result = new byte[size];
        int i = 0;
        while (i < size) {
            result[i] = (byte)(number >> i * 8);
            ++i;
        }
        return result;
    }

    private Number convertByteToNumber(byte[] b, int tp) {
        ByteBuffer wrapped = ByteBuffer.wrap(b);
        wrapped.order(ByteOrder.LITTLE_ENDIAN);
        if (tp == 236) {
            return wrapped.getDouble();
        }
        switch (b.length) {
            case 1: {
                return (int)wrapped.get(0);
            }
            case 2: {
                return (int)wrapped.getShort();
            }
            case 4: {
                return wrapped.getInt();
            }
            case 8: {
                return wrapped.getLong();
            }
        }
        return 0;
    }

    private byte[] packRecursive(Object data) throws IOException {
        if (data == null) {
            this.container.writeByte(-5);
            return this.bytesContainer.toByteArray();
        }
        if (data instanceof Boolean) {
            if (((Boolean)data).booleanValue()) {
                this.container.writeByte(-7);
            } else {
                this.container.writeByte(-6);
            }
            return this.bytesContainer.toByteArray();
        }
        if (data instanceof Number) {
            if (data instanceof Double) {
                if ((Double)data == 0.0) {
                    this.container.write(126);
                } else if ((Double)data == 1.0) {
                    this.container.write(127);
                } else if ((Double)data == -1.0) {
                    this.container.write(125);
                } else {
                    ByteBuffer b = ByteBuffer.allocate(8);
                    b.order(ByteOrder.LITTLE_ENDIAN);
                    b.putDouble((Double)data);
                    this.container.write(-20);
                    this.container.write(b.array());
                }
                return this.bytesContainer.toByteArray();
            }
            long length = 0L;
            if (data instanceof Long) {
                length = (Long)data;
            } else if (data instanceof Integer) {
                length = ((Integer)data).intValue();
            } else if (data instanceof Short) {
                length = ((Short)data).shortValue();
            } else if (data instanceof Byte) {
                length = ((Byte)data).byteValue();
            }
            if (length < 64L && length >= 0L) {
                this.container.write((int)length);
                return this.bytesContainer.toByteArray();
            }
            if (length < 0L && length >= -63L) {
                this.container.write(63 - (int)length);
                return this.bytesContainer.toByteArray();
            }
            if (length <= 127L && length >= -128L) {
                this.container.writeByte(-24);
                this.container.write(this.toBytes(length, 1));
            } else if (length <= 32767L && length >= -32768L) {
                this.container.writeByte(-23);
                this.container.write(this.toBytes(length, 2));
            } else if (length <= Integer.MAX_VALUE && length >= Integer.MIN_VALUE) {
                this.container.writeByte(-22);
                this.container.write(this.toBytes(length, 4));
            } else if (length <= Long.MAX_VALUE && length >= Long.MIN_VALUE) {
                this.container.writeByte(-21);
                this.container.write(this.toBytes(length, 8));
            } else {
                throw new IllegalArgumentException("qpack allows up to 64bit signed integers, got bit length: " + length);
            }
            return this.bytesContainer.toByteArray();
        }
        if (data instanceof String || data instanceof byte[]) {
            byte[] bytes = data instanceof String ? ((String)data).getBytes() : (byte[])data;
            long length = bytes.length;
            if (length < 100L) {
                this.container.writeByte(128 + (int)length);
            } else if (length < 256L) {
                ByteBuffer bb = ByteBuffer.allocate(1);
                bb.order(ByteOrder.LITTLE_ENDIAN);
                bb.put((byte)length);
                this.container.writeByte(-28);
                this.container.write(bb.array());
            } else if (length < 65536L) {
                ByteBuffer bb = ByteBuffer.allocate(2);
                bb.order(ByteOrder.LITTLE_ENDIAN);
                bb.putShort((short)length);
                this.container.writeByte(-27);
                this.container.write(bb.array());
            } else if (length < 0x100000000L) {
                ByteBuffer bb = ByteBuffer.allocate(4);
                bb.order(ByteOrder.LITTLE_ENDIAN);
                bb.putInt((int)length);
                this.container.writeByte(-26);
                this.container.write(bb.array());
            } else if (length < Long.MAX_VALUE) {
                ByteBuffer bb = ByteBuffer.allocate(8);
                bb.order(ByteOrder.LITTLE_ENDIAN);
                bb.putLong(length);
                this.container.writeByte(-25);
                this.container.write(bb.array());
            } else {
                throw new IllegalArgumentException("raw string length too large to fit in qpack: " + length);
            }
            this.container.write(bytes);
            return this.bytesContainer.toByteArray();
        }
        if (data.getClass().isArray()) {
            int l = Array.getLength(data);
            if (l < 6) {
                this.container.writeByte(-19 + l);
                int i = 0;
                while (i < l) {
                    this.packRecursive(Array.get(data, i));
                    ++i;
                }
            } else {
                this.container.writeByte(-4);
                int i = 0;
                while (i < l) {
                    this.packRecursive(Array.get(data, i));
                    ++i;
                }
                this.container.writeByte(-2);
            }
            return this.bytesContainer.toByteArray();
        }
        if (data instanceof Collection) {
            int l = ((Collection)data).size();
            if (l < 6) {
                this.container.writeByte(-19 + l);
                for (Object o : (Collection)data) {
                    this.packRecursive(o);
                }
            } else {
                this.container.writeByte(-4);
                for (Object o : (Collection)data) {
                    this.packRecursive(o);
                }
                this.container.writeByte(-2);
            }
            return this.bytesContainer.toByteArray();
        }
        if (data instanceof Map) {
            int l = ((Map)data).size();
            if (l < 6) {
                this.container.writeByte(-13 + l);
                for (Map.Entry o : ((Map)data).entrySet()) {
                    this.packRecursive(o.getKey());
                    this.packRecursive(o.getValue());
                }
            } else {
                this.container.writeByte(-3);
                for (Map.Entry o : ((Map)data).entrySet()) {
                    this.packRecursive(o.getKey());
                    this.packRecursive(o.getValue());
                }
                this.container.writeByte(-1);
            }
            return this.bytesContainer.toByteArray();
        }
        throw new IllegalArgumentException("packing type " + data.getClass().getName() + " is not supported with qpack");
    }

    private Object unpackRecursive(byte[] data, int pos, int end, String decoder) {
        int i;
        int qpType;
        int p;
        int tp = data[this.position] & 0xFF;
        this.position = ++pos;
        if (tp < 64) {
            return tp;
        }
        if (tp < 124) {
            return 63 - tp;
        }
        if (tp == 124) {
            return 0;
        }
        if (tp < 128) {
            return (double)tp - 126.0;
        }
        if (tp < 228) {
            int endPos = this.position + (tp - 128);
            p = this.position;
            this.position = endPos;
            if (decoder == null) {
                return Arrays.copyOfRange(data, p, endPos);
            }
            try {
                return new String(Arrays.copyOfRange(data, p, endPos), decoder);
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(QPack.class.getName()).log(Level.SEVERE, "The Character Encoding " + decoder + " is not supported", ex);
            }
        }
        if (tp < 232) {
            qpType = Types.RAW_MAP.get(tp);
            int endPos = this.position + qpType + data.length;
            int p2 = this.position + qpType;
            this.position = endPos;
            if (decoder == null) {
                return Arrays.copyOfRange(data, p2, data.length);
            }
            try {
                return new String(Arrays.copyOfRange(data, p2, data.length), decoder);
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(QPack.class.getName()).log(Level.SEVERE, "The Character Encoding " + decoder + " is not supported", ex);
            }
        }
        if (tp < 237) {
            qpType = Types.NUMBER_MAP.get(tp);
            p = this.position;
            this.position += qpType;
            return this.convertByteToNumber(Arrays.copyOfRange(data, p, p + qpType), tp);
        }
        if (tp < 243) {
            Object[] array = new Object[tp - 237];
            i = 0;
            while (i < tp - 237) {
                Object value;
                array[i] = value = this.unpackRecursive(data, this.position, end, decoder);
                ++i;
            }
            return array;
        }
        if (tp < 249) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            i = 0;
            while (i < tp - 243) {
                Object key = this.unpackRecursive(data, this.position, end, decoder);
                Object value = this.unpackRecursive(data, this.position, end, decoder);
                map.put(key, value);
                ++i;
            }
            return map;
        }
        if (tp < 252) {
            return Types.SIMPLE_MAP.get(tp);
        }
        if (tp == 252) {
            ArrayList<Object> list = new ArrayList<Object>();
            while (this.position < end && data[this.position] != -2) {
                Object value = this.unpackRecursive(data, this.position, end, decoder);
                list.add(value);
            }
            ++this.position;
            return list.toArray();
        }
        if (tp == 253) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            while (this.position < end && data[this.position] != -1) {
                Object key = this.unpackRecursive(data, this.position, end, decoder);
                Object value = this.unpackRecursive(data, this.position, end, decoder);
                map.put(key, value);
            }
            ++this.position;
            return map;
        }
        throw new IllegalArgumentException("Error in qpack at position " + this.position);
    }

    public byte[] pack(Object data) {
        try {
            this.container.close();
        }
        catch (IOException ex) {
            Logger.getLogger(QPack.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.bytesContainer.reset();
        byte[] output = null;
        try {
            output = this.packRecursive(data);
        }
        catch (IOException ex) {
            Logger.getLogger(QPack.class.getName()).log(Level.SEVERE, null, ex);
        }
        return output;
    }

    public Object unpack(byte[] data) {
        this.position = 0;
        return this.unpackRecursive(data, 0, data.length, null);
    }

    public Object unpack(byte[] data, String decoder) {
        this.position = 0;
        return this.unpackRecursive(data, 0, data.length, decoder);
    }
}

