/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.map;

import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class String2FloatOpenHashMapWritable
extends Object2FloatOpenHashMap<String>
implements Writable {
    private static final long serialVersionUID = 341896587341098L;

    public void readFields(DataInput in) throws IOException {
        this.clear();
        int numEntries = in.readInt();
        if (numEntries == 0) {
            return;
        }
        for (int i = 0; i < numEntries; ++i) {
            String k = in.readUTF();
            float v = in.readFloat();
            super.put((Object)k, v);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.size() == 0) {
            return;
        }
        for (Object2FloatMap.Entry e : this.object2FloatEntrySet()) {
            out.writeUTF((String)e.getKey());
            out.writeFloat(((Float)e.getValue()).floatValue());
        }
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        this.write(dataOut);
        return bytesOut.toByteArray();
    }

    public static String2FloatOpenHashMapWritable create(DataInput in) throws IOException {
        String2FloatOpenHashMapWritable m = new String2FloatOpenHashMapWritable();
        m.readFields(in);
        return m;
    }

    public static String2FloatOpenHashMapWritable create(byte[] bytes) throws IOException {
        return String2FloatOpenHashMapWritable.create(new DataInputStream(new ByteArrayInputStream(bytes)));
    }

    public void plus(String2FloatOpenHashMapWritable m) {
        for (Object2FloatMap.Entry e : m.object2FloatEntrySet()) {
            String key = (String)e.getKey();
            if (this.containsKey(key)) {
                this.put(key, this.get(key).floatValue() + ((Float)e.getValue()).floatValue());
                continue;
            }
            this.put(key, (Float)e.getValue());
        }
    }

    public int dot(String2FloatOpenHashMapWritable m) {
        int s = 0;
        for (Object2FloatMap.Entry e : m.object2FloatEntrySet()) {
            String key = (String)e.getKey();
            if (!this.containsKey(key)) continue;
            s = (int)((float)s + this.get(key).floatValue() * ((Float)e.getValue()).floatValue());
        }
        return s;
    }

    public void increment(String key) {
        this.increment(key, 1.0f);
    }

    public void increment(String key, float n) {
        if (this.containsKey(key)) {
            this.put(key, this.get(key).floatValue() + n);
        } else {
            this.put(key, n);
        }
    }
}

