/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.map;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.hadoop.io.Writable;

public class Int2IntOpenHashMapWritable
extends Int2IntOpenHashMap
implements Writable {
    private static final long serialVersionUID = 1255879065743242L;
    private static boolean LAZY_DECODE = false;
    private int numEntries = 0;
    private int[] keys = null;
    private int[] values = null;

    public void readFields(DataInput in) throws IOException {
        this.clear();
        this.numEntries = in.readInt();
        if (this.numEntries == 0) {
            return;
        }
        if (LAZY_DECODE) {
            this.keys = new int[this.numEntries];
            this.values = new int[this.numEntries];
            for (int i = 0; i < this.numEntries; ++i) {
                this.keys[i] = in.readInt();
                this.values[i] = in.readInt();
            }
        } else {
            for (int i = 0; i < this.numEntries; ++i) {
                this.put(in.readInt(), in.readInt());
            }
        }
    }

    public void decode() {
        if (this.keys == null) {
            return;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            this.put(this.keys[i], this.values[i]);
        }
        this.keys = null;
    }

    public boolean hasBeenDecoded() {
        return this.keys == null;
    }

    public void write(DataOutput out) throws IOException {
        if (this.keys == null) {
            out.writeInt(this.size());
            if (this.size() == 0) {
                return;
            }
            for (Int2IntMap.Entry e : this.int2IntEntrySet()) {
                out.writeInt(e.getIntKey());
                out.writeInt(e.getIntValue());
            }
        } else {
            out.writeInt(this.numEntries);
            for (int i = 0; i < this.numEntries; ++i) {
                out.writeInt(this.keys[i]);
                out.writeInt(this.values[i]);
            }
        }
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        this.write(dataOut);
        return bytesOut.toByteArray();
    }

    public static Int2IntOpenHashMapWritable create(DataInput in) throws IOException {
        Int2IntOpenHashMapWritable m = new Int2IntOpenHashMapWritable();
        m.readFields(in);
        return m;
    }

    public static Int2IntOpenHashMapWritable create(byte[] bytes) throws IOException {
        return Int2IntOpenHashMapWritable.create(new DataInputStream(new ByteArrayInputStream(bytes)));
    }

    public void plus(Int2IntOpenHashMapWritable m) {
        for (Int2IntMap.Entry e : m.int2IntEntrySet()) {
            int key = e.getIntKey();
            int value = e.getIntValue();
            if (this.containsKey(key)) {
                this.put(key, this.get(key) + value);
                continue;
            }
            this.put(key, value);
        }
    }

    public int dot(Int2IntOpenHashMapWritable m) {
        int s = 0;
        for (Int2IntMap.Entry e : m.int2IntEntrySet()) {
            int key = e.getIntKey();
            if (!this.containsKey(key)) continue;
            s += this.get(key) * e.getIntValue();
        }
        return s;
    }

    public void increment(int key) {
        this.increment(key, 1);
    }

    public void increment(int key, int n) {
        if (this.containsKey(key)) {
            this.put(key, this.get(key) + n);
        } else {
            this.put(key, n);
        }
    }

    public static void setLazyDecodeFlag(boolean b) {
        LAZY_DECODE = b;
    }

    public static boolean getLazyDecodeFlag() {
        return LAZY_DECODE;
    }

    public int[] getKeys() {
        return this.keys;
    }

    public int[] getValues() {
        return this.values;
    }

    public void lazyplus(Int2IntOpenHashMapWritable m) {
        int[] k = m.getKeys();
        int[] v = m.getValues();
        for (int i = 0; i < k.length; ++i) {
            if (this.containsKey(k[i])) {
                this.put(k[i], this.get(k[i]) + v[i]);
                continue;
            }
            this.put(k[i], v[i]);
        }
    }

    public Int2IntMap.Entry[] getEntriesSortedByValue() {
        if (this.size() == 0) {
            return null;
        }
        Object[] entries = new Int2IntMap.Entry[this.size()];
        entries = (Int2IntMap.Entry[])this.int2IntEntrySet().toArray(entries);
        Arrays.sort(entries, new Comparator<Int2IntMap.Entry>(){

            @Override
            public int compare(Int2IntMap.Entry e1, Int2IntMap.Entry e2) {
                if (e1.getIntValue() > e2.getIntValue()) {
                    return -1;
                }
                if (e1.getIntValue() < e2.getIntValue()) {
                    return 1;
                }
                if (e1.getIntKey() == e2.getIntKey()) {
                    return 0;
                }
                return e1.getIntKey() > e2.getIntKey() ? 1 : -1;
            }
        });
        return entries;
    }

    public Int2IntMap.Entry[] getEntriesSortedByValue(int k) {
        Int2IntMap.Entry[] entries = this.getEntriesSortedByValue();
        if (entries == null) {
            return null;
        }
        if (entries.length < k) {
            return entries;
        }
        return Arrays.copyOfRange(entries, 0, k);
    }
}

