/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.map;

import it.unimi.dsi.fastutil.ints.Int2FloatMap;
import it.unimi.dsi.fastutil.ints.Int2FloatOpenHashMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.hadoop.io.Writable;

public class Int2FloatOpenHashMapWritable
extends Int2FloatOpenHashMap
implements Writable {
    private static final long serialVersionUID = 674980125439241L;
    private static boolean LAZY_DECODE = false;
    private int numEntries = 0;
    private int[] keys = null;
    private float[] values = null;

    public void readFields(DataInput in) throws IOException {
        this.clear();
        this.numEntries = in.readInt();
        if (this.numEntries == 0) {
            return;
        }
        if (LAZY_DECODE) {
            this.keys = new int[this.numEntries];
            this.values = new float[this.numEntries];
            for (int i = 0; i < this.numEntries; ++i) {
                this.keys[i] = in.readInt();
                this.values[i] = in.readFloat();
            }
        } else {
            for (int i = 0; i < this.numEntries; ++i) {
                super.put(in.readInt(), in.readFloat());
            }
        }
    }

    public void decode() throws IOException {
        if (this.keys == null) {
            return;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            this.put(this.keys[i], this.values[i]);
        }
        this.keys = null;
    }

    public boolean hasBeenDecoded() {
        return this.keys == null;
    }

    public void write(DataOutput out) throws IOException {
        if (this.keys == null) {
            out.writeInt(this.size());
            if (this.size() == 0) {
                return;
            }
            for (Int2FloatMap.Entry e : this.int2FloatEntrySet()) {
                out.writeInt((Integer)e.getKey());
                out.writeFloat(((Float)e.getValue()).floatValue());
            }
        } else {
            out.writeInt(this.numEntries);
            for (int i = 0; i < this.numEntries; ++i) {
                out.writeInt(this.keys[i]);
                out.writeFloat(this.values[i]);
            }
        }
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        this.write(dataOut);
        return bytesOut.toByteArray();
    }

    public static Int2FloatOpenHashMapWritable create(DataInput in) throws IOException {
        Int2FloatOpenHashMapWritable m = new Int2FloatOpenHashMapWritable();
        m.readFields(in);
        return m;
    }

    public static Int2FloatOpenHashMapWritable create(byte[] bytes) throws IOException {
        return Int2FloatOpenHashMapWritable.create(new DataInputStream(new ByteArrayInputStream(bytes)));
    }

    public void plus(Int2FloatOpenHashMapWritable m) {
        for (Int2FloatMap.Entry e : m.int2FloatEntrySet()) {
            int key = (Integer)e.getKey();
            float value = ((Float)e.getValue()).floatValue();
            if (this.containsKey(key)) {
                this.put(key, this.get(key) + value);
                continue;
            }
            this.put(key, value);
        }
    }

    public int dot(Int2FloatOpenHashMapWritable m) {
        int s = 0;
        for (Int2FloatMap.Entry e : m.int2FloatEntrySet()) {
            int key = (Integer)e.getKey();
            if (!this.containsKey(key)) continue;
            s = (int)((float)s + this.get(key) * ((Float)e.getValue()).floatValue());
        }
        return s;
    }

    public void increment(int key) {
        this.increment(key, 1.0f);
    }

    public void increment(int key, float n) {
        if (this.containsKey(key)) {
            this.put(key, this.get(key) + n);
        } else {
            this.put(key, n);
        }
    }

    public static void setLazyDecodeFlag(boolean b) {
        LAZY_DECODE = b;
    }

    public static boolean getLazyDecodeFlag() {
        return LAZY_DECODE;
    }

    public int[] getKeys() {
        return this.keys;
    }

    public float[] getValues() {
        return this.values;
    }

    public void lazyplus(Int2FloatOpenHashMapWritable m) {
        int[] keys = m.getKeys();
        float[] values = m.getValues();
        for (int i = 0; i < keys.length; ++i) {
            if (this.containsKey(keys[i])) {
                this.put(keys[i], this.get(keys[i]) + values[i]);
                continue;
            }
            this.put(keys[i], values[i]);
        }
    }

    public Int2FloatMap.Entry[] getEntriesSortedByValue() {
        if (this.size() == 0) {
            return null;
        }
        Object[] entries = new Int2FloatMap.Entry[this.size()];
        entries = (Int2FloatMap.Entry[])this.int2FloatEntrySet().toArray(entries);
        Arrays.sort(entries, new Comparator<Int2FloatMap.Entry>(){

            @Override
            public int compare(Int2FloatMap.Entry e1, Int2FloatMap.Entry e2) {
                if (e1.getFloatValue() > e2.getFloatValue()) {
                    return -1;
                }
                if (e1.getFloatValue() < e2.getFloatValue()) {
                    return 1;
                }
                if (e1.getIntKey() == e2.getIntKey()) {
                    return 0;
                }
                return e1.getIntKey() > e2.getIntKey() ? 1 : -1;
            }
        });
        return entries;
    }

    public Int2FloatMap.Entry[] getEntriesSortedByValue(int k) {
        Int2FloatMap.Entry[] entries = this.getEntriesSortedByValue();
        if (entries == null) {
            return null;
        }
        if (entries.length < k) {
            return entries;
        }
        return Arrays.copyOfRange(entries, 0, k);
    }
}

