/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.map;

import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.hadoop.io.Writable;

public class Int2LongOpenHashMapWritable
extends Int2LongOpenHashMap
implements Writable {
    private static final long serialVersionUID = 1029363828020488531L;
    private static boolean LAZY_DECODE = false;
    private int numEntries = 0;
    private int[] keys = null;
    private long[] values = null;

    public void readFields(DataInput in) throws IOException {
        this.clear();
        this.numEntries = in.readInt();
        if (this.numEntries == 0) {
            return;
        }
        if (LAZY_DECODE) {
            this.keys = new int[this.numEntries];
            this.values = new long[this.numEntries];
            for (int i = 0; i < this.numEntries; ++i) {
                this.keys[i] = in.readInt();
                this.values[i] = in.readLong();
            }
        } else {
            for (int i = 0; i < this.numEntries; ++i) {
                this.put(in.readInt(), in.readLong());
            }
        }
    }

    public void decode() {
        if (this.keys == null) {
            return;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            this.put(this.keys[i], this.values[i]);
        }
        this.keys = null;
    }

    public boolean hasBeenDecoded() {
        return this.keys == null;
    }

    public void write(DataOutput out) throws IOException {
        if (this.keys == null) {
            out.writeInt(this.size());
            if (this.size() == 0) {
                return;
            }
            for (Int2LongMap.Entry e : this.int2LongEntrySet()) {
                out.writeInt(e.getIntKey());
                out.writeLong(e.getLongValue());
            }
        } else {
            out.writeInt(this.numEntries);
            for (int i = 0; i < this.numEntries; ++i) {
                out.writeInt(this.keys[i]);
                out.writeLong(this.values[i]);
            }
        }
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        this.write(dataOut);
        return bytesOut.toByteArray();
    }

    public static Int2LongOpenHashMapWritable create(DataInput in) throws IOException {
        Int2LongOpenHashMapWritable m = new Int2LongOpenHashMapWritable();
        m.readFields(in);
        return m;
    }

    public static Int2LongOpenHashMapWritable create(byte[] bytes) throws IOException {
        return Int2LongOpenHashMapWritable.create(new DataInputStream(new ByteArrayInputStream(bytes)));
    }

    public void plus(Int2LongOpenHashMapWritable m) {
        for (Int2LongMap.Entry e : m.int2LongEntrySet()) {
            int key = e.getIntKey();
            long value = e.getLongValue();
            if (this.containsKey(key)) {
                this.put(key, this.get(key) + value);
                continue;
            }
            this.put(key, value);
        }
    }

    public long dot(Int2LongOpenHashMapWritable m) {
        int s = 0;
        for (Int2LongMap.Entry e : m.int2LongEntrySet()) {
            int key = e.getIntKey();
            if (!this.containsKey(key)) continue;
            s = (int)((long)s + this.get(key) * e.getLongValue());
        }
        return s;
    }

    public void increment(int key) {
        this.increment(key, 1L);
    }

    public void increment(int key, long n) {
        if (this.containsKey(key)) {
            this.put(key, this.get(key) + n);
        } else {
            this.put(key, n);
        }
    }

    public static void setLazyDecodeFlag(boolean b) {
        LAZY_DECODE = b;
    }

    public static boolean getLazyDecodeFlag() {
        return LAZY_DECODE;
    }

    public int[] getKeys() {
        return this.keys;
    }

    public long[] getValues() {
        return this.values;
    }

    public void lazyplus(Int2LongOpenHashMapWritable m) {
        int[] k = m.getKeys();
        long[] v = m.getValues();
        for (int i = 0; i < k.length; ++i) {
            if (this.containsKey(k[i])) {
                this.put(k[i], this.get(k[i]) + v[i]);
                continue;
            }
            this.put(k[i], v[i]);
        }
    }

    public Int2LongMap.Entry[] getEntriesSortedByValue() {
        if (this.size() == 0) {
            return null;
        }
        Object[] entries = new Int2LongMap.Entry[this.size()];
        entries = (Int2LongMap.Entry[])this.int2LongEntrySet().toArray(entries);
        Arrays.sort(entries, new Comparator<Int2LongMap.Entry>(){

            @Override
            public int compare(Int2LongMap.Entry e1, Int2LongMap.Entry e2) {
                if (e1.getLongValue() > e2.getLongValue()) {
                    return -1;
                }
                if (e1.getLongValue() < e2.getLongValue()) {
                    return 1;
                }
                if (e1.getIntKey() == e2.getIntKey()) {
                    return 0;
                }
                return e1.getIntKey() > e2.getIntKey() ? 1 : -1;
            }
        });
        return entries;
    }

    public Int2LongMap.Entry[] getEntriesSortedByValue(int k) {
        Int2LongMap.Entry[] entries = this.getEntriesSortedByValue();
        if (entries == null) {
            return null;
        }
        if (entries.length < k) {
            return entries;
        }
        return Arrays.copyOfRange(entries, 0, k);
    }
}

