/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.map;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class String2IntOpenHashMapWritable
extends Object2IntOpenHashMap<String>
implements Writable {
    private static final long serialVersionUID = 276091731841463L;

    public void readFields(DataInput in) throws IOException {
        this.clear();
        int numEntries = in.readInt();
        if (numEntries == 0) {
            return;
        }
        for (int i = 0; i < numEntries; ++i) {
            String k = in.readUTF();
            int v = in.readInt();
            super.put((Object)k, v);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.size() == 0) {
            return;
        }
        for (Object2IntMap.Entry e : this.object2IntEntrySet()) {
            out.writeUTF((String)e.getKey());
            out.writeInt((Integer)e.getValue());
        }
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        this.write(dataOut);
        return bytesOut.toByteArray();
    }

    public static String2IntOpenHashMapWritable create(DataInput in) throws IOException {
        String2IntOpenHashMapWritable m = new String2IntOpenHashMapWritable();
        m.readFields(in);
        return m;
    }

    public static String2IntOpenHashMapWritable create(byte[] bytes) throws IOException {
        return String2IntOpenHashMapWritable.create(new DataInputStream(new ByteArrayInputStream(bytes)));
    }

    public void plus(String2IntOpenHashMapWritable m) {
        for (Object2IntMap.Entry e : m.object2IntEntrySet()) {
            String key = (String)e.getKey();
            if (this.containsKey(key)) {
                this.put(key, this.get(key) + (Integer)e.getValue());
                continue;
            }
            this.put(key, (Integer)e.getValue());
        }
    }

    public int dot(String2IntOpenHashMapWritable m) {
        int s = 0;
        for (Object2IntMap.Entry e : m.object2IntEntrySet()) {
            String key = (String)e.getKey();
            if (!this.containsKey(key)) continue;
            s += this.get(key) * (Integer)e.getValue();
        }
        return s;
    }

    public void increment(String key) {
        this.increment(key, 1);
    }

    public void increment(String key, int n) {
        if (this.containsKey(key)) {
            this.put(key, this.get(key) + n);
        } else {
            this.put(key, n);
        }
    }
}

