/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.array;

import java.util.Random;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import tl.lin.data.array.ArrayListOfDoubles;

public class ArrayListOfDoublesTest {
    double neg_one = -1.0;
    double zero = 0.0;
    double one = 1.0;
    double two = 2.0;
    double three = 3.0;
    double four = 4.0;
    double five = 5.0;
    double six = 6.0;
    double seven = 7.0;
    double nine = 9.0;

    @org.junit.Test
    public void testRemoveWithinBounds() {
        ArrayListOfDoubles a = new ArrayListOfDoubles();
        a.add(this.one).add(this.three).add(this.five).add(this.seven);
        Assert.assertTrue((this.one == a.remove(0) ? 1 : 0) != 0);
        Assert.assertTrue((this.three == a.get(0) ? 1 : 0) != 0);
        Assert.assertTrue((this.five == a.get(1) ? 1 : 0) != 0);
        Assert.assertTrue((this.five == a.remove(1) ? 1 : 0) != 0);
        Assert.assertTrue((this.seven == a.get(2) ? 1 : 0) != 0);
    }

    @org.junit.Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testRemoveOutOfBounds() {
        ArrayListOfDoubles a = new ArrayListOfDoubles();
        a.add(this.one).add(this.three).add(this.five).add(this.seven);
        a.remove(4);
    }

    @org.junit.Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testRemoveOutOfBounds2() {
        ArrayListOfDoubles a = new ArrayListOfDoubles();
        a.add(this.neg_one);
        a.remove(-1);
    }

    @org.junit.Test
    public void testBasic1() {
        int i;
        int size = 100000;
        Random r = new Random();
        double[] doubles = new double[size];
        ArrayListOfDoubles list = new ArrayListOfDoubles();
        for (i = 0; i < size; ++i) {
            double k = r.nextDouble();
            list.add(k);
            doubles[i] = k;
        }
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((double)doubles[i], (double)list.get(i), (double)1.0E-4);
        }
    }

    @org.junit.Test
    public void testArrayConstructor() {
        double[] arr = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        Assert.assertEquals((long)5L, (long)arr.length);
        ArrayListOfDoubles list = new ArrayListOfDoubles(arr);
        list.remove(2);
        Assert.assertEquals((double)1.0, (double)arr[0], (double)1.0E-5);
        Assert.assertEquals((double)2.0, (double)arr[1], (double)1.0E-5);
        Assert.assertEquals((double)3.0, (double)arr[2], (double)1.0E-5);
        Assert.assertEquals((double)4.0, (double)arr[3], (double)1.0E-5);
        Assert.assertEquals((double)5.0, (double)arr[4], (double)1.0E-5);
    }

    @org.junit.Test
    public void testRemove() {
        ArrayListOfDoubles list = new ArrayListOfDoubles();
        for (int i = 0; i < 10; ++i) {
            list.add((double)i);
        }
        list.remove(list.indexOf(5.0));
        Assert.assertEquals((long)9L, (long)list.size());
        Assert.assertEquals((double)0.0, (double)list.get(0), (double)1.0E-5);
        Assert.assertEquals((double)1.0, (double)list.get(1), (double)1.0E-5);
        Assert.assertEquals((double)2.0, (double)list.get(2), (double)1.0E-5);
        Assert.assertEquals((double)3.0, (double)list.get(3), (double)1.0E-5);
        Assert.assertEquals((double)4.0, (double)list.get(4), (double)1.0E-5);
        Assert.assertEquals((double)6.0, (double)list.get(5), (double)1.0E-5);
        Assert.assertEquals((double)7.0, (double)list.get(6), (double)1.0E-5);
        Assert.assertEquals((double)8.0, (double)list.get(7), (double)1.0E-5);
        Assert.assertEquals((double)9.0, (double)list.get(8), (double)1.0E-5);
        list.remove(list.indexOf(9.0));
        Assert.assertEquals((long)8L, (long)list.size);
        Assert.assertEquals((double)0.0, (double)list.get(0), (double)1.0E-5);
        Assert.assertEquals((double)1.0, (double)list.get(1), (double)1.0E-5);
        Assert.assertEquals((double)2.0, (double)list.get(2), (double)1.0E-5);
        Assert.assertEquals((double)3.0, (double)list.get(3), (double)1.0E-5);
        Assert.assertEquals((double)4.0, (double)list.get(4), (double)1.0E-5);
        Assert.assertEquals((double)6.0, (double)list.get(5), (double)1.0E-5);
        Assert.assertEquals((double)7.0, (double)list.get(6), (double)1.0E-5);
        Assert.assertEquals((double)8.0, (double)list.get(7), (double)1.0E-5);
    }

    @org.junit.Test
    public void testUpdate() {
        int i;
        int size = 100000;
        Random r = new Random();
        double[] doubles = new double[size];
        ArrayListOfDoubles list = new ArrayListOfDoubles();
        for (i = 0; i < size; ++i) {
            double k = r.nextDouble();
            list.add(k);
            doubles[i] = k;
        }
        Assert.assertEquals((long)size, (long)list.size());
        for (i = 0; i < size; ++i) {
            list.set(i, doubles[i] + 1.0);
        }
        Assert.assertEquals((long)size, (long)list.size());
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((double)(doubles[i] + 1.0), (double)list.get(i), (double)1.0E-4);
        }
    }

    @org.junit.Test
    public void testTrim1() {
        int i;
        int size = 89;
        Random r = new Random();
        double[] doubles = new double[size];
        ArrayListOfDoubles list = new ArrayListOfDoubles();
        for (i = 0; i < size; ++i) {
            double k = r.nextDouble();
            list.add(k);
            doubles[i] = k;
        }
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((double)doubles[i], (double)list.get(i), (double)1.0E-4);
        }
        double[] rawArray = list.getArray();
        int lenBefore = rawArray.length;
        list.trimToSize();
        double[] rawArrayAfter = list.getArray();
        int lenAfter = rawArrayAfter.length;
        Assert.assertEquals((long)89L, (long)lenAfter);
        Assert.assertTrue((lenBefore > lenAfter ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testClone() {
        int i;
        int size = 100000;
        Random r = new Random();
        double[] doubles = new double[size];
        ArrayListOfDoubles list1 = new ArrayListOfDoubles();
        for (int i2 = 0; i2 < size; ++i2) {
            double k = r.nextDouble();
            list1.add(k);
            doubles[i2] = k;
        }
        ArrayListOfDoubles list2 = list1.clone();
        Assert.assertEquals((long)size, (long)list1.size());
        Assert.assertEquals((long)size, (long)list2.size());
        for (i = 0; i < size; ++i) {
            list2.set(i, doubles[i] + 1.0);
        }
        Assert.assertEquals((long)size, (long)list1.size());
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((double)doubles[i], (double)list1.get(i), (double)1.0E-4);
        }
        Assert.assertEquals((long)size, (long)list1.size());
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((double)(doubles[i] + 1.0), (double)list2.get(i), (double)1.0E-4);
        }
    }

    @org.junit.Test
    public void testToString() {
        double v;
        int i;
        int size = 10;
        Random r = new Random();
        ArrayListOfDoubles list = new ArrayListOfDoubles();
        for (int i2 = 0; i2 < size; ++i2) {
            list.add(r.nextDouble());
        }
        String out = list.toString();
        for (i = 0; i < size; ++i) {
            v = list.get(i);
            Assert.assertTrue((out.indexOf(new Double(v).toString()) != -1 ? 1 : 0) != 0);
        }
        for (i = 0; i < size; ++i) {
            list.add((double)r.nextFloat());
        }
        out = list.toString();
        for (i = size; i < size + size; ++i) {
            v = list.get(i);
            Assert.assertTrue((out.indexOf(new Double(v).toString()) == -1 ? 1 : 0) != 0);
        }
        Assert.assertTrue((out.indexOf(size + " more") != -1 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testIterable() {
        int i;
        int size = 1000;
        Random r = new Random();
        double[] doubles = new double[size];
        ArrayListOfDoubles list = new ArrayListOfDoubles();
        for (i = 0; i < size; ++i) {
            double k = r.nextDouble();
            list.add(k);
            doubles[i] = k;
        }
        i = 0;
        for (Double v : list) {
            Assert.assertEquals((double)doubles[i++], (double)v, (double)1.0E-4);
        }
    }

    @org.junit.Test
    public void testSetSize() {
        ArrayListOfDoubles list = new ArrayListOfDoubles();
        list.add(5.0);
        Assert.assertEquals((long)1L, (long)list.size);
        Assert.assertEquals((double)5.0, (double)list.get(0), (double)1.0E-5);
        list.setSize(5);
        Assert.assertEquals((long)5L, (long)list.size);
        Assert.assertEquals((double)0.0, (double)list.get(1), (double)1.0E-5);
        Assert.assertEquals((double)0.0, (double)list.get(2), (double)1.0E-5);
        Assert.assertEquals((double)0.0, (double)list.get(3), (double)1.0E-5);
        Assert.assertEquals((double)0.0, (double)list.get(4), (double)1.0E-5);
        list.add(12.0);
        Assert.assertEquals((long)6L, (long)list.size);
        Assert.assertEquals((double)12.0, (double)list.get(5), (double)1.0E-5);
    }

    @org.junit.Test
    public void testSort() {
        ArrayListOfDoubles a = new ArrayListOfDoubles();
        Assert.assertEquals((long)0L, (long)a.size());
        a.add((double)5.2f).add(6.0).add((double)5.9f).add((double)4.1f);
        Assert.assertEquals((long)4L, (long)a.size());
        a.sort();
        Assert.assertEquals((long)4L, (long)a.size());
        Assert.assertTrue((Math.abs(a.get(0) - 4.1) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(a.get(1) - 5.2) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(a.get(2) - 5.9) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(a.get(3) - 6.0) < 1.0E-4 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testIntersection1() {
        ArrayListOfDoubles a = new ArrayListOfDoubles();
        a.add(5.0).add(3.0).add(1.0);
        a.sort();
        ArrayListOfDoubles b = new ArrayListOfDoubles();
        b.add(0.0).add(1.0).add(2.0).add(3.0);
        ArrayListOfDoubles c = a.intersection(b);
        Assert.assertTrue((Math.abs(1.0 - c.get(0)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(3.0 - c.get(1)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue(((double)Math.abs(2 - c.size()) < 1.0E-4 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testIntersection2() {
        ArrayListOfDoubles a = new ArrayListOfDoubles();
        a.add(5.0);
        ArrayListOfDoubles b = new ArrayListOfDoubles();
        b.add(0.0).add(1.0).add(2.0).add(3.0);
        ArrayListOfDoubles c = a.intersection(b);
        Assert.assertTrue((c.size() == 0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testIntersection3() {
        ArrayListOfDoubles a = new ArrayListOfDoubles();
        a.add(3.0).add(5.0).add(7.0).add(8.0).add(9.0);
        ArrayListOfDoubles b = new ArrayListOfDoubles();
        b.add(0.0).add(1.0).add(2.0).add(3.0);
        ArrayListOfDoubles c = a.intersection(b);
        Assert.assertTrue((Math.abs(3.0 - c.get(0)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)c.size());
    }

    @org.junit.Test
    public void testMerge1() {
        ArrayListOfDoubles a = new ArrayListOfDoubles();
        a.add(3.0);
        a.add(7.0);
        a.add(10.0);
        ArrayListOfDoubles b = new ArrayListOfDoubles();
        b.add(0.0);
        b.add(4.0);
        b.add(9.0);
        ArrayListOfDoubles c = a.merge(b);
        Assert.assertEquals((long)6L, (long)c.size());
        Assert.assertTrue((Math.abs(0.0 - c.get(0)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(3.0 - c.get(1)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(4.0 - c.get(2)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(7.0 - c.get(3)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(9.0 - c.get(4)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(10.0 - c.get(5)) < 1.0E-4 ? 1 : 0) != 0);
        ArrayListOfDoubles c2 = b.merge(a);
        Assert.assertEquals((Object)c, (Object)c2);
    }

    @org.junit.Test
    public void testMerge2() {
        ArrayListOfDoubles a = new ArrayListOfDoubles();
        a.add(3.0);
        a.add(7.0);
        a.add(10.0);
        ArrayListOfDoubles b = new ArrayListOfDoubles();
        b.add(11.0);
        b.add(19.0);
        b.add(21.0);
        ArrayListOfDoubles c = a.merge(b);
        Assert.assertEquals((long)6L, (long)c.size());
        Assert.assertTrue((Math.abs(3.0 - c.get(0)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(7.0 - c.get(1)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(10.0 - c.get(2)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(11.0 - c.get(3)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(19.0 - c.get(4)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(21.0 - c.get(5)) < 1.0E-4 ? 1 : 0) != 0);
        ArrayListOfDoubles c2 = b.merge(a);
        Assert.assertEquals((Object)c, (Object)c2);
    }

    @org.junit.Test
    public void testMerge3() {
        ArrayListOfDoubles a = new ArrayListOfDoubles();
        a.add(3.0);
        a.add(7.0);
        a.add(10.0);
        ArrayListOfDoubles b = new ArrayListOfDoubles();
        ArrayListOfDoubles c = a.merge(b);
        Assert.assertEquals((Object)c, (Object)a);
        ArrayListOfDoubles c2 = b.merge(a);
        Assert.assertEquals((Object)c, (Object)c2);
    }

    @org.junit.Test
    public void testSubList() {
        ArrayListOfDoubles a = new ArrayListOfDoubles(new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0});
        ArrayListOfDoubles c = a.subList(1, 5);
        Assert.assertEquals((long)5L, (long)c.size());
        Assert.assertTrue((Math.abs(2.0 - c.get(0)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(3.0 - c.get(1)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(4.0 - c.get(2)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(5.0 - c.get(3)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(6.0 - c.get(4)) < 1.0E-4 ? 1 : 0) != 0);
        a.clear();
        Assert.assertEquals((long)5L, (long)c.size());
        Assert.assertTrue((Math.abs(2.0 - c.get(0)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(3.0 - c.get(1)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(4.0 - c.get(2)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(5.0 - c.get(3)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(6.0 - c.get(4)) < 1.0E-4 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testAddUnique() {
        ArrayListOfDoubles a = new ArrayListOfDoubles(new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0});
        a.addUnique(new int[]{8, 0, 2, 5, -1, 11, 9});
        Assert.assertEquals((long)12L, (long)a.size());
        Assert.assertTrue((Math.abs(0.0 - a.get(8)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(-1.0 - a.get(9)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(11.0 - a.get(10)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(9.0 - a.get(11)) < 1.0E-4 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testShift() {
        int i;
        int size = 100;
        int shift = 10;
        ArrayListOfDoubles list = new ArrayListOfDoubles();
        for (i = 0; i < size; ++i) {
            list.add((double)i);
        }
        list.shiftLastNToTop(shift);
        for (i = 0; i < list.size(); ++i) {
            Assert.assertTrue((Math.abs((double)(size - shift + i) - list.get(i)) < 0.001 ? 1 : 0) != 0);
        }
        list.add((double)size);
        Assert.assertEquals((long)(shift + 1), (long)list.size());
        Assert.assertTrue((Math.abs((double)size - list.get(shift)) < 0.001 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(ArrayListOfDoublesTest.class);
    }
}

