/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.array;

import java.io.IOException;
import java.util.List;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import tl.lin.data.array.ArrayListOfDoublesWritable;
import tl.lin.data.pair.PairOfWritables;
import tl.lin.data.util.SequenceFileUtils;

public class ArrayListOfDoublesWritableTest {
    double neg_one = -1.0;
    double zero = 0.0;
    double one = 1.0;
    double two = 2.0;
    double three = 3.0;
    double four = 4.0;
    double five = 5.0;
    double six = 6.0;
    double seven = 7.0;
    double nine = 9.0;

    @org.junit.Test
    public void testReadWrite() throws IOException {
        ArrayListOfDoublesWritable arr = new ArrayListOfDoublesWritable();
        arr.add(0, 1.0).add(1, 3.0).add(2, 5.0).add(3, 7.0);
        Configuration conf = new Configuration();
        Path tmp = new Path("tmp");
        FileSystem.get((Configuration)conf).delete(tmp, true);
        try {
            SequenceFile.Writer w = SequenceFile.createWriter((FileSystem)FileSystem.get((Configuration)conf), (Configuration)conf, (Path)tmp, IntWritable.class, ArrayListOfDoublesWritable.class);
            w.append((Writable)new IntWritable(1), (Writable)arr);
            w.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
        List listOfKeysPairs = SequenceFileUtils.readFile((Path)tmp);
        FileSystem.get((Configuration)conf).delete(tmp, true);
        Assert.assertTrue((listOfKeysPairs.size() == 1 ? 1 : 0) != 0);
        ArrayListOfDoublesWritable arrRead = (ArrayListOfDoublesWritable)((PairOfWritables)listOfKeysPairs.get(0)).getRightElement();
        Assert.assertEquals((long)4L, (long)arrRead.size());
        Assert.assertEquals((double)1.0, (double)arrRead.get(0), (double)1.0E-5);
        Assert.assertEquals((double)3.0, (double)arrRead.get(1), (double)1.0E-5);
        Assert.assertEquals((double)5.0, (double)arrRead.get(2), (double)1.0E-5);
        Assert.assertEquals((double)7.0, (double)arrRead.get(3), (double)1.0E-5);
        arrRead.remove(0);
        arrRead.remove(0);
        arrRead.remove(1);
        Assert.assertEquals((long)1L, (long)arrRead.size());
        Assert.assertEquals((double)5.0, (double)arrRead.get(0), (double)1.0E-5);
    }

    @org.junit.Test
    public void testCopyConstructor() {
        ArrayListOfDoublesWritable a = new ArrayListOfDoublesWritable();
        a.add(1.0).add(3.0).add(5.0);
        ArrayListOfDoublesWritable b = new ArrayListOfDoublesWritable(a);
        a.remove(0);
        Assert.assertEquals((double)1.0, (double)b.get(0), (double)1.0E-5);
        Assert.assertEquals((double)3.0, (double)b.get(1), (double)1.0E-5);
        Assert.assertEquals((double)5.0, (double)b.get(2), (double)1.0E-5);
    }

    @org.junit.Test
    public void testCompare() {
        ArrayListOfDoublesWritable a = new ArrayListOfDoublesWritable();
        a.add(this.one).add(this.three).add(this.five);
        ArrayListOfDoublesWritable b = new ArrayListOfDoublesWritable();
        b.add(this.one).add(this.three).add(this.five).add(this.seven);
        Assert.assertTrue((b.compareTo(a) > 0 ? 1 : 0) != 0);
        b.remove(3);
        Assert.assertTrue((b.compareTo(a) == 0 ? 1 : 0) != 0);
        b.remove(2);
        Assert.assertTrue((b.compareTo(a) < 0 ? 1 : 0) != 0);
        ArrayListOfDoublesWritable c = new ArrayListOfDoublesWritable();
        Assert.assertTrue((b.compareTo(c) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((c.compareTo(a) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((a.compareTo(c) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((c.compareTo(b) < 0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testCompare2() {
        ArrayListOfDoublesWritable a = new ArrayListOfDoublesWritable();
        a.add(this.one).add(this.three).add(this.six);
        ArrayListOfDoublesWritable b = new ArrayListOfDoublesWritable();
        b.add(this.one).add(this.three).add(this.four);
        Assert.assertTrue((a.compareTo(b) > 0 ? 1 : 0) != 0);
        ArrayListOfDoublesWritable c = new ArrayListOfDoublesWritable();
        c.add(this.one).add(this.three).add(this.four).add(this.nine);
        Assert.assertTrue((c.compareTo(a) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((b.compareTo(c) < 0 ? 1 : 0) != 0);
        ArrayListOfDoublesWritable d = new ArrayListOfDoublesWritable();
        d.add(this.two).add(this.four);
        ArrayListOfDoublesWritable e = new ArrayListOfDoublesWritable();
        e.add(this.zero).add(this.two);
        Assert.assertTrue((d.compareTo(a) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((d.compareTo(b) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((d.compareTo(c) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compareTo(a) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compareTo(b) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compareTo(c) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compareTo(d) < 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(ArrayListOfDoublesWritableTest.class);
    }
}

