/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.array;

import java.io.IOException;
import java.util.List;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import tl.lin.data.array.ArrayListOfShortsWritable;
import tl.lin.data.pair.PairOfWritables;
import tl.lin.data.util.SequenceFileUtils;

public class ArrayListOfShortsWritableTest {
    short neg_one = (short)-1;
    short zero = 0;
    short one = 1;
    short two = (short)2;
    short three = (short)3;
    short four = (short)4;
    short five = (short)5;
    short six = (short)6;
    short seven = (short)7;
    short nine = (short)9;

    @org.junit.Test
    public void testToString() {
        Assert.assertEquals((Object)"[1, 2, 3, 4, 5, 6, 7, 8, 9, 10]", (Object)new ArrayListOfShortsWritable(1, 11).toString());
        Assert.assertEquals((Object)"[1, 2, 3, 4, 5 ... (5 more) ]", (Object)new ArrayListOfShortsWritable(1, 11).toString(5));
        Assert.assertEquals((Object)"[1, 2, 3, 4, 5]", (Object)new ArrayListOfShortsWritable(1, 6).toString());
        Assert.assertEquals((Object)"[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11]", (Object)new ArrayListOfShortsWritable(1, 12).toString());
        Assert.assertEquals((Object)"[]", (Object)new ArrayListOfShortsWritable().toString());
    }

    @org.junit.Test
    public void testReadWrite() throws IOException {
        ArrayListOfShortsWritable arr = new ArrayListOfShortsWritable();
        arr.add(0, (short)1).add(1, (short)3).add(2, (short)5).add(3, (short)7);
        Configuration conf = new Configuration();
        Path tmp = new Path("tmp");
        FileSystem.get((Configuration)conf).delete(tmp, true);
        try {
            SequenceFile.Writer w = SequenceFile.createWriter((FileSystem)FileSystem.get((Configuration)conf), (Configuration)conf, (Path)tmp, IntWritable.class, ArrayListOfShortsWritable.class);
            w.append((Writable)new IntWritable(1), (Writable)arr);
            w.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
        List listOfKeysPairs = SequenceFileUtils.readFile((Path)tmp);
        FileSystem.get((Configuration)conf).delete(tmp, true);
        Assert.assertTrue((listOfKeysPairs.size() == 1 ? 1 : 0) != 0);
        ArrayListOfShortsWritable arrRead = (ArrayListOfShortsWritable)((PairOfWritables)listOfKeysPairs.get(0)).getRightElement();
        Assert.assertEquals((long)4L, (long)arrRead.size());
        Assert.assertEquals((long)1L, (long)arrRead.get(0));
        Assert.assertEquals((long)3L, (long)arrRead.get(1));
        Assert.assertEquals((long)5L, (long)arrRead.get(2));
        Assert.assertEquals((long)7L, (long)arrRead.get(3));
        arrRead.remove(0);
        arrRead.remove(0);
        arrRead.remove(1);
        Assert.assertEquals((long)1L, (long)arrRead.size());
        Assert.assertEquals((long)5L, (long)arrRead.get(0));
    }

    @org.junit.Test
    public void testCopyConstructor() {
        ArrayListOfShortsWritable a = new ArrayListOfShortsWritable();
        a.add((short)1).add((short)3).add((short)5);
        ArrayListOfShortsWritable b = new ArrayListOfShortsWritable(a);
        a.remove(0);
        Assert.assertEquals((long)1L, (long)b.get(0));
        Assert.assertEquals((long)3L, (long)b.get(1));
        Assert.assertEquals((long)5L, (long)b.get(2));
    }

    @org.junit.Test
    public void testCompare() {
        ArrayListOfShortsWritable a = new ArrayListOfShortsWritable();
        a.add(this.one).add(this.three).add(this.five);
        ArrayListOfShortsWritable b = new ArrayListOfShortsWritable();
        b.add(this.one).add(this.three).add(this.five).add(this.seven);
        Assert.assertTrue((b.compareTo(a) > 0 ? 1 : 0) != 0);
        b.remove(3);
        Assert.assertTrue((b.compareTo(a) == 0 ? 1 : 0) != 0);
        b.remove(2);
        Assert.assertTrue((b.compareTo(a) < 0 ? 1 : 0) != 0);
        ArrayListOfShortsWritable c = new ArrayListOfShortsWritable();
        Assert.assertTrue((b.compareTo(c) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((c.compareTo(a) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((a.compareTo(c) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((c.compareTo(b) < 0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testCompare2() {
        ArrayListOfShortsWritable a = new ArrayListOfShortsWritable();
        a.add(this.one).add(this.three).add(this.six);
        ArrayListOfShortsWritable b = new ArrayListOfShortsWritable();
        b.add(this.one).add(this.three).add(this.four);
        Assert.assertTrue((a.compareTo(b) > 0 ? 1 : 0) != 0);
        ArrayListOfShortsWritable c = new ArrayListOfShortsWritable();
        c.add(this.one).add(this.three).add(this.four).add(this.nine);
        Assert.assertTrue((c.compareTo(a) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((b.compareTo(c) < 0 ? 1 : 0) != 0);
        ArrayListOfShortsWritable d = new ArrayListOfShortsWritable();
        d.add(this.two).add(this.four);
        ArrayListOfShortsWritable e = new ArrayListOfShortsWritable();
        e.add(this.zero).add(this.two);
        Assert.assertTrue((d.compareTo(a) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((d.compareTo(b) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((d.compareTo(c) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compareTo(a) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compareTo(b) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compareTo(c) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compareTo(d) < 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(ArrayListOfShortsWritableTest.class);
    }
}

