/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.fd;

import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.junit.Assert;
import tl.lin.data.SortableEntries;
import tl.lin.data.fd.Int2LongFrequencyDistribution;
import tl.lin.data.pair.PairOfIntLong;

public class Int2LongFrequencyDistributionTestBase {
    protected void test1Common(Int2LongFrequencyDistribution fd) {
        Assert.assertEquals((long)0L, (long)fd.get(1));
        fd.increment(1);
        fd.increment(2);
        fd.increment(3);
        fd.increment(2);
        fd.increment(3);
        fd.increment(3);
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)6L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)1L, (long)fd.get(1));
        Assert.assertEquals((long)2L, (long)fd.get(2));
        Assert.assertEquals((long)3L, (long)fd.get(3));
        Assert.assertEquals((double)0.16666666666666666, (double)fd.computeRelativeFrequency(1), (double)1.0E-5);
        Assert.assertEquals((double)0.3333333333333333, (double)fd.computeRelativeFrequency(2), (double)1.0E-5);
        Assert.assertEquals((double)0.5, (double)fd.computeRelativeFrequency(3), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.16666666666666666), (double)fd.computeLogRelativeFrequency(1), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.3333333333333333), (double)fd.computeLogRelativeFrequency(2), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.5), (double)fd.computeLogRelativeFrequency(3), (double)1.0E-5);
        fd.decrement(3);
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)5L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)1L, (long)fd.get(1));
        Assert.assertEquals((long)2L, (long)fd.get(2));
        Assert.assertEquals((long)2L, (long)fd.get(3));
        Assert.assertEquals((double)0.2, (double)fd.computeRelativeFrequency(1), (double)1.0E-5);
        Assert.assertEquals((double)0.4, (double)fd.computeRelativeFrequency(2), (double)1.0E-5);
        Assert.assertEquals((double)0.4, (double)fd.computeRelativeFrequency(3), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.2), (double)fd.computeLogRelativeFrequency(1), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.4), (double)fd.computeLogRelativeFrequency(2), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.4), (double)fd.computeLogRelativeFrequency(3), (double)1.0E-5);
        fd.decrement(1);
        Assert.assertEquals((long)2L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)4L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)0L, (long)fd.get(1));
        Assert.assertEquals((long)2L, (long)fd.get(2));
        Assert.assertEquals((long)2L, (long)fd.get(3));
        Assert.assertEquals((double)0.5, (double)fd.computeRelativeFrequency(2), (double)1.0E-5);
        Assert.assertEquals((double)0.5, (double)fd.computeRelativeFrequency(3), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.5), (double)fd.computeLogRelativeFrequency(2), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.5), (double)fd.computeLogRelativeFrequency(3), (double)1.0E-5);
    }

    protected void test2Common(Int2LongFrequencyDistribution fd) {
        fd.increment(1);
        fd.increment(1);
        fd.increment(2);
        fd.increment(3);
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)4L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)2L, (long)fd.get(1));
        Assert.assertEquals((long)1L, (long)fd.get(2));
        Assert.assertEquals((long)1L, (long)fd.get(3));
        fd.set(4, 5L);
        Assert.assertEquals((long)4L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)9L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)2L, (long)fd.get(1));
        Assert.assertEquals((long)1L, (long)fd.get(2));
        Assert.assertEquals((long)1L, (long)fd.get(3));
        Assert.assertEquals((long)5L, (long)fd.get(4));
        fd.set(1, 5L);
        Assert.assertEquals((long)4L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)12L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)5L, (long)fd.get(1));
        Assert.assertEquals((long)1L, (long)fd.get(2));
        Assert.assertEquals((long)1L, (long)fd.get(3));
        Assert.assertEquals((long)5L, (long)fd.get(4));
        fd.increment(3);
        fd.increment(3);
        fd.increment(3);
        Assert.assertEquals((long)4L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)15L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)5L, (long)fd.get(1));
        Assert.assertEquals((long)1L, (long)fd.get(2));
        Assert.assertEquals((long)4L, (long)fd.get(3));
        Assert.assertEquals((long)5L, (long)fd.get(4));
        fd.set(3, 1L);
        Assert.assertEquals((long)4L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)12L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)5L, (long)fd.get(1));
        Assert.assertEquals((long)1L, (long)fd.get(2));
        Assert.assertEquals((long)1L, (long)fd.get(3));
        Assert.assertEquals((long)5L, (long)fd.get(4));
    }

    protected void test3Common(Int2LongFrequencyDistribution fd) {
        fd.increment(1);
        fd.increment(1);
        fd.increment(2);
        fd.increment(3);
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)4L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)2L, (long)fd.get(1));
        Assert.assertEquals((long)1L, (long)fd.get(2));
        Assert.assertEquals((long)1L, (long)fd.get(3));
        fd.clear();
        Assert.assertEquals((long)0L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)0L, (long)fd.getSumOfCounts());
    }

    protected void testFailedDecrement1Common(Int2LongFrequencyDistribution fd) {
        fd.increment(1);
        Assert.assertEquals((long)1L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)1L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)1L, (long)fd.get(1));
        fd.decrement(1);
        Assert.assertEquals((long)0L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)0L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)0L, (long)fd.get(1));
        fd.decrement(1);
    }

    protected void testFailedDecrement2Common(Int2LongFrequencyDistribution fd) {
        fd.increment(1, 1000L);
        Assert.assertEquals((long)1L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)1000L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)1000L, (long)fd.get(1));
        fd.decrement(1, 997L);
        Assert.assertEquals((long)1L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)3L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)3L, (long)fd.get(1));
        fd.decrement(1, 3L);
        Assert.assertEquals((long)0L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)0L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)0L, (long)fd.get(1));
        fd.increment(1, 3L);
        fd.decrement(1, 4L);
    }

    protected void testMultiIncrementDecrementCommon(Int2LongFrequencyDistribution fd) {
        fd.increment(1, 2L);
        fd.increment(2, 3L);
        fd.increment(3, 4L);
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)9L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)2L, (long)fd.get(1));
        Assert.assertEquals((long)3L, (long)fd.get(2));
        Assert.assertEquals((long)4L, (long)fd.get(3));
        fd.decrement(2, 2L);
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)7L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)2L, (long)fd.get(1));
        Assert.assertEquals((long)1L, (long)fd.get(2));
        Assert.assertEquals((long)4L, (long)fd.get(3));
    }

    protected void testGetFrequencySortedEventsCommon(Int2LongFrequencyDistribution fd) {
        fd.set(1, 5L);
        fd.set(4, 2L);
        fd.set(2, 5L);
        fd.set(5, 2L);
        fd.set(6, 1L);
        fd.set(3, 5L);
        Assert.assertEquals((long)6L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)20L, (long)fd.getSumOfCounts());
        List list = fd.getEntries(SortableEntries.Order.ByRightElementDescending);
        Assert.assertEquals((long)6L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((PairOfIntLong)list.get(0)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfIntLong)list.get(0)).getRightElement());
        Assert.assertEquals((long)2L, (long)((PairOfIntLong)list.get(1)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfIntLong)list.get(1)).getRightElement());
        Assert.assertEquals((long)3L, (long)((PairOfIntLong)list.get(2)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfIntLong)list.get(2)).getRightElement());
        Assert.assertEquals((long)4L, (long)((PairOfIntLong)list.get(3)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfIntLong)list.get(3)).getRightElement());
        Assert.assertEquals((long)5L, (long)((PairOfIntLong)list.get(4)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfIntLong)list.get(4)).getRightElement());
        Assert.assertEquals((long)6L, (long)((PairOfIntLong)list.get(5)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfIntLong)list.get(5)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByRightElementAscending);
        Assert.assertEquals((long)6L, (long)list.size());
        Assert.assertEquals((long)6L, (long)((PairOfIntLong)list.get(0)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfIntLong)list.get(0)).getRightElement());
        Assert.assertEquals((long)4L, (long)((PairOfIntLong)list.get(1)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfIntLong)list.get(1)).getRightElement());
        Assert.assertEquals((long)5L, (long)((PairOfIntLong)list.get(2)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfIntLong)list.get(2)).getRightElement());
        Assert.assertEquals((long)1L, (long)((PairOfIntLong)list.get(3)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfIntLong)list.get(3)).getRightElement());
        Assert.assertEquals((long)2L, (long)((PairOfIntLong)list.get(4)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfIntLong)list.get(4)).getRightElement());
        Assert.assertEquals((long)3L, (long)((PairOfIntLong)list.get(5)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfIntLong)list.get(5)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByRightElementDescending, 4);
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((PairOfIntLong)list.get(0)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfIntLong)list.get(0)).getRightElement());
        Assert.assertEquals((long)2L, (long)((PairOfIntLong)list.get(1)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfIntLong)list.get(1)).getRightElement());
        Assert.assertEquals((long)3L, (long)((PairOfIntLong)list.get(2)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfIntLong)list.get(2)).getRightElement());
        Assert.assertEquals((long)4L, (long)((PairOfIntLong)list.get(3)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfIntLong)list.get(3)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByRightElementAscending, 4);
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((long)6L, (long)((PairOfIntLong)list.get(0)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfIntLong)list.get(0)).getRightElement());
        Assert.assertEquals((long)4L, (long)((PairOfIntLong)list.get(1)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfIntLong)list.get(1)).getRightElement());
        Assert.assertEquals((long)5L, (long)((PairOfIntLong)list.get(2)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfIntLong)list.get(2)).getRightElement());
        Assert.assertEquals((long)1L, (long)((PairOfIntLong)list.get(3)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfIntLong)list.get(3)).getRightElement());
    }

    protected void testGetSortedEventsCommon(Int2LongFrequencyDistribution fd) {
        fd.set(1, 1L);
        fd.set(4, 3L);
        fd.set(2, 4L);
        fd.set(5, 7L);
        fd.set(6, 9L);
        fd.set(3, 2L);
        Assert.assertEquals((long)6L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)26L, (long)fd.getSumOfCounts());
        List list = fd.getEntries(SortableEntries.Order.ByLeftElementAscending);
        Assert.assertEquals((long)6L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((PairOfIntLong)list.get(0)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfIntLong)list.get(0)).getRightElement());
        Assert.assertEquals((long)2L, (long)((PairOfIntLong)list.get(1)).getLeftElement());
        Assert.assertEquals((long)4L, (long)((PairOfIntLong)list.get(1)).getRightElement());
        Assert.assertEquals((long)3L, (long)((PairOfIntLong)list.get(2)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfIntLong)list.get(2)).getRightElement());
        Assert.assertEquals((long)4L, (long)((PairOfIntLong)list.get(3)).getLeftElement());
        Assert.assertEquals((long)3L, (long)((PairOfIntLong)list.get(3)).getRightElement());
        Assert.assertEquals((long)5L, (long)((PairOfIntLong)list.get(4)).getLeftElement());
        Assert.assertEquals((long)7L, (long)((PairOfIntLong)list.get(4)).getRightElement());
        Assert.assertEquals((long)6L, (long)((PairOfIntLong)list.get(5)).getLeftElement());
        Assert.assertEquals((long)9L, (long)((PairOfIntLong)list.get(5)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByLeftElementDescending);
        Assert.assertEquals((long)6L, (long)list.size());
        Assert.assertEquals((long)6L, (long)((PairOfIntLong)list.get(0)).getLeftElement());
        Assert.assertEquals((long)9L, (long)((PairOfIntLong)list.get(0)).getRightElement());
        Assert.assertEquals((long)5L, (long)((PairOfIntLong)list.get(1)).getLeftElement());
        Assert.assertEquals((long)7L, (long)((PairOfIntLong)list.get(1)).getRightElement());
        Assert.assertEquals((long)4L, (long)((PairOfIntLong)list.get(2)).getLeftElement());
        Assert.assertEquals((long)3L, (long)((PairOfIntLong)list.get(2)).getRightElement());
        Assert.assertEquals((long)3L, (long)((PairOfIntLong)list.get(3)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfIntLong)list.get(3)).getRightElement());
        Assert.assertEquals((long)2L, (long)((PairOfIntLong)list.get(4)).getLeftElement());
        Assert.assertEquals((long)4L, (long)((PairOfIntLong)list.get(4)).getRightElement());
        Assert.assertEquals((long)1L, (long)((PairOfIntLong)list.get(5)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfIntLong)list.get(5)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByLeftElementAscending, 4);
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((PairOfIntLong)list.get(0)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfIntLong)list.get(0)).getRightElement());
        Assert.assertEquals((long)2L, (long)((PairOfIntLong)list.get(1)).getLeftElement());
        Assert.assertEquals((long)4L, (long)((PairOfIntLong)list.get(1)).getRightElement());
        Assert.assertEquals((long)3L, (long)((PairOfIntLong)list.get(2)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfIntLong)list.get(2)).getRightElement());
        Assert.assertEquals((long)4L, (long)((PairOfIntLong)list.get(3)).getLeftElement());
        Assert.assertEquals((long)3L, (long)((PairOfIntLong)list.get(3)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByLeftElementDescending, 4);
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((long)6L, (long)((PairOfIntLong)list.get(0)).getLeftElement());
        Assert.assertEquals((long)9L, (long)((PairOfIntLong)list.get(0)).getRightElement());
        Assert.assertEquals((long)5L, (long)((PairOfIntLong)list.get(1)).getLeftElement());
        Assert.assertEquals((long)7L, (long)((PairOfIntLong)list.get(1)).getRightElement());
        Assert.assertEquals((long)4L, (long)((PairOfIntLong)list.get(2)).getLeftElement());
        Assert.assertEquals((long)3L, (long)((PairOfIntLong)list.get(2)).getRightElement());
        Assert.assertEquals((long)3L, (long)((PairOfIntLong)list.get(3)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfIntLong)list.get(3)).getRightElement());
    }

    protected void testIterableCommon(Int2LongFrequencyDistribution fd) {
        fd.set(1, 1L);
        fd.set(4, 3L);
        fd.set(2, 4L);
        fd.set(5, 7L);
        fd.set(6, 9L);
        fd.set(3, 2L);
        Assert.assertEquals((long)6L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)26L, (long)fd.getSumOfCounts());
        TreeSet<PairOfIntLong> list = new TreeSet<PairOfIntLong>();
        for (PairOfIntLong pair : fd) {
            list.add(pair.clone());
        }
        Assert.assertEquals((long)6L, (long)list.size());
        Iterator iter = list.iterator();
        PairOfIntLong e = (PairOfIntLong)iter.next();
        Assert.assertEquals((long)1L, (long)e.getLeftElement());
        Assert.assertEquals((long)1L, (long)e.getRightElement());
        e = (PairOfIntLong)iter.next();
        Assert.assertEquals((long)2L, (long)e.getLeftElement());
        Assert.assertEquals((long)4L, (long)e.getRightElement());
        e = (PairOfIntLong)iter.next();
        Assert.assertEquals((long)3L, (long)e.getLeftElement());
        Assert.assertEquals((long)2L, (long)e.getRightElement());
        e = (PairOfIntLong)iter.next();
        Assert.assertEquals((long)4L, (long)e.getLeftElement());
        Assert.assertEquals((long)3L, (long)e.getRightElement());
        e = (PairOfIntLong)iter.next();
        Assert.assertEquals((long)5L, (long)e.getLeftElement());
        Assert.assertEquals((long)7L, (long)e.getRightElement());
        e = (PairOfIntLong)iter.next();
        Assert.assertEquals((long)6L, (long)e.getLeftElement());
        Assert.assertEquals((long)9L, (long)e.getRightElement());
    }
}

