/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.fd;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.junit.Assert;
import tl.lin.data.SortableEntries;
import tl.lin.data.fd.Object2IntFrequencyDistribution;
import tl.lin.data.pair.PairOfObjectInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Object2IntFrequencyDistributionTestBase {
    protected void test1Common(Object2IntFrequencyDistribution<String> fd) {
        Assert.assertEquals((long)0L, (long)fd.get((Comparable)((Object)"a")));
        fd.increment((Comparable)((Object)"a"));
        fd.increment((Comparable)((Object)"b"));
        fd.increment((Comparable)((Object)"c"));
        fd.increment((Comparable)((Object)"b"));
        fd.increment((Comparable)((Object)"c"));
        fd.increment((Comparable)((Object)"c"));
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)6L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)1L, (long)fd.get((Comparable)((Object)"a")));
        Assert.assertEquals((long)2L, (long)fd.get((Comparable)((Object)"b")));
        Assert.assertEquals((long)3L, (long)fd.get((Comparable)((Object)"c")));
        Assert.assertEquals((double)0.16666666666666666, (double)fd.computeRelativeFrequency((Comparable)((Object)"a")), (double)1.0E-5);
        Assert.assertEquals((double)0.3333333333333333, (double)fd.computeRelativeFrequency((Comparable)((Object)"b")), (double)1.0E-5);
        Assert.assertEquals((double)0.5, (double)fd.computeRelativeFrequency((Comparable)((Object)"c")), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.16666666666666666), (double)fd.computeLogRelativeFrequency((Comparable)((Object)"a")), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.3333333333333333), (double)fd.computeLogRelativeFrequency((Comparable)((Object)"b")), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.5), (double)fd.computeLogRelativeFrequency((Comparable)((Object)"c")), (double)1.0E-5);
        fd.decrement((Comparable)((Object)"c"));
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)5L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)1L, (long)fd.get((Comparable)((Object)"a")));
        Assert.assertEquals((long)2L, (long)fd.get((Comparable)((Object)"b")));
        Assert.assertEquals((long)2L, (long)fd.get((Comparable)((Object)"c")));
        Assert.assertEquals((double)0.2, (double)fd.computeRelativeFrequency((Comparable)((Object)"a")), (double)1.0E-5);
        Assert.assertEquals((double)0.4, (double)fd.computeRelativeFrequency((Comparable)((Object)"b")), (double)1.0E-5);
        Assert.assertEquals((double)0.4, (double)fd.computeRelativeFrequency((Comparable)((Object)"c")), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.2), (double)fd.computeLogRelativeFrequency((Comparable)((Object)"a")), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.4), (double)fd.computeLogRelativeFrequency((Comparable)((Object)"b")), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.4), (double)fd.computeLogRelativeFrequency((Comparable)((Object)"c")), (double)1.0E-5);
        fd.decrement((Comparable)((Object)"a"));
        Assert.assertEquals((long)2L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)4L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)0L, (long)fd.get((Comparable)((Object)"a")));
        Assert.assertEquals((long)2L, (long)fd.get((Comparable)((Object)"b")));
        Assert.assertEquals((long)2L, (long)fd.get((Comparable)((Object)"c")));
        Assert.assertEquals((double)0.5, (double)fd.computeRelativeFrequency((Comparable)((Object)"b")), (double)1.0E-5);
        Assert.assertEquals((double)0.5, (double)fd.computeRelativeFrequency((Comparable)((Object)"c")), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.5), (double)fd.computeLogRelativeFrequency((Comparable)((Object)"b")), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.5), (double)fd.computeLogRelativeFrequency((Comparable)((Object)"c")), (double)1.0E-5);
        Set set = fd.keySet();
        Assert.assertEquals((long)2L, (long)set.size());
        Assert.assertFalse((boolean)set.contains("a"));
        Assert.assertTrue((boolean)set.contains("b"));
        Assert.assertTrue((boolean)set.contains("c"));
    }

    protected void test2Common(Object2IntFrequencyDistribution<String> fd) {
        fd.increment((Comparable)((Object)"a"));
        fd.increment((Comparable)((Object)"a"));
        fd.increment((Comparable)((Object)"b"));
        fd.increment((Comparable)((Object)"c"));
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)4L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)2L, (long)fd.get((Comparable)((Object)"a")));
        Assert.assertEquals((long)1L, (long)fd.get((Comparable)((Object)"b")));
        Assert.assertEquals((long)1L, (long)fd.get((Comparable)((Object)"c")));
        fd.set((Comparable)((Object)"d"), 5);
        Assert.assertEquals((long)4L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)9L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)2L, (long)fd.get((Comparable)((Object)"a")));
        Assert.assertEquals((long)1L, (long)fd.get((Comparable)((Object)"b")));
        Assert.assertEquals((long)1L, (long)fd.get((Comparable)((Object)"c")));
        Assert.assertEquals((long)5L, (long)fd.get((Comparable)((Object)"d")));
        fd.set((Comparable)((Object)"a"), 5);
        Assert.assertEquals((long)4L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)12L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)5L, (long)fd.get((Comparable)((Object)"a")));
        Assert.assertEquals((long)1L, (long)fd.get((Comparable)((Object)"b")));
        Assert.assertEquals((long)1L, (long)fd.get((Comparable)((Object)"c")));
        Assert.assertEquals((long)5L, (long)fd.get((Comparable)((Object)"d")));
        fd.increment((Comparable)((Object)"c"));
        fd.increment((Comparable)((Object)"c"));
        fd.increment((Comparable)((Object)"c"));
        Assert.assertEquals((long)4L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)15L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)5L, (long)fd.get((Comparable)((Object)"a")));
        Assert.assertEquals((long)1L, (long)fd.get((Comparable)((Object)"b")));
        Assert.assertEquals((long)4L, (long)fd.get((Comparable)((Object)"c")));
        Assert.assertEquals((long)5L, (long)fd.get((Comparable)((Object)"d")));
        fd.set((Comparable)((Object)"c"), 1);
        Assert.assertEquals((long)4L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)12L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)5L, (long)fd.get((Comparable)((Object)"a")));
        Assert.assertEquals((long)1L, (long)fd.get((Comparable)((Object)"b")));
        Assert.assertEquals((long)1L, (long)fd.get((Comparable)((Object)"c")));
        Assert.assertEquals((long)5L, (long)fd.get((Comparable)((Object)"d")));
    }

    protected void test3Common(Object2IntFrequencyDistribution<String> fd) {
        fd.increment((Comparable)((Object)"a"));
        fd.increment((Comparable)((Object)"a"));
        fd.increment((Comparable)((Object)"b"));
        fd.increment((Comparable)((Object)"c"));
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)4L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)2L, (long)fd.get((Comparable)((Object)"a")));
        Assert.assertEquals((long)1L, (long)fd.get((Comparable)((Object)"b")));
        Assert.assertEquals((long)1L, (long)fd.get((Comparable)((Object)"c")));
        fd.clear();
        Assert.assertEquals((long)0L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)0L, (long)fd.getSumOfCounts());
    }

    protected void testFailedDecrement1Common(Object2IntFrequencyDistribution<String> fd) {
        fd.increment((Comparable)((Object)"a"));
        Assert.assertEquals((long)1L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)1L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)1L, (long)fd.get((Comparable)((Object)"a")));
        fd.decrement((Comparable)((Object)"a"));
        Assert.assertEquals((long)0L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)0L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)0L, (long)fd.get((Comparable)((Object)"a")));
        fd.decrement((Comparable)((Object)"a"));
    }

    protected void testFailedDecrement2Common(Object2IntFrequencyDistribution<String> fd) {
        fd.increment((Comparable)((Object)"a"), 1000);
        Assert.assertEquals((long)1L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)1000L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)1000L, (long)fd.get((Comparable)((Object)"a")));
        fd.decrement((Comparable)((Object)"a"), 997);
        Assert.assertEquals((long)1L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)3L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)3L, (long)fd.get((Comparable)((Object)"a")));
        fd.decrement((Comparable)((Object)"a"), 3);
        Assert.assertEquals((long)0L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)0L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)0L, (long)fd.get((Comparable)((Object)"a")));
        fd.increment((Comparable)((Object)"a"), 3);
        fd.decrement((Comparable)((Object)"a"), 4);
    }

    protected void testMultiIncrementDecrementCommon(Object2IntFrequencyDistribution<String> fd) {
        fd.increment((Comparable)((Object)"a"), 2);
        fd.increment((Comparable)((Object)"b"), 3);
        fd.increment((Comparable)((Object)"c"), 4);
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)9L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)2L, (long)fd.get((Comparable)((Object)"a")));
        Assert.assertEquals((long)3L, (long)fd.get((Comparable)((Object)"b")));
        Assert.assertEquals((long)4L, (long)fd.get((Comparable)((Object)"c")));
        fd.decrement((Comparable)((Object)"b"), 2);
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)7L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)2L, (long)fd.get((Comparable)((Object)"a")));
        Assert.assertEquals((long)1L, (long)fd.get((Comparable)((Object)"b")));
        Assert.assertEquals((long)4L, (long)fd.get((Comparable)((Object)"c")));
    }

    protected void testGetFrequencySortedCommon(Object2IntFrequencyDistribution<String> fd) {
        fd.set((Comparable)((Object)"a"), 5);
        fd.set((Comparable)((Object)"d"), 2);
        fd.set((Comparable)((Object)"b"), 5);
        fd.set((Comparable)((Object)"e"), 2);
        fd.set((Comparable)((Object)"f"), 1);
        fd.set((Comparable)((Object)"c"), 5);
        Assert.assertEquals((long)6L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)20L, (long)fd.getSumOfCounts());
        List list = fd.getEntries(SortableEntries.Order.ByRightElementDescending);
        Assert.assertEquals((long)6L, (long)list.size());
        Assert.assertEquals((Object)"a", (Object)((PairOfObjectInt)list.get(0)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectInt)list.get(0)).getRightElement());
        Assert.assertEquals((Object)"b", (Object)((PairOfObjectInt)list.get(1)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectInt)list.get(1)).getRightElement());
        Assert.assertEquals((Object)"c", (Object)((PairOfObjectInt)list.get(2)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectInt)list.get(2)).getRightElement());
        Assert.assertEquals((Object)"d", (Object)((PairOfObjectInt)list.get(3)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectInt)list.get(3)).getRightElement());
        Assert.assertEquals((Object)"e", (Object)((PairOfObjectInt)list.get(4)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectInt)list.get(4)).getRightElement());
        Assert.assertEquals((Object)"f", (Object)((PairOfObjectInt)list.get(5)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfObjectInt)list.get(5)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByRightElementAscending);
        Assert.assertEquals((long)6L, (long)list.size());
        Assert.assertEquals((Object)"f", (Object)((PairOfObjectInt)list.get(0)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfObjectInt)list.get(0)).getRightElement());
        Assert.assertEquals((Object)"d", (Object)((PairOfObjectInt)list.get(1)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectInt)list.get(1)).getRightElement());
        Assert.assertEquals((Object)"e", (Object)((PairOfObjectInt)list.get(2)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectInt)list.get(2)).getRightElement());
        Assert.assertEquals((Object)"a", (Object)((PairOfObjectInt)list.get(3)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectInt)list.get(3)).getRightElement());
        Assert.assertEquals((Object)"b", (Object)((PairOfObjectInt)list.get(4)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectInt)list.get(4)).getRightElement());
        Assert.assertEquals((Object)"c", (Object)((PairOfObjectInt)list.get(5)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectInt)list.get(5)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByRightElementDescending, 4);
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)"a", (Object)((PairOfObjectInt)list.get(0)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectInt)list.get(0)).getRightElement());
        Assert.assertEquals((Object)"b", (Object)((PairOfObjectInt)list.get(1)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectInt)list.get(1)).getRightElement());
        Assert.assertEquals((Object)"c", (Object)((PairOfObjectInt)list.get(2)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectInt)list.get(2)).getRightElement());
        Assert.assertEquals((Object)"d", (Object)((PairOfObjectInt)list.get(3)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectInt)list.get(3)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByRightElementAscending, 4);
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)"f", (Object)((PairOfObjectInt)list.get(0)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfObjectInt)list.get(0)).getRightElement());
        Assert.assertEquals((Object)"d", (Object)((PairOfObjectInt)list.get(1)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectInt)list.get(1)).getRightElement());
        Assert.assertEquals((Object)"e", (Object)((PairOfObjectInt)list.get(2)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectInt)list.get(2)).getRightElement());
        Assert.assertEquals((Object)"a", (Object)((PairOfObjectInt)list.get(3)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectInt)list.get(3)).getRightElement());
    }

    protected void testGetSortedEventsCommon(Object2IntFrequencyDistribution<String> fd) {
        fd.set((Comparable)((Object)"a"), 1);
        fd.set((Comparable)((Object)"d"), 3);
        fd.set((Comparable)((Object)"b"), 4);
        fd.set((Comparable)((Object)"e"), 7);
        fd.set((Comparable)((Object)"f"), 9);
        fd.set((Comparable)((Object)"c"), 2);
        Assert.assertEquals((long)6L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)26L, (long)fd.getSumOfCounts());
        List list = fd.getEntries(SortableEntries.Order.ByLeftElementAscending);
        Assert.assertEquals((long)6L, (long)list.size());
        Assert.assertEquals((Object)"a", (Object)((PairOfObjectInt)list.get(0)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfObjectInt)list.get(0)).getRightElement());
        Assert.assertEquals((Object)"b", (Object)((PairOfObjectInt)list.get(1)).getLeftElement());
        Assert.assertEquals((long)4L, (long)((PairOfObjectInt)list.get(1)).getRightElement());
        Assert.assertEquals((Object)"c", (Object)((PairOfObjectInt)list.get(2)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectInt)list.get(2)).getRightElement());
        Assert.assertEquals((Object)"d", (Object)((PairOfObjectInt)list.get(3)).getLeftElement());
        Assert.assertEquals((long)3L, (long)((PairOfObjectInt)list.get(3)).getRightElement());
        Assert.assertEquals((Object)"e", (Object)((PairOfObjectInt)list.get(4)).getLeftElement());
        Assert.assertEquals((long)7L, (long)((PairOfObjectInt)list.get(4)).getRightElement());
        Assert.assertEquals((Object)"f", (Object)((PairOfObjectInt)list.get(5)).getLeftElement());
        Assert.assertEquals((long)9L, (long)((PairOfObjectInt)list.get(5)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByLeftElementDescending);
        Assert.assertEquals((long)6L, (long)list.size());
        Assert.assertEquals((Object)"f", (Object)((PairOfObjectInt)list.get(0)).getLeftElement());
        Assert.assertEquals((long)9L, (long)((PairOfObjectInt)list.get(0)).getRightElement());
        Assert.assertEquals((Object)"e", (Object)((PairOfObjectInt)list.get(1)).getLeftElement());
        Assert.assertEquals((long)7L, (long)((PairOfObjectInt)list.get(1)).getRightElement());
        Assert.assertEquals((Object)"d", (Object)((PairOfObjectInt)list.get(2)).getLeftElement());
        Assert.assertEquals((long)3L, (long)((PairOfObjectInt)list.get(2)).getRightElement());
        Assert.assertEquals((Object)"c", (Object)((PairOfObjectInt)list.get(3)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectInt)list.get(3)).getRightElement());
        Assert.assertEquals((Object)"b", (Object)((PairOfObjectInt)list.get(4)).getLeftElement());
        Assert.assertEquals((long)4L, (long)((PairOfObjectInt)list.get(4)).getRightElement());
        Assert.assertEquals((Object)"a", (Object)((PairOfObjectInt)list.get(5)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfObjectInt)list.get(5)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByLeftElementAscending, 4);
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)"a", (Object)((PairOfObjectInt)list.get(0)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfObjectInt)list.get(0)).getRightElement());
        Assert.assertEquals((Object)"b", (Object)((PairOfObjectInt)list.get(1)).getLeftElement());
        Assert.assertEquals((long)4L, (long)((PairOfObjectInt)list.get(1)).getRightElement());
        Assert.assertEquals((Object)"c", (Object)((PairOfObjectInt)list.get(2)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectInt)list.get(2)).getRightElement());
        Assert.assertEquals((Object)"d", (Object)((PairOfObjectInt)list.get(3)).getLeftElement());
        Assert.assertEquals((long)3L, (long)((PairOfObjectInt)list.get(3)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByLeftElementDescending, 4);
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)"f", (Object)((PairOfObjectInt)list.get(0)).getLeftElement());
        Assert.assertEquals((long)9L, (long)((PairOfObjectInt)list.get(0)).getRightElement());
        Assert.assertEquals((Object)"e", (Object)((PairOfObjectInt)list.get(1)).getLeftElement());
        Assert.assertEquals((long)7L, (long)((PairOfObjectInt)list.get(1)).getRightElement());
        Assert.assertEquals((Object)"d", (Object)((PairOfObjectInt)list.get(2)).getLeftElement());
        Assert.assertEquals((long)3L, (long)((PairOfObjectInt)list.get(2)).getRightElement());
        Assert.assertEquals((Object)"c", (Object)((PairOfObjectInt)list.get(3)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectInt)list.get(3)).getRightElement());
    }

    protected void testIterableCommon(Object2IntFrequencyDistribution<String> fd) {
        fd.set((Comparable)((Object)"a"), 1);
        fd.set((Comparable)((Object)"d"), 3);
        fd.set((Comparable)((Object)"b"), 4);
        fd.set((Comparable)((Object)"e"), 7);
        fd.set((Comparable)((Object)"f"), 9);
        fd.set((Comparable)((Object)"c"), 2);
        Assert.assertEquals((long)6L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)26L, (long)fd.getSumOfCounts());
        TreeSet<PairOfObjectInt> list = new TreeSet<PairOfObjectInt>();
        for (PairOfObjectInt pair : fd) {
            list.add(pair.clone());
        }
        Assert.assertEquals((long)6L, (long)list.size());
        Iterator iter = list.iterator();
        PairOfObjectInt e = (PairOfObjectInt)iter.next();
        Assert.assertEquals((Object)"a", (Object)e.getLeftElement());
        Assert.assertEquals((long)1L, (long)e.getRightElement());
        e = (PairOfObjectInt)iter.next();
        Assert.assertEquals((Object)"b", (Object)e.getLeftElement());
        Assert.assertEquals((long)4L, (long)e.getRightElement());
        e = (PairOfObjectInt)iter.next();
        Assert.assertEquals((Object)"c", (Object)e.getLeftElement());
        Assert.assertEquals((long)2L, (long)e.getRightElement());
        e = (PairOfObjectInt)iter.next();
        Assert.assertEquals((Object)"d", (Object)e.getLeftElement());
        Assert.assertEquals((long)3L, (long)e.getRightElement());
        e = (PairOfObjectInt)iter.next();
        Assert.assertEquals((Object)"e", (Object)e.getLeftElement());
        Assert.assertEquals((long)7L, (long)e.getRightElement());
        e = (PairOfObjectInt)iter.next();
        Assert.assertEquals((Object)"f", (Object)e.getLeftElement());
        Assert.assertEquals((long)9L, (long)e.getRightElement());
    }
}

