/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.map;

import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import tl.lin.data.map.HMapIVW;

public class HMapIVWTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        HMapIVW m = new HMapIVW();
        m.put(5, (Object)new Text("hi"));
        m.put(22, (Object)new Text("there"));
        Assert.assertEquals((long)m.size(), (long)2L);
        Text value = (Text)m.get(5);
        Assert.assertEquals((Object)new Text("hi"), (Object)value);
        value = (Text)m.remove(5);
        Assert.assertEquals((Object)new Text("hi"), (Object)value);
        Assert.assertEquals((long)m.size(), (long)1L);
        value = (Text)m.get(22);
        Assert.assertEquals((Object)new Text("there"), (Object)value);
    }

    @org.junit.Test
    public void testSerialize1() throws IOException {
        HMapIVW m1 = new HMapIVW();
        m1.put(5, (Object)new Text("hi"));
        m1.put(22, (Object)new Text("there"));
        HMapIVW m2 = HMapIVW.create((byte[])m1.serialize());
        Assert.assertEquals((long)m2.size(), (long)2L);
        Text value = (Text)m2.get(5);
        Assert.assertEquals((Object)new Text("hi"), (Object)value);
        value = (Text)m2.remove(5);
        Assert.assertEquals((Object)new Text("hi"), (Object)value);
        Assert.assertEquals((long)m2.size(), (long)1L);
        value = (Text)m2.get(22);
        Assert.assertEquals((Object)new Text("there"), (Object)value);
    }

    @org.junit.Test
    public void testSerializeEmpty() throws IOException {
        HMapIVW m1 = new HMapIVW();
        Assert.assertTrue((m1.size() == 0 ? 1 : 0) != 0);
        HMapIVW m2 = HMapIVW.create((byte[])m1.serialize());
        Assert.assertTrue((m2.size() == 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(HMapIVWTest.class);
    }
}

