/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.map;

import java.io.IOException;
import java.util.Random;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import tl.lin.data.map.HMapKI;
import tl.lin.data.map.MapKI;

public class HMapKITest {
    @org.junit.Test
    public void testBasic1() {
        int i;
        int size = 100000;
        Random r = new Random();
        int[] ints = new int[size];
        HMapKI map = new HMapKI();
        for (i = 0; i < size; ++i) {
            int k = r.nextInt(size);
            map.put((Object)i, k);
            ints[i] = k;
        }
        for (i = 0; i < size; ++i) {
            int v = map.get((Object)i);
            Assert.assertEquals((long)ints[i], (long)v);
            Assert.assertTrue((boolean)map.containsKey((Object)i));
        }
    }

    @org.junit.Test
    public void testBasic2() {
        int i;
        int size = 100000;
        Random r = new Random();
        int[] ints = new int[size];
        String[] strings = new String[size];
        HMapKI map = new HMapKI();
        for (i = 0; i < size; ++i) {
            int k = r.nextInt(size);
            String s = new Integer(k).toString();
            map.put((Object)s, k);
            ints[i] = k;
            strings[i] = s;
        }
        for (i = 0; i < size; ++i) {
            int v = map.get((Object)strings[i]);
            Assert.assertEquals((long)ints[i], (long)v);
            Assert.assertTrue((boolean)map.containsKey((Object)strings[i]));
        }
    }

    @org.junit.Test
    public void testUpdate() {
        int i;
        int size = 100000;
        Random r = new Random();
        int[] ints = new int[size];
        HMapKI map = new HMapKI();
        for (i = 0; i < size; ++i) {
            int k = r.nextInt(size);
            map.put((Object)i, k);
            ints[i] = k;
        }
        Assert.assertEquals((long)size, (long)map.size());
        for (i = 0; i < size; ++i) {
            map.put((Object)i, ints[i] + 1);
        }
        Assert.assertEquals((long)size, (long)map.size());
        for (i = 0; i < size; ++i) {
            int v = map.get((Object)i);
            Assert.assertEquals((long)(ints[i] + 1), (long)v);
            Assert.assertTrue((boolean)map.containsKey((Object)i));
        }
    }

    @org.junit.Test
    public void testToString() throws IOException {
        HMapKI m1 = new HMapKI();
        m1.put((Comparable)((Object)"hi"), 5);
        m1.put((Comparable)((Object)"there"), 22);
        Assert.assertEquals((Object)"{there=22, hi=5}", (Object)m1.toString());
    }

    @org.junit.Test
    public void testBasic() throws IOException {
        HMapKI m = new HMapKI();
        m.put((Comparable)new Text("hi"), 5);
        m.put((Comparable)new Text("there"), 22);
        Assert.assertEquals((long)m.size(), (long)2L);
        Text key = new Text("hi");
        int value = m.get((Comparable)key);
        Assert.assertEquals((long)value, (long)5L);
        value = m.remove((Comparable)key);
        Assert.assertEquals((long)m.size(), (long)1L);
        key = new Text("there");
        value = m.get((Comparable)key);
        Assert.assertEquals((long)value, (long)22L);
    }

    @org.junit.Test
    public void testPlus() throws IOException {
        HMapKI m1 = new HMapKI();
        m1.put((Comparable)new Text("hi"), 5);
        m1.put((Comparable)new Text("there"), 22);
        HMapKI m2 = new HMapKI();
        m2.put((Comparable)new Text("hi"), 4);
        m2.put((Comparable)new Text("test"), 5);
        m1.plus((MapKI)m2);
        Assert.assertEquals((long)3L, (long)m1.size());
        Assert.assertTrue((m1.get((Comparable)new Text("hi")) == 9 ? 1 : 0) != 0);
        Assert.assertTrue((m1.get((Comparable)new Text("there")) == 22 ? 1 : 0) != 0);
        Assert.assertTrue((m1.get((Comparable)new Text("test")) == 5 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testDot() throws IOException {
        HMapKI m1 = new HMapKI();
        m1.put((Comparable)new Text("hi"), 5);
        m1.put((Comparable)new Text("there"), 2);
        m1.put((Comparable)new Text("empty"), 3);
        HMapKI m2 = new HMapKI();
        m2.put((Comparable)new Text("hi"), 4);
        m2.put((Comparable)new Text("there"), 4);
        m2.put((Comparable)new Text("test"), 5);
        int s = m1.dot((MapKI)m2);
        Assert.assertEquals((long)s, (long)28L);
    }

    @org.junit.Test
    public void testSortedEntriesValue1() {
        HMapKI m = new HMapKI();
        m.put((Comparable)new Text("a"), 5);
        m.put((Comparable)new Text("b"), 2);
        m.put((Comparable)new Text("c"), 3);
        m.put((Comparable)new Text("d"), 3);
        m.put((Comparable)new Text("e"), 1);
        MapKI.Entry[] entries = m.getEntriesSortedByValue();
        MapKI.Entry e = null;
        Assert.assertEquals((long)5L, (long)entries.length);
        e = entries[0];
        Assert.assertEquals((Object)new Text("a"), (Object)e.getKey());
        Assert.assertEquals((long)5L, (long)e.getValue());
        e = entries[1];
        Assert.assertEquals((Object)new Text("c"), (Object)e.getKey());
        Assert.assertEquals((long)3L, (long)e.getValue());
        e = entries[2];
        Assert.assertEquals((Object)new Text("d"), (Object)e.getKey());
        Assert.assertEquals((long)3L, (long)e.getValue());
        e = entries[3];
        Assert.assertEquals((Object)new Text("b"), (Object)e.getKey());
        Assert.assertEquals((long)2L, (long)e.getValue());
        e = entries[4];
        Assert.assertEquals((Object)new Text("e"), (Object)e.getKey());
        Assert.assertEquals((long)1L, (long)e.getValue());
    }

    @org.junit.Test
    public void testSortedEntriesValue2() {
        HMapKI m = new HMapKI();
        m.put((Comparable)new Text("a"), 5);
        m.put((Comparable)new Text("b"), 2);
        m.put((Comparable)new Text("c"), 3);
        m.put((Comparable)new Text("d"), 3);
        m.put((Comparable)new Text("e"), 1);
        MapKI.Entry[] entries = m.getEntriesSortedByValue(2);
        MapKI.Entry e = null;
        Assert.assertEquals((long)2L, (long)entries.length);
        e = entries[0];
        Assert.assertEquals((Object)new Text("a"), (Object)e.getKey());
        Assert.assertEquals((long)5L, (long)e.getValue());
        e = entries[1];
        Assert.assertEquals((Object)new Text("c"), (Object)e.getKey());
        Assert.assertEquals((long)3L, (long)e.getValue());
    }

    @org.junit.Test
    public void testSortedEntriesKey1() {
        HMapKI m = new HMapKI();
        m.put((Comparable)new Text("a"), 5);
        m.put((Comparable)new Text("b"), 2);
        m.put((Comparable)new Text("c"), 3);
        m.put((Comparable)new Text("d"), 3);
        m.put((Comparable)new Text("e"), 1);
        MapKI.Entry[] entries = m.getEntriesSortedByKey();
        MapKI.Entry e = null;
        Assert.assertEquals((long)5L, (long)entries.length);
        e = entries[0];
        Assert.assertEquals((Object)new Text("a"), (Object)e.getKey());
        Assert.assertEquals((long)5L, (long)e.getValue());
        e = entries[1];
        Assert.assertEquals((Object)new Text("b"), (Object)e.getKey());
        Assert.assertEquals((long)2L, (long)e.getValue());
        e = entries[2];
        Assert.assertEquals((Object)new Text("c"), (Object)e.getKey());
        Assert.assertEquals((long)3L, (long)e.getValue());
        e = entries[3];
        Assert.assertEquals((Object)new Text("d"), (Object)e.getKey());
        Assert.assertEquals((long)3L, (long)e.getValue());
        e = entries[4];
        Assert.assertEquals((Object)new Text("e"), (Object)e.getKey());
        Assert.assertEquals((long)1L, (long)e.getValue());
    }

    @org.junit.Test
    public void testSortedEntriesKey2() {
        HMapKI m = new HMapKI();
        m.put((Comparable)new Text("a"), 5);
        m.put((Comparable)new Text("b"), 2);
        m.put((Comparable)new Text("c"), 3);
        m.put((Comparable)new Text("d"), 3);
        m.put((Comparable)new Text("e"), 1);
        MapKI.Entry[] entries = m.getEntriesSortedByKey(2);
        MapKI.Entry e = null;
        Assert.assertEquals((long)2L, (long)entries.length);
        e = entries[0];
        Assert.assertEquals((Object)new Text("a"), (Object)e.getKey());
        Assert.assertEquals((long)5L, (long)e.getValue());
        e = entries[1];
        Assert.assertEquals((Object)new Text("b"), (Object)e.getKey());
        Assert.assertEquals((long)2L, (long)e.getValue());
    }

    @org.junit.Test
    public void testIncrement() {
        HMapKI m = new HMapKI();
        Assert.assertEquals((long)0L, (long)m.get((Comparable)((Object)"one")));
        m.increment((Comparable)((Object)"one"));
        Assert.assertEquals((long)1L, (long)m.get((Comparable)((Object)"one")));
        m.increment((Comparable)((Object)"one"), 5);
        m.increment((Comparable)((Object)"two"), 0);
        m.increment((Comparable)((Object)"three"), 2);
        Assert.assertEquals((long)6L, (long)m.get((Comparable)((Object)"one")));
        Assert.assertEquals((long)0L, (long)m.get((Comparable)((Object)"two")));
        Assert.assertEquals((long)2L, (long)m.get((Comparable)((Object)"three")));
    }

    public static Test suite() {
        return new JUnit4TestAdapter(HMapKITest.class);
    }
}

