/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.map;

import java.util.Random;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import tl.lin.data.map.HMapKL;

public class HMapKLTest {
    @org.junit.Test
    public void testBasic1() {
        int i;
        int size = 100000;
        Random r = new Random();
        long[] longs = new long[size];
        HMapKL map = new HMapKL();
        for (i = 0; i < size; ++i) {
            long k = r.nextLong();
            map.put((Object)i, k);
            longs[i] = k;
        }
        for (i = 0; i < size; ++i) {
            long v = map.get((Object)i);
            Assert.assertEquals((long)longs[i], (long)v);
            Assert.assertTrue((boolean)map.containsKey((Object)i));
        }
    }

    @org.junit.Test
    public void testBasic2() {
        int i;
        int size = 100000;
        Random r = new Random();
        long[] longs = new long[size];
        String[] strings = new String[size];
        HMapKL map = new HMapKL();
        for (i = 0; i < size; ++i) {
            int k = r.nextInt(size);
            String s = new Integer(k).toString();
            map.put((Object)s, (long)k);
            longs[i] = k;
            strings[i] = s;
        }
        for (i = 0; i < size; ++i) {
            long v = map.get((Object)strings[i]);
            Assert.assertEquals((long)longs[i], (long)v);
            Assert.assertTrue((boolean)map.containsKey((Object)strings[i]));
        }
    }

    @org.junit.Test
    public void testUpdate() {
        int i;
        int size = 100000;
        Random r = new Random();
        long[] longs = new long[size];
        HMapKL map = new HMapKL();
        for (i = 0; i < size; ++i) {
            int k = r.nextInt(size);
            map.put((Object)i, (long)k);
            longs[i] = k;
        }
        Assert.assertEquals((long)size, (long)map.size());
        for (i = 0; i < size; ++i) {
            map.put((Object)i, longs[i] + 1L);
        }
        Assert.assertEquals((long)size, (long)map.size());
        for (i = 0; i < size; ++i) {
            long v = map.get((Object)i);
            Assert.assertEquals((long)(longs[i] + 1L), (long)v);
            Assert.assertTrue((boolean)map.containsKey((Object)i));
        }
    }

    @org.junit.Test
    public void testIncrement() {
        HMapKL m = new HMapKL();
        Assert.assertEquals((long)0L, (long)m.get((Object)"one"));
        m.increment((Object)"one", 1L);
        Assert.assertEquals((long)1L, (long)m.get((Object)"one"));
        m.increment((Object)"one", 1L);
        m.increment((Object)"two", 0L);
        m.increment((Object)"three", -1L);
        Assert.assertEquals((long)2L, (long)m.get((Object)"one"));
        Assert.assertEquals((long)0L, (long)m.get((Object)"two"));
        Assert.assertEquals((long)-1L, (long)m.get((Object)"three"));
    }

    public static Test suite() {
        return new JUnit4TestAdapter(HMapKLTest.class);
    }
}

