/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.pair;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.junit.Assert;
import tl.lin.data.WritableComparatorTestHarness;
import tl.lin.data.pair.PairOfFloatInt;

public class PairOfFloatIntTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        PairOfFloatInt pair = new PairOfFloatInt(3.14f, 2);
        Assert.assertTrue((pair.getLeftElement() == 3.14f ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)pair.getRightElement());
    }

    @org.junit.Test
    public void testSerialize() throws IOException {
        PairOfFloatInt origPair = new PairOfFloatInt(3.14f, 2);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        origPair.write((DataOutput)dataOut);
        PairOfFloatInt pair = new PairOfFloatInt();
        pair.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertTrue((pair.getLeftElement() == 3.14f ? 1 : 0) != 0);
        Assert.assertEquals((long)pair.getRightElement(), (long)2L);
    }

    @org.junit.Test
    public void testComparison1() throws IOException {
        PairOfFloatInt pair1 = new PairOfFloatInt(3.14f, 2);
        PairOfFloatInt pair2 = new PairOfFloatInt(3.14f, 2);
        PairOfFloatInt pair3 = new PairOfFloatInt(3.14f, 1);
        PairOfFloatInt pair4 = new PairOfFloatInt(0.3f, 9);
        PairOfFloatInt pair5 = new PairOfFloatInt(9.9f, 0);
        Assert.assertTrue((boolean)pair1.equals((Object)pair2));
        Assert.assertFalse((boolean)pair1.equals((Object)pair3));
        Assert.assertTrue((pair1.compareTo(pair2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair3.compareTo(pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair4.compareTo(pair5) < 0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testComparison2() throws IOException {
        PairOfFloatInt.Comparator comparator = new PairOfFloatInt.Comparator();
        PairOfFloatInt pair1 = new PairOfFloatInt(3.14f, 2);
        PairOfFloatInt pair2 = new PairOfFloatInt(3.14f, 2);
        PairOfFloatInt pair3 = new PairOfFloatInt(3.14f, 1);
        PairOfFloatInt pair4 = new PairOfFloatInt(0.3f, 9);
        PairOfFloatInt pair5 = new PairOfFloatInt(9.9f, 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair1, (WritableComparable)pair2) == 0 ? 1 : 0) != 0);
        Assert.assertFalse((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair1, (WritableComparable)pair3) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair1, (WritableComparable)pair2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair1, (WritableComparable)pair3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair1, (WritableComparable)pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair1, (WritableComparable)pair5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair3, (WritableComparable)pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair4, (WritableComparable)pair5) < 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(PairOfFloatIntTest.class);
    }
}

