/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.pair;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.junit.Assert;
import tl.lin.data.WritableComparatorTestHarness;
import tl.lin.data.pair.PairOfStrings;

public class PairOfStringsTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        PairOfStrings pair = new PairOfStrings("hi", "there");
        Assert.assertEquals((Object)"hi", (Object)pair.getLeftElement());
        Assert.assertEquals((Object)"there", (Object)pair.getRightElement());
    }

    @org.junit.Test
    public void testSerialize() throws IOException {
        PairOfStrings origPair = new PairOfStrings("hi", "there");
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        origPair.write((DataOutput)dataOut);
        PairOfStrings pair = new PairOfStrings();
        pair.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((Object)"hi", (Object)pair.getLeftElement());
        Assert.assertEquals((Object)"there", (Object)pair.getRightElement());
    }

    @org.junit.Test
    public void testOptimizedSerialize() throws IOException {
        PairOfStrings pair1 = new PairOfStrings("hi", "there");
        ByteArrayOutputStream pair1_bytesOut = new ByteArrayOutputStream();
        DataOutputStream pair1_dataOut = new DataOutputStream(pair1_bytesOut);
        pair1.write((DataOutput)pair1_dataOut);
        byte[] bytes1 = pair1_bytesOut.toByteArray();
        PairOfStrings pair2 = new PairOfStrings("hi", "there");
        ByteArrayOutputStream pair2_bytesOut = new ByteArrayOutputStream();
        DataOutputStream pair2_dataOut = new DataOutputStream(pair2_bytesOut);
        pair2.write((DataOutput)pair2_dataOut);
        byte[] bytes2 = pair2_bytesOut.toByteArray();
        PairOfStrings pair3 = new PairOfStrings("hi", "howdy");
        ByteArrayOutputStream pair3_bytesOut = new ByteArrayOutputStream();
        DataOutputStream pair3_dataOut = new DataOutputStream(pair3_bytesOut);
        pair3.write((DataOutput)pair3_dataOut);
        byte[] bytes3 = pair3_bytesOut.toByteArray();
        PairOfStrings pair4 = new PairOfStrings("a", "howdy");
        ByteArrayOutputStream pair4_bytesOut = new ByteArrayOutputStream();
        DataOutputStream pair4_dataOut = new DataOutputStream(pair4_bytesOut);
        pair4.write((DataOutput)pair4_dataOut);
        byte[] bytes4 = pair4_bytesOut.toByteArray();
        PairOfStrings pair5 = new PairOfStrings("hi", "z");
        ByteArrayOutputStream pair5_bytesOut = new ByteArrayOutputStream();
        DataOutputStream pair5_dataOut = new DataOutputStream(pair5_bytesOut);
        pair5.write((DataOutput)pair5_dataOut);
        byte[] bytes5 = pair5_bytesOut.toByteArray();
        PairOfStrings.Comparator pairOfStringComparator = new PairOfStrings.Comparator();
        Assert.assertTrue((pairOfStringComparator.compare(bytes1, 0, bytes1.length, bytes2, 0, bytes2.length) == 0 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)pair1.equals((Object)pair3));
        Assert.assertTrue((pairOfStringComparator.compare(bytes1, 0, bytes1.length, bytes3, 0, bytes3.length) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pairOfStringComparator.compare(bytes1, 0, bytes1.length, bytes4, 0, bytes4.length) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pairOfStringComparator.compare(bytes1, 0, bytes1.length, bytes5, 0, bytes5.length) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((pairOfStringComparator.compare(bytes3, 0, bytes3.length, bytes4, 0, bytes4.length) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pairOfStringComparator.compare(bytes4, 0, bytes4.length, bytes5, 0, bytes5.length) < 0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testComparison1() throws IOException {
        PairOfStrings pair1 = new PairOfStrings("hi", "there");
        PairOfStrings pair2 = new PairOfStrings("hi", "there");
        PairOfStrings pair3 = new PairOfStrings("hi", "howdy");
        PairOfStrings pair4 = new PairOfStrings("a", "howdy");
        PairOfStrings pair5 = new PairOfStrings("hi", "z");
        Assert.assertTrue((boolean)pair1.equals((Object)pair2));
        Assert.assertFalse((boolean)pair1.equals((Object)pair3));
        Assert.assertTrue((pair1.compareTo(pair2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair3.compareTo(pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair4.compareTo(pair5) < 0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testComparison2() throws IOException {
        PairOfStrings.Comparator comparator = new PairOfStrings.Comparator();
        PairOfStrings pair1 = new PairOfStrings("hi", "there");
        PairOfStrings pair2 = new PairOfStrings("hi", "there");
        PairOfStrings pair3 = new PairOfStrings("hi", "howdy");
        PairOfStrings pair4 = new PairOfStrings("a", "howdy");
        PairOfStrings pair5 = new PairOfStrings("hi", "z");
        Assert.assertTrue((boolean)pair1.equals((Object)pair2));
        Assert.assertFalse((boolean)pair1.equals((Object)pair3));
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair1, (WritableComparable)pair2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair1, (WritableComparable)pair3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair1, (WritableComparable)pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair1, (WritableComparable)pair5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair3, (WritableComparable)pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair4, (WritableComparable)pair5) < 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(PairOfStringsTest.class);
    }
}

