/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.fd;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import tl.lin.data.SortableEntries;
import tl.lin.data.fd.Object2IntFrequencyDistribution;
import tl.lin.data.map.HMapKI;
import tl.lin.data.map.MapKI;
import tl.lin.data.pair.PairOfObjectInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Object2IntFrequencyDistributionEntry<K extends Comparable<K>>
implements Object2IntFrequencyDistribution<K> {
    private MapKI<K> counts = new HMapKI();
    private long sumOfCounts = 0L;
    private final Comparator<PairOfObjectInt<K>> comparatorRightDescending = new Comparator<PairOfObjectInt<K>>(){

        @Override
        public int compare(PairOfObjectInt<K> e1, PairOfObjectInt<K> e2) {
            if (e1.getRightElement() > e2.getRightElement()) {
                return -1;
            }
            if (e1.getRightElement() < e2.getRightElement()) {
                return 1;
            }
            return e1.getLeftElement().compareTo(e2.getLeftElement());
        }
    };
    private final Comparator<PairOfObjectInt<K>> comparatorRightAscending = new Comparator<PairOfObjectInt<K>>(){

        @Override
        public int compare(PairOfObjectInt<K> e1, PairOfObjectInt<K> e2) {
            if (e1.getRightElement() > e2.getRightElement()) {
                return 1;
            }
            if (e1.getRightElement() < e2.getRightElement()) {
                return -1;
            }
            return e1.getLeftElement().compareTo(e2.getLeftElement());
        }
    };
    private final Comparator<PairOfObjectInt<K>> comparatorLeftAscending = new Comparator<PairOfObjectInt<K>>(){

        @Override
        public int compare(PairOfObjectInt<K> e1, PairOfObjectInt<K> e2) {
            if (e1.getLeftElement().equals(e2.getLeftElement())) {
                throw new RuntimeException("Event observed twice!");
            }
            return e1.getLeftElement().compareTo(e2.getLeftElement());
        }
    };
    private final Comparator<PairOfObjectInt<K>> comparatorLeftDescending = new Comparator<PairOfObjectInt<K>>(){

        @Override
        public int compare(PairOfObjectInt<K> e1, PairOfObjectInt<K> e2) {
            if (e1.getLeftElement().equals(e2.getLeftElement())) {
                throw new RuntimeException("Event observed twice!");
            }
            return e2.getLeftElement().compareTo(e1.getLeftElement());
        }
    };

    @Override
    public void increment(K key) {
        this.set(key, this.get(key) + 1);
    }

    @Override
    public void increment(K key, int cnt) {
        this.set(key, this.get(key) + cnt);
    }

    @Override
    public void decrement(K key) {
        if (this.contains(key)) {
            int v = this.get(key);
            if (v == 1) {
                this.remove(key);
            } else {
                this.set(key, v - 1);
            }
        } else {
            throw new RuntimeException("Can't decrement non-existent event!");
        }
    }

    @Override
    public void decrement(K key, int cnt) {
        if (this.contains(key)) {
            int v = this.get(key);
            if (v < cnt) {
                throw new RuntimeException("Can't decrement past zero!");
            }
            if (v == cnt) {
                this.remove(key);
            } else {
                this.set(key, v - cnt);
            }
        } else {
            throw new RuntimeException("Can't decrement non-existent event!");
        }
    }

    @Override
    public boolean contains(K k) {
        return this.counts.containsKey(k);
    }

    @Override
    public int get(K k) {
        return this.counts.get(k);
    }

    @Override
    public int set(K k, int v) {
        int rv = this.counts.put(k, v);
        this.sumOfCounts = this.sumOfCounts - (long)rv + (long)v;
        return rv;
    }

    @Override
    public double computeRelativeFrequency(K k) {
        return (double)this.counts.get(k) / (double)this.getSumOfCounts();
    }

    @Override
    public double computeLogRelativeFrequency(K k) {
        return Math.log(this.counts.get(k)) - Math.log(this.getSumOfCounts());
    }

    @Override
    public int remove(K k) {
        int rv = this.counts.remove(k);
        this.sumOfCounts -= (long)rv;
        return rv;
    }

    @Override
    public void clear() {
        this.counts.clear();
        this.sumOfCounts = 0L;
    }

    @Override
    public int getNumberOfEvents() {
        return this.counts.size();
    }

    @Override
    public long getSumOfCounts() {
        return this.sumOfCounts;
    }

    @Override
    public Set<K> keySet() {
        return this.counts.keySet();
    }

    @Override
    public Iterator<PairOfObjectInt<K>> iterator() {
        return new Iterator<PairOfObjectInt<K>>(){
            private Iterator<MapKI.Entry<K>> iter;
            private final PairOfObjectInt<K> pair;
            {
                this.iter = Object2IntFrequencyDistributionEntry.this.counts.entrySet().iterator();
                this.pair = new PairOfObjectInt();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public PairOfObjectInt<K> next() {
                if (!this.hasNext()) {
                    return null;
                }
                MapKI.Entry entry = this.iter.next();
                this.pair.set((Comparable)entry.getKey(), entry.getValue());
                return this.pair;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public List<PairOfObjectInt<K>> getEntries(SortableEntries.Order ordering) {
        if (ordering.equals((Object)SortableEntries.Order.ByRightElementDescending)) {
            return this.getEntriesSorted(this.comparatorRightDescending);
        }
        if (ordering.equals((Object)SortableEntries.Order.ByLeftElementAscending)) {
            return this.getEntriesSorted(this.comparatorLeftAscending);
        }
        if (ordering.equals((Object)SortableEntries.Order.ByRightElementAscending)) {
            return this.getEntriesSorted(this.comparatorRightAscending);
        }
        if (ordering.equals((Object)SortableEntries.Order.ByLeftElementDescending)) {
            return this.getEntriesSorted(this.comparatorLeftDescending);
        }
        return null;
    }

    @Override
    public List<PairOfObjectInt<K>> getEntries(SortableEntries.Order ordering, int n) {
        if (ordering.equals((Object)SortableEntries.Order.ByRightElementDescending)) {
            return this.getEntriesSorted(this.comparatorRightDescending, n);
        }
        if (ordering.equals((Object)SortableEntries.Order.ByLeftElementAscending)) {
            return this.getEntriesSorted(this.comparatorLeftAscending, n);
        }
        if (ordering.equals((Object)SortableEntries.Order.ByRightElementAscending)) {
            return this.getEntriesSorted(this.comparatorRightAscending, n);
        }
        if (ordering.equals((Object)SortableEntries.Order.ByLeftElementDescending)) {
            return this.getEntriesSorted(this.comparatorLeftDescending, n);
        }
        return null;
    }

    private List<PairOfObjectInt<K>> getEntriesSorted(Comparator<PairOfObjectInt<K>> comparator) {
        ArrayList list = Lists.newArrayList();
        for (MapKI.Entry<K> e : this.counts.entrySet()) {
            list.add(new PairOfObjectInt<Comparable>((Comparable)e.getKey(), e.getValue()));
        }
        Collections.sort(list, comparator);
        return list;
    }

    private List<PairOfObjectInt<K>> getEntriesSorted(Comparator<PairOfObjectInt<K>> comparator, int n) {
        List<PairOfObjectInt<K>> list = this.getEntriesSorted(comparator);
        return list.subList(0, n);
    }
}

