/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.map;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import tl.lin.data.map.MapII;
import tl.lin.data.map.MapIV;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HMapIV<V>
implements MapIV<V>,
Cloneable,
Serializable {
    static final int DEFAULT_INITIAL_CAPACITY = 1024;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient Entry<V>[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    volatile transient int modCount;
    private transient Set<MapIV.Entry<V>> entrySet = null;
    volatile transient Set<Integer> keySet = null;
    volatile transient Collection<V> values = null;
    private static final long serialVersionUID = 362498820763181265L;

    public HMapIV(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
        this.init();
    }

    public HMapIV(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public HMapIV() {
        this.loadFactor = 0.75f;
        this.threshold = 768;
        this.table = new Entry[1024];
        this.init();
    }

    public HMapIV(MapIV<V> m) {
        this(Math.max((int)((float)m.size() / 0.75f) + 1, 1024), 0.75f);
        super.putAllForCreate(m);
    }

    void init() {
    }

    static int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V get(int key) {
        int hash = HMapIV.hash(key);
        Entry<V> e = this.table[HMapIV.indexFor(hash, this.table.length)];
        while (e != null) {
            int k;
            if (e.hash == hash && ((k = e.key) == key || key == k)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public boolean containsKey(int key) {
        return this.getEntry(key) != null;
    }

    final Entry<V> getEntry(int key) {
        int hash = HMapIV.hash(key);
        Entry<V> e = this.table[HMapIV.indexFor(hash, this.table.length)];
        while (e != null) {
            int k;
            if (e.hash == hash && ((k = e.key) == key || key == k)) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public V put(int key, V value) {
        int hash = HMapIV.hash(key);
        int i = HMapIV.indexFor(hash, this.table.length);
        Entry<V> e = this.table[i];
        while (e != null) {
            int k;
            if (e.hash == hash && ((k = e.key) == key || key == k)) {
                Object oldValue = e.value;
                e.value = value;
                e.recordAccess(this);
                return oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        this.addEntry(hash, key, value, i);
        return null;
    }

    private void putForCreate(int key, V value) {
        int hash = HMapIV.hash(key);
        int i = HMapIV.indexFor(hash, this.table.length);
        Entry<V> e = this.table[i];
        while (e != null) {
            int k;
            if (e.hash == hash && ((k = e.key) == key || key == k)) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        this.createEntry(hash, key, value, i);
    }

    private void putAllForCreate(MapIV<V> m) {
        for (MapIV.Entry<V> e : m.entrySet()) {
            this.putForCreate(e.getKey(), e.getValue());
        }
    }

    void resize(int newCapacity) {
        Entry<V>[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    void transfer(Entry<V>[] newTable) {
        Entry<V>[] src = this.table;
        int newCapacity = newTable.length;
        for (int j = 0; j < src.length; ++j) {
            Entry next;
            Entry<V> e = src[j];
            if (e == null) continue;
            src[j] = null;
            do {
                next = e.next;
                int i = HMapIV.indexFor(e.hash, newCapacity);
                e.next = newTable[i];
                newTable[i] = e;
            } while ((e = next) != null);
        }
    }

    @Override
    public void putAll(MapIV<V> m) {
        int numKeysToBeAdded = m.size();
        if (numKeysToBeAdded == 0) {
            return;
        }
        if (numKeysToBeAdded > this.threshold) {
            int newCapacity;
            int targetCapacity = (int)((float)numKeysToBeAdded / this.loadFactor + 1.0f);
            if (targetCapacity > 0x40000000) {
                targetCapacity = 0x40000000;
            }
            for (newCapacity = this.table.length; newCapacity < targetCapacity; newCapacity <<= 1) {
            }
            if (newCapacity > this.table.length) {
                this.resize(newCapacity);
            }
        }
        for (MapIV.Entry<V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(int key) {
        Entry<V> e = this.removeEntryForKey(key);
        if (e != null) {
            return e.value;
        }
        return null;
    }

    final Entry<V> removeEntryForKey(int key) {
        Entry<V> prev;
        int hash = HMapIV.hash(key);
        int i = HMapIV.indexFor(hash, this.table.length);
        Entry<V> e = prev = this.table[i];
        while (e != null) {
            int k;
            Entry next = e.next;
            if (e.hash == hash && ((k = e.key) == key || key == k)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                e.recordRemoval(this);
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    final Entry<V> removeMapping(Object o) {
        Entry<V> prev;
        MapII.Entry entry = (MapII.Entry)o;
        Integer key = entry.getKey();
        int hash = key == null ? 0 : HMapIV.hash(((Object)key).hashCode());
        int i = HMapIV.indexFor(hash, this.table.length);
        Entry<V> e = prev = this.table[i];
        while (e != null) {
            Entry next = e.next;
            if (e.hash == hash && e.equals(entry)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                e.recordRemoval(this);
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    @Override
    public void clear() {
        ++this.modCount;
        Entry<V>[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean containsValue(V value) {
        Entry<V>[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            Entry<V> e = tab[i];
            while (e != null) {
                if (value.equals(e)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public Object clone() {
        HMapIV result = null;
        try {
            result = (HMapIV)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        result.table = new Entry[this.table.length];
        result.entrySet = null;
        result.modCount = 0;
        result.size = 0;
        result.init();
        result.putAllForCreate(this);
        return result;
    }

    void addEntry(int hash, int key, V value, int bucketIndex) {
        Entry<V> e = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry<V>(hash, key, value, e);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int hash, int key, V value, int bucketIndex) {
        Entry<V> e = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry<V>(hash, key, value, e);
        ++this.size;
    }

    Iterator<Integer> newKeyIterator() {
        return new KeyIterator();
    }

    Iterator<V> newValueIterator() {
        return new ValueIterator();
    }

    Iterator<MapIV.Entry<V>> newEntryIterator() {
        return new EntryIterator();
    }

    @Override
    public Set<Integer> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set<MapIV.Entry<V>> entrySet() {
        return this.entrySet0();
    }

    private Set<MapIV.Entry<V>> entrySet0() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Iterator<MapIV.Entry<V>> i = this.size > 0 ? this.entrySet0().iterator() : null;
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.size);
        if (i != null) {
            while (i.hasNext()) {
                MapIV.Entry<V> e = i.next();
                s.writeInt(e.getKey());
                s.writeObject(e.getValue());
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numBuckets = s.readInt();
        this.table = new Entry[numBuckets];
        this.init();
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            int key = s.readInt();
            Object value = s.readObject();
            this.putForCreate(key, value);
        }
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    public String toString() {
        Iterator<MapIV.Entry<V>> i = this.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            MapIV.Entry<V> e = i.next();
            int key = e.getKey();
            V value = e.getValue();
            sb.append(key);
            sb.append('=');
            sb.append(value);
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(", ");
        }
    }

    public MapIV.Entry<V>[] getEntriesSortedByValue() {
        if (this.size() == 0) {
            return null;
        }
        Entry[] entries = new Entry[this.size()];
        int i = 0;
        Entry<V> next = null;
        int index = 0;
        while (index < this.table.length && (next = this.table[index++]) == null) {
        }
        while (next != null) {
            Entry<V> e = next;
            next = e.next;
            next = e.next;
            if (next == null) {
                while (index < this.table.length && (next = this.table[index++]) == null) {
                }
            }
            entries[i++] = e;
        }
        Arrays.sort(entries, new Comparator<MapIV.Entry<V>>(){

            @Override
            public int compare(MapIV.Entry<V> e1, MapIV.Entry<V> e2) {
                return ((Comparable)e1.getValue()).compareTo(e2.getValue());
            }
        });
        return entries;
    }

    public MapIV.Entry<V>[] getEntriesSortedByValue(int n) {
        MapIV.Entry<V>[] entries = this.getEntriesSortedByValue();
        if (entries == null) {
            return null;
        }
        if (entries.length < n) {
            return entries;
        }
        return Arrays.copyOfRange(entries, 0, n);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntrySet
    extends AbstractSet<MapIV.Entry<V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<MapIV.Entry<V>> iterator() {
            return HMapIV.this.newEntryIterator();
        }

        @Override
        public int size() {
            return HMapIV.this.size;
        }

        @Override
        public boolean contains(Object o) {
            MapIV.Entry e = (MapIV.Entry)o;
            Entry candidate = HMapIV.this.getEntry(e.getKey());
            return candidate != null && candidate.equals(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return HMapIV.this.newValueIterator();
        }

        @Override
        public int size() {
            return HMapIV.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return HMapIV.this.containsValue(o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeySet
    extends AbstractSet<Integer> {
        private KeySet() {
        }

        @Override
        public Iterator<Integer> iterator() {
            return HMapIV.this.newKeyIterator();
        }

        @Override
        public int size() {
            return HMapIV.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return HMapIV.this.containsKey((Integer)o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntryIterator
    extends HashIterator<MapIV.Entry<V>> {
        private EntryIterator() {
        }

        @Override
        public MapIV.Entry<V> next() {
            return this.nextEntry();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeyIterator
    extends HashIterator<Integer> {
        private KeyIterator() {
        }

        @Override
        public Integer next() {
            return this.nextEntry().getKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ValueIterator
    extends HashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class HashIterator<E>
    implements Iterator<E> {
        Entry<V> next;
        int expectedModCount;
        int index;
        Entry<V> current;

        HashIterator() {
            this.expectedModCount = HMapIV.this.modCount;
            if (HMapIV.this.size > 0) {
                Entry<V>[] t = HMapIV.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final Entry<V> nextEntry() {
            if (HMapIV.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.next = e.next;
            if (this.next == null) {
                Entry<V>[] t = HMapIV.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
            this.current = e;
            return e;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (HMapIV.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            int k = this.current.key;
            this.current = null;
            HMapIV.this.removeEntryForKey(k);
            this.expectedModCount = HMapIV.this.modCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Entry<V>
    implements MapIV.Entry<V> {
        final int key;
        V value;
        Entry<V> next;
        final int hash;

        Entry(int h, int k, V v, Entry<V> n) {
            this.value = v;
            this.next = n;
            this.key = k;
            this.hash = h;
        }

        @Override
        public final int getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            Object v2;
            V v1;
            int k2;
            MapIV.Entry e = (MapIV.Entry)o;
            int k1 = this.getKey();
            return k1 == (k2 = e.getKey()) && (v1 = this.getValue()).equals(v2 = e.getValue());
        }

        @Override
        public final int hashCode() {
            return this.key ^ this.value.hashCode();
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        void recordAccess(HMapIV<V> m) {
        }

        void recordRemoval(HMapIV<V> m) {
        }
    }
}

