/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.map;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import tl.lin.data.map.HMapKF;
import tl.lin.data.map.MapKF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HMapSFW
extends HMapKF<String>
implements Writable {
    private static final long serialVersionUID = 3804087604196020037L;

    public void readFields(DataInput in) throws IOException {
        this.clear();
        int numEntries = in.readInt();
        if (numEntries == 0) {
            return;
        }
        for (int i = 0; i < numEntries; ++i) {
            String k = in.readUTF();
            float v = in.readFloat();
            this.put(k, v);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.size() == 0) {
            return;
        }
        for (MapKF.Entry e : this.entrySet()) {
            out.writeUTF((String)e.getKey());
            out.writeFloat(e.getValue());
        }
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        this.write(dataOut);
        return bytesOut.toByteArray();
    }

    public static HMapSFW create(DataInput in) throws IOException {
        HMapSFW m = new HMapSFW();
        m.readFields(in);
        return m;
    }

    public static HMapSFW create(byte[] bytes) throws IOException {
        return HMapSFW.create(new DataInputStream(new ByteArrayInputStream(bytes)));
    }
}

