/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.pair;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PairOfStringInt
implements WritableComparable<PairOfStringInt> {
    private String leftElement;
    private int rightElement;

    public PairOfStringInt() {
    }

    public PairOfStringInt(String left, int right) {
        this.set(left, right);
    }

    public void readFields(DataInput in) throws IOException {
        this.leftElement = Text.readString((DataInput)in);
        this.rightElement = in.readInt();
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.leftElement);
        out.writeInt(this.rightElement);
    }

    public String getLeftElement() {
        return this.leftElement;
    }

    public int getRightElement() {
        return this.rightElement;
    }

    public String getKey() {
        return this.leftElement;
    }

    public int getValue() {
        return this.rightElement;
    }

    public void set(String left, int right) {
        this.leftElement = left;
        this.rightElement = right;
    }

    public boolean equals(Object obj) {
        PairOfStringInt pair = (PairOfStringInt)obj;
        return this.leftElement.equals(pair.getLeftElement()) && this.rightElement == pair.getRightElement();
    }

    public int compareTo(PairOfStringInt pair) {
        String pl = pair.getLeftElement();
        int pr = pair.getRightElement();
        if (this.leftElement.equals(pl)) {
            if (this.rightElement == pr) {
                return 0;
            }
            return this.rightElement < pr ? -1 : 1;
        }
        return this.leftElement.compareTo(pl);
    }

    public int hashCode() {
        return this.leftElement.hashCode() + this.rightElement;
    }

    public String toString() {
        return "(" + this.leftElement + ", " + this.rightElement + ")";
    }

    public PairOfStringInt clone() {
        return new PairOfStringInt(this.leftElement, this.rightElement);
    }

    static {
        WritableComparator.define(PairOfStringInt.class, (WritableComparator)new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(PairOfStringInt.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            try {
                int thatRightValue;
                int firstVIntL1 = WritableUtils.decodeVIntSize((byte)b1[s1]);
                int firstVIntL2 = WritableUtils.decodeVIntSize((byte)b2[s2]);
                int firstStrL1 = Comparator.readVInt((byte[])b1, (int)s1);
                int firstStrL2 = Comparator.readVInt((byte[])b2, (int)s2);
                int cmp = Comparator.compareBytes((byte[])b1, (int)(s1 + firstVIntL1), (int)firstStrL1, (byte[])b2, (int)(s2 + firstVIntL2), (int)firstStrL2);
                if (cmp != 0) {
                    return cmp;
                }
                int thisRightValue = Comparator.readInt((byte[])b1, (int)(s1 + firstVIntL1 + firstStrL1));
                return thisRightValue < (thatRightValue = Comparator.readInt((byte[])b2, (int)(s2 + firstVIntL2 + firstStrL2))) ? -1 : (thisRightValue == thatRightValue ? 0 : 1);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

