/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.queue;

import org.apache.hadoop.util.PriorityQueue;
import tl.lin.data.pair.PairOfObjectFloat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopScoredObjects<K extends Comparable<K>> {
    private final ScoredObjectPriorityQueue queue;

    public TopScoredObjects(int n) {
        this.queue = new ScoredObjectPriorityQueue(n);
    }

    public void add(K obj, float f) {
        this.queue.insert(new PairOfObjectFloat<K>(obj, f));
    }

    public PairOfObjectFloat<K>[] extractAll() {
        int len = this.queue.size();
        PairOfObjectFloat[] arr = new PairOfObjectFloat[len];
        for (int i = 0; i < len; ++i) {
            arr[len - 1 - i] = (PairOfObjectFloat)this.queue.pop();
        }
        return arr;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ScoredObjectPriorityQueue
    extends PriorityQueue<PairOfObjectFloat<K>> {
        private ScoredObjectPriorityQueue(int maxSize) {
            super.initialize(maxSize);
        }

        protected boolean lessThan(Object obj0, Object obj1) {
            return ((PairOfObjectFloat)obj0).getRightElement() < ((PairOfObjectFloat)obj1).getRightElement();
        }
    }
}

