/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.array;

import java.util.Random;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import tl.lin.data.array.ArrayListOfInts;

public class ArrayListOfIntsTest {
    int neg_one = -1;
    int zero = 0;
    int one = 1;
    int two = 2;
    int three = 3;
    int four = 4;
    int five = 5;
    int six = 6;
    int seven = 7;
    int nine = 9;

    @org.junit.Test
    public void testRemoveWithinBounds() {
        ArrayListOfInts a = new ArrayListOfInts();
        a.add(this.one).add(this.three).add(this.five).add(this.seven);
        Assert.assertTrue((this.one == a.remove(0) ? 1 : 0) != 0);
        Assert.assertTrue((this.three == a.get(0) ? 1 : 0) != 0);
        Assert.assertTrue((this.five == a.get(1) ? 1 : 0) != 0);
        Assert.assertTrue((this.five == a.remove(1) ? 1 : 0) != 0);
        Assert.assertTrue((this.seven == a.get(2) ? 1 : 0) != 0);
    }

    @org.junit.Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testRemoveOutOfBounds() {
        ArrayListOfInts a = new ArrayListOfInts();
        a.add(this.one).add(this.three).add(this.five).add(this.seven);
        a.remove(4);
    }

    @org.junit.Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testRemoveOutOfBounds2() {
        ArrayListOfInts a = new ArrayListOfInts();
        a.add(this.neg_one);
        a.remove(-1);
    }

    @org.junit.Test
    public void testBasic1() {
        int i;
        int size = 100000;
        Random r = new Random();
        int[] ints = new int[size];
        ArrayListOfInts list = new ArrayListOfInts();
        for (i = 0; i < size; ++i) {
            int k = r.nextInt(size);
            list.add(k);
            ints[i] = k;
        }
        for (i = 0; i < size; ++i) {
            int v = list.get(i);
            Assert.assertEquals((long)ints[i], (long)v);
        }
    }

    @org.junit.Test
    public void testArrayConstructor() {
        int[] arr = new int[]{1, 2, 3, 4, 5};
        Assert.assertEquals((long)5L, (long)arr.length);
        ArrayListOfInts list = new ArrayListOfInts(arr);
        list.remove(2);
        Assert.assertEquals((long)1L, (long)arr[0]);
        Assert.assertEquals((long)2L, (long)arr[1]);
        Assert.assertEquals((long)3L, (long)arr[2]);
        Assert.assertEquals((long)4L, (long)arr[3]);
        Assert.assertEquals((long)5L, (long)arr[4]);
    }

    @org.junit.Test
    public void testRemove() {
        ArrayListOfInts list = new ArrayListOfInts();
        for (int i = 0; i < 10; ++i) {
            list.add(i);
        }
        list.remove(list.indexOf(5));
        Assert.assertEquals((long)9L, (long)list.size());
        Assert.assertEquals((long)0L, (long)list.get(0));
        Assert.assertEquals((long)1L, (long)list.get(1));
        Assert.assertEquals((long)2L, (long)list.get(2));
        Assert.assertEquals((long)3L, (long)list.get(3));
        Assert.assertEquals((long)4L, (long)list.get(4));
        Assert.assertEquals((long)6L, (long)list.get(5));
        Assert.assertEquals((long)7L, (long)list.get(6));
        Assert.assertEquals((long)8L, (long)list.get(7));
        Assert.assertEquals((long)9L, (long)list.get(8));
        list.remove(list.indexOf(9));
        Assert.assertEquals((long)8L, (long)list.size());
        Assert.assertEquals((long)0L, (long)list.get(0));
        Assert.assertEquals((long)1L, (long)list.get(1));
        Assert.assertEquals((long)2L, (long)list.get(2));
        Assert.assertEquals((long)3L, (long)list.get(3));
        Assert.assertEquals((long)4L, (long)list.get(4));
        Assert.assertEquals((long)6L, (long)list.get(5));
        Assert.assertEquals((long)7L, (long)list.get(6));
        Assert.assertEquals((long)8L, (long)list.get(7));
    }

    @org.junit.Test
    public void testUpdate() {
        int i;
        int size = 100000;
        Random r = new Random();
        int[] ints = new int[size];
        ArrayListOfInts list = new ArrayListOfInts();
        for (i = 0; i < size; ++i) {
            int k = r.nextInt(size);
            list.add(k);
            ints[i] = k;
        }
        Assert.assertEquals((long)size, (long)list.size());
        for (i = 0; i < size; ++i) {
            list.set(i, ints[i] + 1);
        }
        Assert.assertEquals((long)size, (long)list.size());
        for (i = 0; i < size; ++i) {
            int v = list.get(i);
            Assert.assertEquals((long)(ints[i] + 1), (long)v);
        }
    }

    @org.junit.Test
    public void testTrim1() {
        int i;
        int size = 89;
        Random r = new Random();
        int[] ints = new int[size];
        ArrayListOfInts list = new ArrayListOfInts();
        for (i = 0; i < size; ++i) {
            int k = r.nextInt(size);
            list.add(k);
            ints[i] = k;
        }
        for (i = 0; i < size; ++i) {
            int v = list.get(i);
            Assert.assertEquals((long)ints[i], (long)v);
        }
        int[] rawArray = list.getArray();
        int lenBefore = rawArray.length;
        list.trimToSize();
        int[] rawArrayAfter = list.getArray();
        int lenAfter = rawArrayAfter.length;
        Assert.assertEquals((long)89L, (long)lenAfter);
        Assert.assertTrue((lenBefore > lenAfter ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testClone() {
        int i;
        int size = 100000;
        Random r = new Random();
        int[] ints = new int[size];
        ArrayListOfInts list1 = new ArrayListOfInts();
        for (int i2 = 0; i2 < size; ++i2) {
            int k = r.nextInt(size);
            list1.add(k);
            ints[i2] = k;
        }
        ArrayListOfInts list2 = list1.clone();
        Assert.assertEquals((long)size, (long)list1.size());
        Assert.assertEquals((long)size, (long)list2.size());
        for (i = 0; i < size; ++i) {
            list2.set(i, ints[i] + 1);
        }
        Assert.assertEquals((long)size, (long)list1.size());
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((long)ints[i], (long)list1.get(i));
        }
        Assert.assertEquals((long)size, (long)list1.size());
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((long)(ints[i] + 1), (long)list2.get(i));
        }
    }

    @org.junit.Test
    public void testToString1() {
        Assert.assertEquals((Object)"[1, 2, 3, 4, 5, 6, 7, 8, 9, 10]", (Object)new ArrayListOfInts(1, 11).toString());
        Assert.assertEquals((Object)"[1, 2, 3, 4, 5 ... (5 more) ]", (Object)new ArrayListOfInts(1, 11).toString(5));
        Assert.assertEquals((Object)"[1, 2, 3, 4, 5]", (Object)new ArrayListOfInts(1, 6).toString());
        Assert.assertEquals((Object)"[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11]", (Object)new ArrayListOfInts(1, 12).toString(11));
        Assert.assertEquals((Object)"[]", (Object)new ArrayListOfInts().toString());
    }

    @org.junit.Test
    public void testToString2() {
        int v;
        int i;
        int size = 10;
        Random r = new Random();
        ArrayListOfInts list = new ArrayListOfInts();
        for (int i2 = 0; i2 < size; ++i2) {
            list.add(r.nextInt(100000));
        }
        String out = list.toString();
        for (i = 0; i < size; ++i) {
            v = list.get(i);
            Assert.assertTrue((out.indexOf(new Integer(v).toString()) != -1 ? 1 : 0) != 0);
        }
        for (i = 0; i < size; ++i) {
            list.add(r.nextInt(100000));
        }
        out = list.toString();
        for (i = size; i < size + size; ++i) {
            v = list.get(i);
            Assert.assertTrue((out.indexOf(new Integer(v).toString()) == -1 ? 1 : 0) != 0);
        }
        Assert.assertTrue((out.indexOf(size + " more") != -1 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testIterable() {
        int i;
        int size = 1000;
        Random r = new Random();
        int[] ints = new int[size];
        ArrayListOfInts list = new ArrayListOfInts();
        for (i = 0; i < size; ++i) {
            int k = r.nextInt(size);
            list.add(k);
            ints[i] = k;
        }
        i = 0;
        for (Integer v : list) {
            Assert.assertEquals((long)ints[i++], (long)v.intValue());
        }
    }

    @org.junit.Test
    public void testSetSize() {
        ArrayListOfInts list = new ArrayListOfInts();
        list.add(5);
        Assert.assertEquals((long)1L, (long)list.size);
        Assert.assertEquals((long)5L, (long)list.get(0));
        list.setSize(5);
        Assert.assertEquals((long)5L, (long)list.size);
        Assert.assertEquals((long)0L, (long)list.get(1));
        Assert.assertEquals((long)0L, (long)list.get(2));
        Assert.assertEquals((long)0L, (long)list.get(3));
        Assert.assertEquals((long)0L, (long)list.get(4));
        list.add(12);
        Assert.assertEquals((long)6L, (long)list.size);
        Assert.assertEquals((long)12L, (long)list.get(5));
    }

    @org.junit.Test
    public void testSort() {
        ArrayListOfInts a = new ArrayListOfInts();
        Assert.assertEquals((long)0L, (long)a.size());
        a.add(5).add(6).add(1).add(4);
        Assert.assertEquals((long)4L, (long)a.size());
        a.sort();
        Assert.assertEquals((long)4L, (long)a.size());
        Assert.assertEquals((long)1L, (long)a.get(0));
        Assert.assertEquals((long)4L, (long)a.get(1));
        Assert.assertEquals((long)5L, (long)a.get(2));
        Assert.assertEquals((long)6L, (long)a.get(3));
    }

    @org.junit.Test
    public void testIntersection1() {
        ArrayListOfInts a = new ArrayListOfInts();
        a.add(5).add(3).add(1);
        a.sort();
        ArrayListOfInts b = new ArrayListOfInts();
        b.add(0).add(1).add(2).add(3);
        ArrayListOfInts c = a.intersection(b);
        Assert.assertEquals((long)1L, (long)c.get(0));
        Assert.assertEquals((long)3L, (long)c.get(1));
        Assert.assertEquals((long)2L, (long)c.size());
    }

    @org.junit.Test
    public void testIntersection2() {
        ArrayListOfInts a = new ArrayListOfInts();
        a.add(5);
        ArrayListOfInts b = new ArrayListOfInts();
        b.add(0).add(1).add(2).add(3);
        ArrayListOfInts c = a.intersection(b);
        Assert.assertTrue((c.size() == 0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testIntersection3() {
        ArrayListOfInts a = new ArrayListOfInts();
        a.add(3).add(5).add(7).add(8).add(9);
        ArrayListOfInts b = new ArrayListOfInts();
        b.add(0).add(1).add(2).add(3);
        ArrayListOfInts c = a.intersection(b);
        Assert.assertEquals((long)3L, (long)c.get(0));
        Assert.assertEquals((long)1L, (long)c.size());
    }

    @org.junit.Test
    public void testMerge1() {
        ArrayListOfInts a = new ArrayListOfInts();
        a.add(3);
        a.add(7);
        a.add(10);
        ArrayListOfInts b = new ArrayListOfInts();
        b.add(0);
        b.add(4);
        b.add(9);
        ArrayListOfInts c = a.merge(b);
        Assert.assertEquals((long)6L, (long)c.size());
        Assert.assertEquals((long)0L, (long)c.get(0));
        Assert.assertEquals((long)3L, (long)c.get(1));
        Assert.assertEquals((long)4L, (long)c.get(2));
        Assert.assertEquals((long)7L, (long)c.get(3));
        Assert.assertEquals((long)9L, (long)c.get(4));
        Assert.assertEquals((long)10L, (long)c.get(5));
        ArrayListOfInts c2 = b.merge(a);
        Assert.assertEquals((Object)c, (Object)c2);
    }

    @org.junit.Test
    public void testMerge2() {
        ArrayListOfInts a = new ArrayListOfInts();
        a.add(3);
        a.add(7);
        a.add(10);
        ArrayListOfInts b = new ArrayListOfInts();
        b.add(11);
        b.add(19);
        b.add(21);
        ArrayListOfInts c = a.merge(b);
        Assert.assertEquals((long)6L, (long)c.size());
        Assert.assertEquals((long)3L, (long)c.get(0));
        Assert.assertEquals((long)7L, (long)c.get(1));
        Assert.assertEquals((long)10L, (long)c.get(2));
        Assert.assertEquals((long)11L, (long)c.get(3));
        Assert.assertEquals((long)19L, (long)c.get(4));
        Assert.assertEquals((long)21L, (long)c.get(5));
        ArrayListOfInts c2 = b.merge(a);
        Assert.assertEquals((Object)c, (Object)c2);
    }

    @org.junit.Test
    public void testMerge3() {
        ArrayListOfInts a = new ArrayListOfInts();
        a.add(3);
        a.add(7);
        a.add(10);
        ArrayListOfInts b = new ArrayListOfInts();
        ArrayListOfInts c = a.merge(b);
        Assert.assertEquals((Object)c, (Object)a);
        ArrayListOfInts c2 = b.merge(a);
        Assert.assertEquals((Object)c, (Object)c2);
    }

    @org.junit.Test
    public void testMerge4() {
        ArrayListOfInts a = new ArrayListOfInts();
        a.add(3);
        a.add(7);
        a.add(10);
        ArrayListOfInts b = new ArrayListOfInts();
        b.add(7);
        b.add(8);
        ArrayListOfInts c = a.merge(b);
        Assert.assertEquals((long)c.size(), (long)5L);
        Assert.assertEquals((long)c.get(0), (long)3L);
        Assert.assertEquals((long)c.get(1), (long)7L);
        Assert.assertEquals((long)c.get(2), (long)7L);
        Assert.assertEquals((long)c.get(3), (long)8L);
        Assert.assertEquals((long)c.get(4), (long)10L);
        ArrayListOfInts cNoDups = a.mergeNoDuplicates(b);
        Assert.assertEquals((long)cNoDups.size(), (long)4L);
        Assert.assertEquals((long)cNoDups.get(0), (long)3L);
        Assert.assertEquals((long)cNoDups.get(1), (long)7L);
        Assert.assertEquals((long)cNoDups.get(2), (long)8L);
        Assert.assertEquals((long)cNoDups.get(3), (long)10L);
    }

    @org.junit.Test
    public void testMerge5() {
        ArrayListOfInts a = new ArrayListOfInts();
        a.add(3);
        a.add(7);
        a.add(10);
        ArrayListOfInts b = new ArrayListOfInts();
        b.add(7);
        ArrayListOfInts c = a.merge(b);
        Assert.assertEquals((long)c.size(), (long)4L);
        Assert.assertEquals((long)c.get(0), (long)3L);
        Assert.assertEquals((long)c.get(1), (long)7L);
        Assert.assertEquals((long)c.get(2), (long)7L);
        Assert.assertEquals((long)c.get(3), (long)10L);
        ArrayListOfInts cNoDups = a.mergeNoDuplicates(b);
        Assert.assertEquals((long)cNoDups.size(), (long)3L);
        Assert.assertEquals((long)cNoDups.get(0), (long)3L);
        Assert.assertEquals((long)cNoDups.get(1), (long)7L);
        Assert.assertEquals((long)cNoDups.get(2), (long)10L);
    }

    @org.junit.Test
    public void testSubList() {
        ArrayListOfInts a = new ArrayListOfInts(new int[]{1, 2, 3, 4, 5, 6, 7});
        ArrayListOfInts b = a.subList(1, 5);
        Assert.assertEquals((long)5L, (long)b.size());
        Assert.assertEquals((long)2L, (long)b.get(0));
        Assert.assertEquals((long)3L, (long)b.get(1));
        Assert.assertEquals((long)4L, (long)b.get(2));
        Assert.assertEquals((long)5L, (long)b.get(3));
        Assert.assertEquals((long)6L, (long)b.get(4));
        a.clear();
        Assert.assertEquals((long)5L, (long)b.size());
        Assert.assertEquals((long)2L, (long)b.get(0));
        Assert.assertEquals((long)3L, (long)b.get(1));
        Assert.assertEquals((long)4L, (long)b.get(2));
        Assert.assertEquals((long)5L, (long)b.get(3));
        Assert.assertEquals((long)6L, (long)b.get(4));
    }

    @org.junit.Test
    public void testAddUnique() {
        ArrayListOfInts a = new ArrayListOfInts(new int[]{1, 2, 3, 4, 5, 6, 7});
        a.addUnique(new int[]{8, 0, 2, 5, -1, 11, 9});
        Assert.assertEquals((long)12L, (long)a.size());
        Assert.assertEquals((long)0L, (long)a.get(8));
        Assert.assertEquals((long)-1L, (long)a.get(9));
        Assert.assertEquals((long)11L, (long)a.get(10));
        Assert.assertEquals((long)9L, (long)a.get(11));
    }

    @org.junit.Test
    public void testShift() {
        int i;
        int size = 100;
        int shift = 10;
        ArrayListOfInts list = new ArrayListOfInts();
        for (i = 0; i < size; ++i) {
            list.add(i);
        }
        list.shiftLastNToTop(shift);
        for (i = 0; i < list.size(); ++i) {
            Assert.assertEquals((long)(size - shift + i), (long)list.get(i));
        }
        list.add(size);
        Assert.assertEquals((long)(shift + 1), (long)list.size());
        Assert.assertEquals((long)size, (long)list.get(shift));
    }

    public static Test suite() {
        return new JUnit4TestAdapter(ArrayListOfIntsTest.class);
    }
}

