/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.array;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import tl.lin.data.array.DoubleArrayWritable;

public class DoubleArrayWritableTest {
    @org.junit.Test
    public void testBasic1() throws IOException {
        DoubleArrayWritable array1 = new DoubleArrayWritable(new double[]{1.0, 3.0, 53.0, 97.0, 286.0});
        Assert.assertEquals((double)1.0, (double)array1.get(0), (double)1.0E-5);
        Assert.assertEquals((double)3.0, (double)array1.get(1), (double)1.0E-5);
        Assert.assertEquals((double)53.0, (double)array1.get(2), (double)1.0E-5);
        Assert.assertEquals((double)97.0, (double)array1.get(3), (double)1.0E-5);
        Assert.assertEquals((double)286.0, (double)array1.get(4), (double)1.0E-5);
        Assert.assertEquals((long)5L, (long)array1.size());
        DoubleArrayWritable array2 = new DoubleArrayWritable(new double[]{1.0, 3.0, 53.0, 97.0, 286.0}, 3);
        Assert.assertEquals((double)1.0, (double)array2.get(0), (double)1.0E-5);
        Assert.assertEquals((double)3.0, (double)array2.get(1), (double)1.0E-5);
        Assert.assertEquals((double)53.0, (double)array2.get(2), (double)1.0E-5);
        Assert.assertEquals((long)3L, (long)array2.size());
        DoubleArrayWritable array3 = new DoubleArrayWritable(new double[0]);
        Assert.assertEquals((long)0L, (long)array3.size());
    }

    @org.junit.Test
    public void testBasic2() throws IOException {
        DoubleArrayWritable array = new DoubleArrayWritable();
        Assert.assertEquals((long)0L, (long)array.size());
        double[] list1 = new double[]{1.0, 3.0, 53.0, 97.0, 286.0};
        array.setArray(list1);
        Assert.assertEquals((double)1.0, (double)array.get(0), (double)1.0E-5);
        Assert.assertEquals((double)3.0, (double)array.get(1), (double)1.0E-5);
        Assert.assertEquals((double)53.0, (double)array.get(2), (double)1.0E-5);
        Assert.assertEquals((double)97.0, (double)array.get(3), (double)1.0E-5);
        Assert.assertEquals((double)286.0, (double)array.get(4), (double)1.0E-5);
        Assert.assertEquals((long)list1.length, (long)array.size());
        array.set(0, 2.0);
        array.set(3, -5.0);
        Assert.assertEquals((double)2.0, (double)array.get(0), (double)1.0E-5);
        Assert.assertEquals((double)-5.0, (double)array.get(3), (double)1.0E-5);
        double[] list2 = new double[]{9.0, -1.0, 6.0, 22.0, 76.0};
        array.setArray(list2, 3);
        Assert.assertEquals((double)9.0, (double)array.get(0), (double)1.0E-5);
        Assert.assertEquals((double)-1.0, (double)array.get(1), (double)1.0E-5);
        Assert.assertEquals((double)6.0, (double)array.get(2), (double)1.0E-5);
        Assert.assertEquals((long)3L, (long)array.size());
        array.setArray(null);
        Assert.assertEquals((long)0L, (long)array.size());
        Assert.assertEquals((long)0L, (long)array.getArray().length);
    }

    @org.junit.Test
    public void testSerialize1() throws IOException {
        DoubleArrayWritable array = new DoubleArrayWritable(new double[]{1.0, 3.0, 53.0, 97.0, 286.0});
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        array.write((DataOutput)dataOut);
        DoubleArrayWritable array2 = new DoubleArrayWritable();
        array2.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((long)5L, (long)array2.size());
        Assert.assertEquals((double)1.0, (double)array2.get(0), (double)1.0E-5);
        Assert.assertEquals((double)3.0, (double)array2.get(1), (double)1.0E-5);
        Assert.assertEquals((double)53.0, (double)array2.get(2), (double)1.0E-5);
        Assert.assertEquals((double)97.0, (double)array2.get(3), (double)1.0E-5);
        Assert.assertEquals((double)286.0, (double)array2.get(4), (double)1.0E-5);
    }

    @org.junit.Test
    public void testSerialize2() throws IOException {
        DoubleArrayWritable array = new DoubleArrayWritable(new double[]{1.0, 3.0, 53.0, 97.0, 286.0}, 4);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        array.write((DataOutput)dataOut);
        DoubleArrayWritable array2 = new DoubleArrayWritable();
        array2.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((long)4L, (long)array2.size());
        Assert.assertEquals((double)1.0, (double)array2.get(0), (double)1.0E-5);
        Assert.assertEquals((double)3.0, (double)array2.get(1), (double)1.0E-5);
        Assert.assertEquals((double)53.0, (double)array2.get(2), (double)1.0E-5);
        Assert.assertEquals((double)97.0, (double)array2.get(3), (double)1.0E-5);
    }

    @org.junit.Test
    public void testSerialize3() throws IOException {
        DoubleArrayWritable array = new DoubleArrayWritable(new double[]{1.0, 2.0, 3.0, 4.0, 5.0});
        ByteArrayOutputStream bytesOut1 = new ByteArrayOutputStream();
        DataOutputStream dataOut1 = new DataOutputStream(bytesOut1);
        array.write((DataOutput)dataOut1);
        DoubleArrayWritable array2 = new DoubleArrayWritable();
        array2.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut1.toByteArray())));
        Assert.assertEquals((long)5L, (long)array2.size());
        Assert.assertEquals((double)1.0, (double)array2.get(0), (double)1.0E-5);
        Assert.assertEquals((double)2.0, (double)array2.get(1), (double)1.0E-5);
        Assert.assertEquals((double)3.0, (double)array2.get(2), (double)1.0E-5);
        Assert.assertEquals((double)4.0, (double)array2.get(3), (double)1.0E-5);
        Assert.assertEquals((double)5.0, (double)array2.get(4), (double)1.0E-5);
        array.setArray(new double[]{6.0, 7.0});
        ByteArrayOutputStream bytesOut2 = new ByteArrayOutputStream();
        DataOutputStream dataOut2 = new DataOutputStream(bytesOut2);
        array.write((DataOutput)dataOut2);
        DoubleArrayWritable array3 = new DoubleArrayWritable();
        array3.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut2.toByteArray())));
        Assert.assertEquals((long)2L, (long)array3.size());
        Assert.assertEquals((double)6.0, (double)array3.get(0), (double)1.0E-5);
        Assert.assertEquals((double)7.0, (double)array3.get(1), (double)1.0E-5);
    }

    @org.junit.Test
    public void testSerializeEmpty() throws IOException {
        DoubleArrayWritable array = new DoubleArrayWritable();
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        array.write((DataOutput)dataOut);
        DoubleArrayWritable array2 = new DoubleArrayWritable();
        array2.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((long)0L, (long)array2.size());
        Assert.assertTrue((array2.getArray() != null ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)array2.getArray().length);
    }

    @org.junit.Test
    public void testClone1() throws IOException {
        DoubleArrayWritable array = new DoubleArrayWritable(new double[]{1.0, 3.0, 53.0, 97.0, 286.0});
        Assert.assertEquals((double)1.0, (double)array.get(0), (double)1.0E-5);
        Assert.assertEquals((double)3.0, (double)array.get(1), (double)1.0E-5);
        Assert.assertEquals((double)53.0, (double)array.get(2), (double)1.0E-5);
        Assert.assertEquals((double)97.0, (double)array.get(3), (double)1.0E-5);
        Assert.assertEquals((double)286.0, (double)array.get(4), (double)1.0E-5);
        Assert.assertEquals((long)5L, (long)array.size());
        double[] p = array.getClone();
        p[0] = 8.0;
        p[1] = 7.0;
        p[2] = -4.0;
        Assert.assertEquals((double)1.0, (double)array.get(0), (double)1.0E-5);
        Assert.assertEquals((double)3.0, (double)array.get(1), (double)1.0E-5);
        Assert.assertEquals((double)53.0, (double)array.get(2), (double)1.0E-5);
        Assert.assertEquals((long)5L, (long)array.size());
    }

    @org.junit.Test
    public void testClone2() throws IOException {
        DoubleArrayWritable array = new DoubleArrayWritable(new double[]{1.0, 3.0, 53.0, 97.0, 286.0}, 2);
        Assert.assertEquals((double)1.0, (double)array.get(0), (double)1.0E-5);
        Assert.assertEquals((double)3.0, (double)array.get(1), (double)1.0E-5);
        Assert.assertEquals((long)2L, (long)array.size());
        double[] p = array.getClone();
        Assert.assertEquals((long)2L, (long)p.length);
        p[0] = 8.0;
        p[1] = 7.0;
        Assert.assertEquals((double)1.0, (double)array.get(0), (double)1.0E-5);
        Assert.assertEquals((double)3.0, (double)array.get(1), (double)1.0E-5);
        Assert.assertEquals((long)2L, (long)array.size());
    }

    public static Test suite() {
        return new JUnit4TestAdapter(DoubleArrayWritableTest.class);
    }
}

