/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.array;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import tl.lin.data.array.FloatArrayWritable;

public class FloatArrayWritableTest {
    @org.junit.Test
    public void testBasic1() throws IOException {
        FloatArrayWritable array1 = new FloatArrayWritable(new float[]{1.0f, 3.0f, 53.0f, 97.0f, 286.0f});
        Assert.assertEquals((double)1.0, (double)array1.get(0), (double)1.0E-5);
        Assert.assertEquals((double)3.0, (double)array1.get(1), (double)1.0E-5);
        Assert.assertEquals((double)53.0, (double)array1.get(2), (double)1.0E-5);
        Assert.assertEquals((double)97.0, (double)array1.get(3), (double)1.0E-5);
        Assert.assertEquals((double)286.0, (double)array1.get(4), (double)1.0E-5);
        Assert.assertEquals((long)5L, (long)array1.size());
        FloatArrayWritable array2 = new FloatArrayWritable(new float[]{1.0f, 3.0f, 53.0f, 97.0f, 286.0f}, 3);
        Assert.assertEquals((double)1.0, (double)array2.get(0), (double)1.0E-5);
        Assert.assertEquals((double)3.0, (double)array2.get(1), (double)1.0E-5);
        Assert.assertEquals((double)53.0, (double)array2.get(2), (double)1.0E-5);
        Assert.assertEquals((long)3L, (long)array2.size());
        FloatArrayWritable array3 = new FloatArrayWritable(new float[0]);
        Assert.assertEquals((long)0L, (long)array3.size());
    }

    @org.junit.Test
    public void testBasic2() throws IOException {
        FloatArrayWritable array = new FloatArrayWritable();
        Assert.assertEquals((long)0L, (long)array.size());
        float[] list1 = new float[]{1.0f, 3.0f, 53.0f, 97.0f, 286.0f};
        array.setArray(list1);
        Assert.assertEquals((double)1.0, (double)array.get(0), (double)1.0E-5);
        Assert.assertEquals((double)3.0, (double)array.get(1), (double)1.0E-5);
        Assert.assertEquals((double)53.0, (double)array.get(2), (double)1.0E-5);
        Assert.assertEquals((double)97.0, (double)array.get(3), (double)1.0E-5);
        Assert.assertEquals((double)286.0, (double)array.get(4), (double)1.0E-5);
        Assert.assertEquals((long)list1.length, (long)array.size());
        array.set(0, 2.0f);
        array.set(3, -5.0f);
        Assert.assertEquals((double)2.0, (double)array.get(0), (double)1.0E-5);
        Assert.assertEquals((double)-5.0, (double)array.get(3), (double)1.0E-5);
        float[] list2 = new float[]{9.0f, -1.0f, 6.0f, 22.0f, 76.0f};
        array.setArray(list2, 3);
        Assert.assertEquals((double)9.0, (double)array.get(0), (double)1.0E-5);
        Assert.assertEquals((double)-1.0, (double)array.get(1), (double)1.0E-5);
        Assert.assertEquals((double)6.0, (double)array.get(2), (double)1.0E-5);
        Assert.assertEquals((double)3.0, (double)array.size(), (double)1.0E-5);
        array.setArray(null);
        Assert.assertEquals((long)0L, (long)array.size());
        Assert.assertEquals((long)0L, (long)array.getArray().length);
    }

    @org.junit.Test
    public void testSerialize1() throws IOException {
        FloatArrayWritable array = new FloatArrayWritable(new float[]{1.0f, 3.0f, 53.0f, 97.0f, 286.0f});
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        array.write((DataOutput)dataOut);
        FloatArrayWritable array2 = new FloatArrayWritable();
        array2.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((double)5.0, (double)array2.size(), (double)1.0E-5);
        Assert.assertEquals((double)1.0, (double)array2.get(0), (double)1.0E-5);
        Assert.assertEquals((double)3.0, (double)array2.get(1), (double)1.0E-5);
        Assert.assertEquals((double)53.0, (double)array2.get(2), (double)1.0E-5);
        Assert.assertEquals((double)97.0, (double)array2.get(3), (double)1.0E-5);
        Assert.assertEquals((double)286.0, (double)array2.get(4), (double)1.0E-5);
    }

    @org.junit.Test
    public void testSerialize2() throws IOException {
        FloatArrayWritable array = new FloatArrayWritable(new float[]{1.0f, 3.0f, 53.0f, 97.0f, 286.0f}, 4);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        array.write((DataOutput)dataOut);
        FloatArrayWritable array2 = new FloatArrayWritable();
        array2.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((long)4L, (long)array2.size());
        Assert.assertEquals((double)1.0, (double)array2.get(0), (double)1.0E-5);
        Assert.assertEquals((double)3.0, (double)array2.get(1), (double)1.0E-5);
        Assert.assertEquals((double)53.0, (double)array2.get(2), (double)1.0E-5);
        Assert.assertEquals((double)97.0, (double)array2.get(3), (double)1.0E-5);
    }

    @org.junit.Test
    public void testSerialize3() throws IOException {
        FloatArrayWritable array = new FloatArrayWritable(new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f});
        ByteArrayOutputStream bytesOut1 = new ByteArrayOutputStream();
        DataOutputStream dataOut1 = new DataOutputStream(bytesOut1);
        array.write((DataOutput)dataOut1);
        FloatArrayWritable array2 = new FloatArrayWritable();
        array2.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut1.toByteArray())));
        Assert.assertEquals((long)5L, (long)array2.size());
        Assert.assertEquals((double)1.0, (double)array2.get(0), (double)1.0E-5);
        Assert.assertEquals((double)2.0, (double)array2.get(1), (double)1.0E-5);
        Assert.assertEquals((double)3.0, (double)array2.get(2), (double)1.0E-5);
        Assert.assertEquals((double)4.0, (double)array2.get(3), (double)1.0E-5);
        Assert.assertEquals((double)5.0, (double)array2.get(4), (double)1.0E-5);
        array.setArray(new float[]{6.0f, 7.0f});
        ByteArrayOutputStream bytesOut2 = new ByteArrayOutputStream();
        DataOutputStream dataOut2 = new DataOutputStream(bytesOut2);
        array.write((DataOutput)dataOut2);
        FloatArrayWritable array3 = new FloatArrayWritable();
        array3.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut2.toByteArray())));
        Assert.assertEquals((long)2L, (long)array3.size());
        Assert.assertEquals((double)6.0, (double)array3.get(0), (double)1.0E-5);
        Assert.assertEquals((double)7.0, (double)array3.get(1), (double)1.0E-5);
    }

    @org.junit.Test
    public void testSerializeEmpty() throws IOException {
        FloatArrayWritable array = new FloatArrayWritable();
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        array.write((DataOutput)dataOut);
        FloatArrayWritable array2 = new FloatArrayWritable();
        array2.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((long)0L, (long)array2.size());
        Assert.assertTrue((array2.getArray() != null ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)array2.getArray().length);
    }

    @org.junit.Test
    public void testClone1() throws IOException {
        FloatArrayWritable array = new FloatArrayWritable(new float[]{1.0f, 3.0f, 53.0f, 97.0f, 286.0f});
        Assert.assertEquals((double)1.0, (double)array.get(0), (double)1.0E-5);
        Assert.assertEquals((double)3.0, (double)array.get(1), (double)1.0E-5);
        Assert.assertEquals((double)53.0, (double)array.get(2), (double)1.0E-5);
        Assert.assertEquals((double)97.0, (double)array.get(3), (double)1.0E-5);
        Assert.assertEquals((double)286.0, (double)array.get(4), (double)1.0E-5);
        Assert.assertEquals((long)5L, (long)array.size());
        float[] p = array.getClone();
        p[0] = 8.0f;
        p[1] = 7.0f;
        p[2] = -4.0f;
        Assert.assertEquals((double)1.0, (double)array.get(0), (double)1.0E-5);
        Assert.assertEquals((double)3.0, (double)array.get(1), (double)1.0E-5);
        Assert.assertEquals((double)53.0, (double)array.get(2), (double)1.0E-5);
        Assert.assertEquals((long)5L, (long)array.size());
    }

    @org.junit.Test
    public void testClone2() throws IOException {
        FloatArrayWritable array = new FloatArrayWritable(new float[]{1.0f, 3.0f, 53.0f, 97.0f, 286.0f}, 2);
        Assert.assertEquals((double)1.0, (double)array.get(0), (double)1.0E-5);
        Assert.assertEquals((double)3.0, (double)array.get(1), (double)1.0E-5);
        Assert.assertEquals((long)2L, (long)array.size());
        float[] p = array.getClone();
        Assert.assertEquals((long)2L, (long)p.length);
        p[0] = 8.0f;
        p[1] = 7.0f;
        Assert.assertEquals((double)1.0, (double)array.get(0), (double)1.0E-5);
        Assert.assertEquals((double)3.0, (double)array.get(1), (double)1.0E-5);
        Assert.assertEquals((long)2L, (long)array.size());
    }

    public static Test suite() {
        return new JUnit4TestAdapter(FloatArrayWritableTest.class);
    }
}

