/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.array;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import tl.lin.data.array.ShortArrayWritable;

public class ShortArrayWritableTest {
    @org.junit.Test
    public void testBasic1() throws IOException {
        ShortArrayWritable array1 = new ShortArrayWritable(new short[]{1, 3, 53, 97, 286});
        Assert.assertEquals((long)1L, (long)array1.get(0));
        Assert.assertEquals((long)3L, (long)array1.get(1));
        Assert.assertEquals((long)53L, (long)array1.get(2));
        Assert.assertEquals((long)97L, (long)array1.get(3));
        Assert.assertEquals((long)286L, (long)array1.get(4));
        Assert.assertEquals((long)5L, (long)array1.size());
        ShortArrayWritable array2 = new ShortArrayWritable(new short[]{1, 3, 53, 97, 286}, 3);
        Assert.assertEquals((long)1L, (long)array2.get(0));
        Assert.assertEquals((long)3L, (long)array2.get(1));
        Assert.assertEquals((long)53L, (long)array2.get(2));
        Assert.assertEquals((long)3L, (long)array2.size());
        ShortArrayWritable array3 = new ShortArrayWritable(new short[0]);
        Assert.assertEquals((long)0L, (long)array3.size());
    }

    @org.junit.Test
    public void testBasic2() throws IOException {
        ShortArrayWritable array = new ShortArrayWritable();
        Assert.assertEquals((long)0L, (long)array.size());
        short[] list1 = new short[]{1, 3, 53, 97, 286};
        array.setArray(list1);
        Assert.assertEquals((long)1L, (long)array.get(0));
        Assert.assertEquals((long)3L, (long)array.get(1));
        Assert.assertEquals((long)53L, (long)array.get(2));
        Assert.assertEquals((long)97L, (long)array.get(3));
        Assert.assertEquals((long)286L, (long)array.get(4));
        Assert.assertEquals((long)list1.length, (long)array.size());
        array.set(0, (short)2);
        array.set(3, (short)-5);
        Assert.assertEquals((long)2L, (long)array.get(0));
        Assert.assertEquals((long)-5L, (long)array.get(3));
        short[] list2 = new short[]{9, -1, 6, 22, 76};
        array.setArray(list2, 3);
        Assert.assertEquals((long)9L, (long)array.get(0));
        Assert.assertEquals((long)-1L, (long)array.get(1));
        Assert.assertEquals((long)6L, (long)array.get(2));
        Assert.assertEquals((long)3L, (long)array.size());
        array.setArray(null);
        Assert.assertEquals((long)0L, (long)array.size());
        Assert.assertEquals((long)0L, (long)array.getArray().length);
    }

    @org.junit.Test
    public void testSerialize1() throws IOException {
        ShortArrayWritable array = new ShortArrayWritable(new short[]{1, 3, 53, 97, 286});
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        array.write((DataOutput)dataOut);
        ShortArrayWritable array2 = new ShortArrayWritable();
        array2.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((long)5L, (long)array2.size());
        Assert.assertEquals((long)1L, (long)array2.get(0));
        Assert.assertEquals((long)3L, (long)array2.get(1));
        Assert.assertEquals((long)53L, (long)array2.get(2));
        Assert.assertEquals((long)97L, (long)array2.get(3));
        Assert.assertEquals((long)286L, (long)array2.get(4));
    }

    @org.junit.Test
    public void testSerialize2() throws IOException {
        ShortArrayWritable array = new ShortArrayWritable(new short[]{1, 3, 53, 97, 286}, 4);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        array.write((DataOutput)dataOut);
        ShortArrayWritable array2 = new ShortArrayWritable();
        array2.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((long)4L, (long)array2.size());
        Assert.assertEquals((long)1L, (long)array2.get(0));
        Assert.assertEquals((long)3L, (long)array2.get(1));
        Assert.assertEquals((long)53L, (long)array2.get(2));
        Assert.assertEquals((long)97L, (long)array2.get(3));
    }

    @org.junit.Test
    public void testSerialize3() throws IOException {
        ShortArrayWritable array = new ShortArrayWritable(new short[]{1, 2, 3, 4, 5});
        ByteArrayOutputStream bytesOut1 = new ByteArrayOutputStream();
        DataOutputStream dataOut1 = new DataOutputStream(bytesOut1);
        array.write((DataOutput)dataOut1);
        ShortArrayWritable array2 = new ShortArrayWritable();
        array2.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut1.toByteArray())));
        Assert.assertEquals((long)5L, (long)array2.size());
        Assert.assertEquals((long)1L, (long)array2.get(0));
        Assert.assertEquals((long)2L, (long)array2.get(1));
        Assert.assertEquals((long)3L, (long)array2.get(2));
        Assert.assertEquals((long)4L, (long)array2.get(3));
        Assert.assertEquals((long)5L, (long)array2.get(4));
        array.setArray(new short[]{6, 7});
        ByteArrayOutputStream bytesOut2 = new ByteArrayOutputStream();
        DataOutputStream dataOut2 = new DataOutputStream(bytesOut2);
        array.write((DataOutput)dataOut2);
        ShortArrayWritable array3 = new ShortArrayWritable();
        array3.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut2.toByteArray())));
        Assert.assertEquals((long)2L, (long)array3.size());
        Assert.assertEquals((long)6L, (long)array3.get(0));
        Assert.assertEquals((long)7L, (long)array3.get(1));
    }

    @org.junit.Test
    public void testSerializeEmpty() throws IOException {
        ShortArrayWritable array = new ShortArrayWritable();
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        array.write((DataOutput)dataOut);
        ShortArrayWritable array2 = new ShortArrayWritable();
        array2.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((long)0L, (long)array2.size());
        Assert.assertTrue((array2.getArray() != null ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)array2.getArray().length);
    }

    @org.junit.Test
    public void testClone1() throws IOException {
        ShortArrayWritable array = new ShortArrayWritable(new short[]{1, 3, 53, 97, 286});
        Assert.assertEquals((long)1L, (long)array.get(0));
        Assert.assertEquals((long)3L, (long)array.get(1));
        Assert.assertEquals((long)53L, (long)array.get(2));
        Assert.assertEquals((long)97L, (long)array.get(3));
        Assert.assertEquals((long)286L, (long)array.get(4));
        Assert.assertEquals((long)5L, (long)array.size());
        short[] p = array.getClone();
        p[0] = 8;
        p[1] = 7;
        p[2] = -4;
        Assert.assertEquals((long)1L, (long)array.get(0));
        Assert.assertEquals((long)3L, (long)array.get(1));
        Assert.assertEquals((long)53L, (long)array.get(2));
        Assert.assertEquals((long)5L, (long)array.size());
    }

    @org.junit.Test
    public void testClone2() throws IOException {
        ShortArrayWritable array = new ShortArrayWritable(new short[]{1, 3, 53, 97, 286}, 2);
        Assert.assertEquals((long)1L, (long)array.get(0));
        Assert.assertEquals((long)3L, (long)array.get(1));
        Assert.assertEquals((long)2L, (long)array.size());
        short[] p = array.getClone();
        Assert.assertEquals((long)2L, (long)p.length);
        p[0] = 8;
        p[1] = 7;
        Assert.assertEquals((long)1L, (long)array.get(0));
        Assert.assertEquals((long)3L, (long)array.get(1));
        Assert.assertEquals((long)2L, (long)array.size());
    }

    public static Test suite() {
        return new JUnit4TestAdapter(ShortArrayWritableTest.class);
    }
}

