/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.map;

import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import tl.lin.data.map.HMapKFW;

public class HMapKFWTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        HMapKFW m = new HMapKFW();
        m.put((Comparable)new Text("hi"), 5.0f);
        m.put((Comparable)new Text("there"), 22.0f);
        Assert.assertEquals((long)m.size(), (long)2L);
        Text key = new Text("hi");
        float value = m.get((Comparable)key);
        Assert.assertTrue((value == 5.0f ? 1 : 0) != 0);
        value = m.remove((Comparable)key);
        Assert.assertEquals((long)m.size(), (long)1L);
        key = new Text("there");
        value = m.get((Comparable)key);
        Assert.assertTrue((value == 22.0f ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testSerialize1() throws IOException {
        HMapKFW m1 = new HMapKFW();
        m1.put((Comparable)new Text("hi"), 5.0f);
        m1.put((Comparable)new Text("there"), 22.0f);
        HMapKFW n2 = HMapKFW.create((byte[])m1.serialize());
        Assert.assertEquals((long)n2.size(), (long)2L);
        Text key = new Text("hi");
        float value = n2.get((Comparable)key);
        Assert.assertTrue((value == 5.0f ? 1 : 0) != 0);
        value = n2.remove((Comparable)key);
        Assert.assertEquals((long)n2.size(), (long)1L);
        key = new Text("there");
        value = n2.get((Comparable)key);
        Assert.assertTrue((value == 22.0f ? 1 : 0) != 0);
    }

    @org.junit.Test(expected=IOException.class)
    public void testTypeSafety() throws IOException {
        HMapKFW m1 = new HMapKFW();
        m1.put((Comparable)new Text("hi"), 4.0f);
        m1.put((Comparable)new IntWritable(0), 76.0f);
        HMapKFW m2 = HMapKFW.create((byte[])m1.serialize());
        m2.size();
    }

    @org.junit.Test
    public void testSerializeEmpty() throws IOException {
        HMapKFW m1 = new HMapKFW();
        Assert.assertTrue((m1.size() == 0 ? 1 : 0) != 0);
        HMapKFW m2 = HMapKFW.create((byte[])m1.serialize());
        Assert.assertTrue((m2.size() == 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(HMapKFWTest.class);
    }
}

