/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.map;

import java.util.Random;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import tl.lin.data.map.HMapKS;

public class HMapKSTest {
    @org.junit.Test
    public void testBasic1() {
        int i;
        int size = 100000;
        Random r = new Random();
        short[] shorts = new short[size];
        HMapKS map = new HMapKS();
        for (i = 0; i < size; ++i) {
            short k = (short)r.nextInt(Short.MAX_VALUE);
            map.put((Object)i, k);
            shorts[i] = k;
        }
        for (i = 0; i < size; ++i) {
            short v = map.get((Object)i);
            Assert.assertEquals((long)shorts[i], (long)v);
            Assert.assertTrue((boolean)map.containsKey((Object)i));
        }
    }

    @org.junit.Test
    public void testBasic2() {
        int i;
        int size = 100000;
        Random r = new Random();
        short[] shorts = new short[size];
        String[] strings = new String[size];
        HMapKS map = new HMapKS();
        for (i = 0; i < size; ++i) {
            short k = (short)r.nextInt(Short.MAX_VALUE);
            String s = new Integer(k).toString();
            map.put((Object)s, k);
            shorts[i] = k;
            strings[i] = s;
        }
        for (i = 0; i < size; ++i) {
            short v = map.get((Object)strings[i]);
            Assert.assertEquals((long)shorts[i], (long)v);
            Assert.assertTrue((boolean)map.containsKey((Object)strings[i]));
        }
    }

    @org.junit.Test
    public void testUpdate() {
        int i;
        int size = 100000;
        Random r = new Random();
        short[] shorts = new short[size];
        HMapKS map = new HMapKS();
        for (i = 0; i < size; ++i) {
            short k = (short)r.nextInt(Short.MAX_VALUE);
            map.put((Object)i, k);
            shorts[i] = k;
        }
        Assert.assertEquals((long)size, (long)map.size());
        for (i = 0; i < size; ++i) {
            map.put((Object)i, (short)(shorts[i] + 1));
        }
        Assert.assertEquals((long)size, (long)map.size());
        for (i = 0; i < size; ++i) {
            short v = map.get((Object)i);
            Assert.assertEquals((long)(shorts[i] + 1), (long)v);
            Assert.assertTrue((boolean)map.containsKey((Object)i));
        }
    }

    @org.junit.Test
    public void testIncrement() {
        HMapKS m = new HMapKS();
        Assert.assertEquals((long)0L, (long)m.get((Object)"one"));
        m.increment((Object)"one", (short)1);
        Assert.assertEquals((long)1L, (long)m.get((Object)"one"));
        m.increment((Object)"one", (short)1);
        m.increment((Object)"two", (short)0);
        m.increment((Object)"three", (short)-1);
        Assert.assertEquals((long)2L, (long)m.get((Object)"one"));
        Assert.assertEquals((long)0L, (long)m.get((Object)"two"));
        Assert.assertEquals((long)-1L, (long)m.get((Object)"three"));
    }

    public static Test suite() {
        return new JUnit4TestAdapter(HMapKSTest.class);
    }
}

