/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.map;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import tl.lin.data.map.HMapSIW;

public class HMapSIWTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        HMapSIW m = new HMapSIW();
        m.put((Comparable)((Object)"hi"), 5);
        m.put((Comparable)((Object)"there"), 22);
        Assert.assertEquals((long)2L, (long)m.size());
        Assert.assertEquals((long)5L, (long)m.get((Comparable)((Object)"hi")));
        m.remove((Comparable)((Object)"hi"));
        Assert.assertEquals((long)1L, (long)m.size());
        Assert.assertEquals((long)22L, (long)m.get((Comparable)((Object)"there")));
    }

    @org.junit.Test
    public void testAccent() throws IOException {
        HMapSIW map1 = new HMapSIW();
        map1.put((Comparable)((Object)"\u00e0"), 1);
        map1.put((Comparable)((Object)"\u00e6"), 2);
        map1.put((Comparable)((Object)"\u00e7"), 3);
        map1.put((Comparable)((Object)"\u00fc"), 4);
        Assert.assertEquals((long)1L, (long)map1.get((Comparable)((Object)"\u00e0")));
        Assert.assertEquals((long)2L, (long)map1.get((Comparable)((Object)"\u00e6")));
        Assert.assertEquals((long)3L, (long)map1.get((Comparable)((Object)"\u00e7")));
        Assert.assertEquals((long)4L, (long)map1.get((Comparable)((Object)"\u00fc")));
        map1.increment((Comparable)((Object)"\u00e0"));
        map1.increment((Comparable)((Object)"\u00e6"));
        map1.increment((Comparable)((Object)"\u00e7"));
        map1.increment((Comparable)((Object)"\u00fc"));
        Assert.assertEquals((long)2L, (long)map1.get((Comparable)((Object)"\u00e0")));
        Assert.assertEquals((long)3L, (long)map1.get((Comparable)((Object)"\u00e6")));
        Assert.assertEquals((long)4L, (long)map1.get((Comparable)((Object)"\u00e7")));
        Assert.assertEquals((long)5L, (long)map1.get((Comparable)((Object)"\u00fc")));
        map1.put((Comparable)((Object)"\u00e0"), 10);
        map1.remove((Comparable)((Object)"\u00e6"));
        map1.remove((Comparable)((Object)"\u00e7"));
        map1.put((Comparable)((Object)"\u00e7"), 2);
        map1.increment((Comparable)((Object)"\u00fc"));
        Assert.assertEquals((long)10L, (long)map1.get((Comparable)((Object)"\u00e0")));
        Assert.assertEquals((long)2L, (long)map1.get((Comparable)((Object)"\u00e7")));
        Assert.assertEquals((long)6L, (long)map1.get((Comparable)((Object)"\u00fc")));
        Assert.assertEquals((long)3L, (long)map1.size());
        HMapSIW map2 = HMapSIW.create((byte[])map1.serialize());
        Assert.assertEquals((long)10L, (long)map2.get((Comparable)((Object)"\u00e0")));
        Assert.assertEquals((long)2L, (long)map2.get((Comparable)((Object)"\u00e7")));
        Assert.assertEquals((long)6L, (long)map2.get((Comparable)((Object)"\u00fc")));
    }

    @org.junit.Test
    public void testJp() throws IOException {
        int i;
        int i2;
        String line;
        HMapSIW map1 = new HMapSIW();
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("src/test/resources/jp-sample.txt"), "UTF8"));
        ArrayList list = Lists.newArrayList();
        int cnt = 0;
        while ((line = in.readLine()) != null) {
            list.add(line);
            map1.put((Comparable)((Object)line), cnt++);
        }
        for (i2 = 0; i2 < list.size(); ++i2) {
            Assert.assertEquals((long)i2, (long)map1.get((Comparable)list.get(i2)));
        }
        Assert.assertEquals((long)5L, (long)map1.size());
        for (i2 = 0; i2 < list.size(); ++i2) {
            map1.increment((Comparable)list.get(i2));
        }
        Assert.assertEquals((long)5L, (long)map1.size());
        for (i2 = 0; i2 < list.size(); ++i2) {
            Assert.assertEquals((long)(i2 + 1), (long)map1.get((Comparable)list.get(i2)));
        }
        Assert.assertEquals((long)5L, (long)map1.size());
        HMapSIW map2 = HMapSIW.create((byte[])map1.serialize());
        for (i = 0; i < list.size(); ++i) {
            Assert.assertEquals((long)(i + 1), (long)map2.get((Comparable)list.get(i)));
        }
        Assert.assertEquals((long)5L, (long)map2.size());
        for (i = 0; i < list.size(); ++i) {
            map2.remove((Comparable)list.get(i));
        }
        Assert.assertEquals((long)5L, (long)map1.size());
        Assert.assertEquals((long)0L, (long)map2.size());
        in.close();
    }

    @org.junit.Test
    public void testSerialize1() throws IOException {
        HMapSIW m1 = new HMapSIW();
        m1.put((Comparable)((Object)"hi"), 5);
        m1.put((Comparable)((Object)"there"), 22);
        HMapSIW n2 = HMapSIW.create((byte[])m1.serialize());
        Assert.assertEquals((long)n2.size(), (long)2L);
        String key = "hi";
        float value = n2.get((Comparable)((Object)key));
        Assert.assertTrue((value == 5.0f ? 1 : 0) != 0);
        value = n2.remove((Comparable)((Object)key));
        Assert.assertEquals((long)n2.size(), (long)1L);
        key = "there";
        value = n2.get((Comparable)((Object)key));
        Assert.assertTrue((value == 22.0f ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testSerializeEmpty() throws IOException {
        HMapSIW m1 = new HMapSIW();
        Assert.assertTrue((m1.size() == 0 ? 1 : 0) != 0);
        HMapSIW m2 = HMapSIW.create((byte[])m1.serialize());
        Assert.assertTrue((m2.size() == 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(HMapSIWTest.class);
    }
}

