/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.pair;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.junit.Assert;
import tl.lin.data.WritableComparatorTestHarness;
import tl.lin.data.pair.PairOfLongFloat;

public class PairOfLongFloatTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        PairOfLongFloat pair = new PairOfLongFloat(1L, 2.0f);
        Assert.assertEquals((long)1L, (long)pair.getLeftElement());
        Assert.assertTrue((pair.getRightElement() == 2.0f ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testSerialize() throws IOException {
        PairOfLongFloat origPair = new PairOfLongFloat(1L, 2.0f);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        origPair.write((DataOutput)dataOut);
        PairOfLongFloat pair = new PairOfLongFloat();
        pair.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((long)1L, (long)pair.getLeftElement());
        Assert.assertTrue((pair.getRightElement() == 2.0f ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testComparison1() throws IOException {
        PairOfLongFloat pair1 = new PairOfLongFloat(1L, 2.0f);
        PairOfLongFloat pair2 = new PairOfLongFloat(1L, 2.0f);
        PairOfLongFloat pair3 = new PairOfLongFloat(1L, 1.0f);
        PairOfLongFloat pair4 = new PairOfLongFloat(0L, 9.0f);
        PairOfLongFloat pair5 = new PairOfLongFloat(9L, 0.0f);
        Assert.assertTrue((boolean)pair1.equals((Object)pair2));
        Assert.assertFalse((boolean)pair1.equals((Object)pair3));
        Assert.assertTrue((pair1.compareTo(pair2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair3.compareTo(pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair4.compareTo(pair5) < 0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testComparison2() throws IOException {
        PairOfLongFloat.Comparator comparator = new PairOfLongFloat.Comparator();
        PairOfLongFloat pair1 = new PairOfLongFloat(1L, 2.0f);
        PairOfLongFloat pair2 = new PairOfLongFloat(1L, 2.0f);
        PairOfLongFloat pair3 = new PairOfLongFloat(1L, 1.0f);
        PairOfLongFloat pair4 = new PairOfLongFloat(0L, 9.0f);
        PairOfLongFloat pair5 = new PairOfLongFloat(9L, 0.0f);
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair1, (WritableComparable)pair2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair1, (WritableComparable)pair3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair1, (WritableComparable)pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair1, (WritableComparable)pair5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair3, (WritableComparable)pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair4, (WritableComparable)pair5) < 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(PairOfLongFloatTest.class);
    }
}

