/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.array;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.io.Writable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayListWritable<E extends Writable>
extends ArrayList<E>
implements Writable {
    private static final long serialVersionUID = 4911321393319821791L;

    public ArrayListWritable() {
    }

    public ArrayListWritable(ArrayList<E> array) {
        super(array);
    }

    public void readFields(DataInput in) throws IOException {
        this.clear();
        int numFields = in.readInt();
        if (numFields == 0) {
            return;
        }
        String className = in.readUTF();
        try {
            Class<?> c = Class.forName(className);
            for (int i = 0; i < numFields; ++i) {
                Writable obj = (Writable)c.newInstance();
                obj.readFields(in);
                this.add(obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.size() == 0) {
            return;
        }
        Writable obj = (Writable)this.get(0);
        out.writeUTF(obj.getClass().getCanonicalName());
        for (int i = 0; i < this.size(); ++i) {
            obj = (Writable)this.get(i);
            if (obj == null) {
                throw new IOException("Cannot serialize null fields!");
            }
            obj.write(out);
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (int i = 0; i < this.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(this.get(i));
        }
        sb.append("]");
        return sb.toString();
    }
}

