/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class JsonWritable
implements Writable {
    private static final Gson GSON = new Gson();
    private static final JsonParser PARSER = new JsonParser();
    private JsonObject json;

    public JsonWritable() {
        this.json = new JsonObject();
    }

    public JsonWritable(String s) {
        this.json = (JsonObject)PARSER.parse(s);
    }

    public void readFields(DataInput in) throws IOException {
        int cnt = in.readInt();
        byte[] buf = new byte[cnt];
        in.readFully(buf);
        this.json = (JsonObject)PARSER.parse(new String(buf, "UTF-8"));
    }

    public void write(DataOutput out) throws IOException {
        byte[] buf = GSON.toJson((JsonElement)this.json).getBytes();
        out.writeInt(buf.length);
        out.write(buf);
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        this.write(dataOut);
        return bytesOut.toByteArray();
    }

    public JsonObject getJsonObject() {
        return this.json;
    }

    public String toString() {
        return this.getJsonObject().toString();
    }

    public static JsonWritable create(DataInput in) throws IOException {
        JsonWritable json = new JsonWritable();
        json.readFields(in);
        return json;
    }

    public static JsonWritable create(byte[] bytes) throws IOException {
        return JsonWritable.create(new DataInputStream(new ByteArrayInputStream(bytes)));
    }
}

