/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.array;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.io.Writable;

public class DoubleArrayWritable
implements Writable {
    private double[] array;
    private int length = 0;

    public DoubleArrayWritable() {
    }

    public DoubleArrayWritable(double[] array) {
        this.array = array;
        this.length = array.length;
    }

    public DoubleArrayWritable(double[] array, int length) {
        this.array = array;
        this.length = length;
    }

    public DoubleArrayWritable(int size) {
        this.array = new double[size];
    }

    public void readFields(DataInput in) throws IOException {
        this.length = in.readInt();
        this.array = new double[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.array[i] = in.readDouble();
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.length);
        for (int i = 0; i < this.length; ++i) {
            out.writeDouble(this.array[i]);
        }
    }

    public double[] getClone() {
        double[] copy = new double[this.length];
        System.arraycopy(this.array, 0, copy, 0, this.length);
        return copy;
    }

    public double[] getArray() {
        return this.array;
    }

    public void setArray(double[] array) {
        if (array == null) {
            this.array = new double[0];
            this.length = 0;
            return;
        }
        this.array = array;
        this.length = array.length;
    }

    public void setArray(double[] array, int length) {
        this.array = array;
        this.length = length;
    }

    public double get(int i) {
        return this.array[i];
    }

    public void set(int i, double v) {
        this.array[i] = v;
    }

    public int size() {
        return this.length;
    }

    public String toString() {
        return Arrays.toString(this.array);
    }
}

