/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.array;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.io.Writable;

public class FloatArrayWritable
implements Writable {
    private float[] array;
    private int length = 0;

    public FloatArrayWritable() {
    }

    public FloatArrayWritable(float[] array) {
        this.array = array;
        this.length = array.length;
    }

    public FloatArrayWritable(float[] array, int length) {
        this.array = array;
        this.length = length;
    }

    public FloatArrayWritable(int size) {
        this.array = new float[size];
    }

    public void readFields(DataInput in) throws IOException {
        this.length = in.readInt();
        this.array = new float[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.array[i] = in.readFloat();
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.length);
        for (int i = 0; i < this.length; ++i) {
            out.writeFloat(this.array[i]);
        }
    }

    public float[] getClone() {
        float[] copy = new float[this.length];
        System.arraycopy(this.array, 0, copy, 0, this.length);
        return copy;
    }

    public float[] getArray() {
        return this.array;
    }

    public void setArray(float[] array) {
        if (array == null) {
            this.array = new float[0];
            this.length = 0;
            return;
        }
        this.array = array;
        this.length = array.length;
    }

    public void setArray(float[] array, int length) {
        this.array = array;
        this.length = length;
    }

    public float get(int i) {
        return this.array[i];
    }

    public void set(int i, float v) {
        this.array[i] = v;
    }

    public int size() {
        return this.length;
    }

    public String toString() {
        return Arrays.toString(this.array);
    }
}

