/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.array;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.io.Writable;

public class IntArrayWritable
implements Writable {
    private int[] array;
    private int length = 0;

    public IntArrayWritable() {
    }

    public IntArrayWritable(int[] array) {
        this.array = array;
        this.length = array.length;
    }

    public IntArrayWritable(int[] array, int length) {
        this.array = array;
        this.length = length;
    }

    public IntArrayWritable(int size) {
        this.array = new int[size];
    }

    public void readFields(DataInput in) throws IOException {
        this.length = in.readInt();
        this.array = new int[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.array[i] = in.readInt();
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.length);
        for (int i = 0; i < this.length; ++i) {
            out.writeInt(this.array[i]);
        }
    }

    public int[] getClone() {
        int[] copy = new int[this.length];
        System.arraycopy(this.array, 0, copy, 0, this.length);
        return copy;
    }

    public int[] getArray() {
        return this.array;
    }

    public void setArray(int[] array) {
        if (array == null) {
            this.array = new int[0];
            this.length = 0;
            return;
        }
        this.array = array;
        this.length = array.length;
    }

    public void setArray(int[] array, int length) {
        this.array = array;
        this.length = length;
    }

    public int get(int i) {
        return this.array[i];
    }

    public void set(int i, int v) {
        this.array[i] = v;
    }

    public int size() {
        return this.length;
    }

    public String toString() {
        return Arrays.toString(this.array);
    }
}

